<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Subscription.SwitchToEventBasedPricingValidationSubscriptionInfo
 * StructType
 * @subpackage Structs
 */
class BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The EventTotalPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $EventTotalPrice;
    /**
     * The PriceLevelId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceLevelId;
    /**
     * The PriceTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PriceTypeId;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The SubscriptionPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $SubscriptionPrice;
    /**
     * The UnallocatedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $UnallocatedPrice;
    /**
     * Constructor method for
     * BizAction.Subscription.SwitchToEventBasedPricingValidationSubscriptionInfo
     * @uses BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo::setClientId()
     * @uses BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo::setEventTotalPrice()
     * @uses BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo::setPriceLevelId()
     * @uses BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo::setPriceTypeId()
     * @uses BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo::setSubscriptionNumber()
     * @uses BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo::setSubscriptionPrice()
     * @uses BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo::setUnallocatedPrice()
     * @param string $clientId
     * @param \patest\StructType\Money $eventTotalPrice
     * @param string $priceLevelId
     * @param string $priceTypeId
     * @param string $subscriptionNumber
     * @param \patest\StructType\Money $subscriptionPrice
     * @param \patest\StructType\Money $unallocatedPrice
     */
    public function __construct($clientId = null, \patest\StructType\Money $eventTotalPrice = null, $priceLevelId = null, $priceTypeId = null, $subscriptionNumber = null, \patest\StructType\Money $subscriptionPrice = null, \patest\StructType\Money $unallocatedPrice = null)
    {
        $this
            ->setClientId($clientId)
            ->setEventTotalPrice($eventTotalPrice)
            ->setPriceLevelId($priceLevelId)
            ->setPriceTypeId($priceTypeId)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setSubscriptionPrice($subscriptionPrice)
            ->setUnallocatedPrice($unallocatedPrice);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get EventTotalPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getEventTotalPrice()
    {
        return isset($this->EventTotalPrice) ? $this->EventTotalPrice : null;
    }
    /**
     * Set EventTotalPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $eventTotalPrice
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo
     */
    public function setEventTotalPrice(\patest\StructType\Money $eventTotalPrice = null)
    {
        if (is_null($eventTotalPrice) || (is_array($eventTotalPrice) && empty($eventTotalPrice))) {
            unset($this->EventTotalPrice);
        } else {
            $this->EventTotalPrice = $eventTotalPrice;
        }
        return $this;
    }
    /**
     * Get PriceLevelId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelId()
    {
        return isset($this->PriceLevelId) ? $this->PriceLevelId : null;
    }
    /**
     * Set PriceLevelId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelId
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo
     */
    public function setPriceLevelId($priceLevelId = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelId) && !is_string($priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelId, true), gettype($priceLevelId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceLevelId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceLevelId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceLevelId, true)), __LINE__);
        }
        if (is_null($priceLevelId) || (is_array($priceLevelId) && empty($priceLevelId))) {
            unset($this->PriceLevelId);
        } else {
            $this->PriceLevelId = $priceLevelId;
        }
        return $this;
    }
    /**
     * Get PriceTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeId()
    {
        return isset($this->PriceTypeId) ? $this->PriceTypeId : null;
    }
    /**
     * Set PriceTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeId
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo
     */
    public function setPriceTypeId($priceTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeId) && !is_string($priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeId, true), gettype($priceTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($priceTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $priceTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($priceTypeId, true)), __LINE__);
        }
        if (is_null($priceTypeId) || (is_array($priceTypeId) && empty($priceTypeId))) {
            unset($this->PriceTypeId);
        } else {
            $this->PriceTypeId = $priceTypeId;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get SubscriptionPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getSubscriptionPrice()
    {
        return isset($this->SubscriptionPrice) ? $this->SubscriptionPrice : null;
    }
    /**
     * Set SubscriptionPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $subscriptionPrice
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo
     */
    public function setSubscriptionPrice(\patest\StructType\Money $subscriptionPrice = null)
    {
        if (is_null($subscriptionPrice) || (is_array($subscriptionPrice) && empty($subscriptionPrice))) {
            unset($this->SubscriptionPrice);
        } else {
            $this->SubscriptionPrice = $subscriptionPrice;
        }
        return $this;
    }
    /**
     * Get UnallocatedPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getUnallocatedPrice()
    {
        return isset($this->UnallocatedPrice) ? $this->UnallocatedPrice : null;
    }
    /**
     * Set UnallocatedPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $unallocatedPrice
     * @return \patest\StructType\BizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo
     */
    public function setUnallocatedPrice(\patest\StructType\Money $unallocatedPrice = null)
    {
        if (is_null($unallocatedPrice) || (is_array($unallocatedPrice) && empty($unallocatedPrice))) {
            unset($this->UnallocatedPrice);
        } else {
            $this->UnallocatedPrice = $unallocatedPrice;
        }
        return $this;
    }
}
