<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Subscription.SwitchSeriesDefinitionToEventBasedPricing.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Subscription_SwitchSeriesDefinitionToEventBasedPricing_Request extends AnyEntity
{
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The ShouldCopyAllocationsFromSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldCopyAllocationsFromSeries;
    /**
     * Constructor method for
     * BizAction.Subscription.SwitchSeriesDefinitionToEventBasedPricing.Request
     * @uses BizAction_Subscription_SwitchSeriesDefinitionToEventBasedPricing_Request::setSeriesId()
     * @uses BizAction_Subscription_SwitchSeriesDefinitionToEventBasedPricing_Request::setShouldCopyAllocationsFromSeries()
     * @param string $seriesId
     * @param bool $shouldCopyAllocationsFromSeries
     */
    public function __construct($seriesId = null, $shouldCopyAllocationsFromSeries = null)
    {
        $this
            ->setSeriesId($seriesId)
            ->setShouldCopyAllocationsFromSeries($shouldCopyAllocationsFromSeries);
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\BizAction_Subscription_SwitchSeriesDefinitionToEventBasedPricing_Request
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get ShouldCopyAllocationsFromSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldCopyAllocationsFromSeries()
    {
        return isset($this->ShouldCopyAllocationsFromSeries) ? $this->ShouldCopyAllocationsFromSeries : null;
    }
    /**
     * Set ShouldCopyAllocationsFromSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldCopyAllocationsFromSeries
     * @return \patest\StructType\BizAction_Subscription_SwitchSeriesDefinitionToEventBasedPricing_Request
     */
    public function setShouldCopyAllocationsFromSeries($shouldCopyAllocationsFromSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldCopyAllocationsFromSeries) && !is_bool($shouldCopyAllocationsFromSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldCopyAllocationsFromSeries, true), gettype($shouldCopyAllocationsFromSeries)), __LINE__);
        }
        if (is_null($shouldCopyAllocationsFromSeries) || (is_array($shouldCopyAllocationsFromSeries) && empty($shouldCopyAllocationsFromSeries))) {
            unset($this->ShouldCopyAllocationsFromSeries);
        } else {
            $this->ShouldCopyAllocationsFromSeries = $shouldCopyAllocationsFromSeries;
        }
        return $this;
    }
}
