<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Subscription.InitiateSubsTicketsAllocationOnSwitchPricingToEventBased.
 * Request StructType
 * @subpackage Structs
 */
class BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request extends AnyEntity
{
    /**
     * The AlreadyLinkedEventsToSeriesCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AlreadyLinkedEventsToSeriesCount;
    /**
     * The HasSubscriptionsProblems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasSubscriptionsProblems;
    /**
     * The IsMatchingByPriceRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsMatchingByPriceRequired;
    /**
     * The IsPartialEventBased
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPartialEventBased;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * The SubscriptionsInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo
     */
    public $SubscriptionsInfo;
    /**
     * Constructor method for
     * BizAction.Subscription.InitiateSubsTicketsAllocationOnSwitchPricingToEventBased.
     * Request
     * @uses BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request::setAlreadyLinkedEventsToSeriesCount()
     * @uses BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request::setHasSubscriptionsProblems()
     * @uses BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request::setIsMatchingByPriceRequired()
     * @uses BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request::setIsPartialEventBased()
     * @uses BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request::setSeriesId()
     * @uses BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request::setSubscriptionsInfo()
     * @param int $alreadyLinkedEventsToSeriesCount
     * @param bool $hasSubscriptionsProblems
     * @param bool $isMatchingByPriceRequired
     * @param bool $isPartialEventBased
     * @param string $seriesId
     * @param \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo $subscriptionsInfo
     */
    public function __construct($alreadyLinkedEventsToSeriesCount = null, $hasSubscriptionsProblems = null, $isMatchingByPriceRequired = null, $isPartialEventBased = null, $seriesId = null, \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo $subscriptionsInfo = null)
    {
        $this
            ->setAlreadyLinkedEventsToSeriesCount($alreadyLinkedEventsToSeriesCount)
            ->setHasSubscriptionsProblems($hasSubscriptionsProblems)
            ->setIsMatchingByPriceRequired($isMatchingByPriceRequired)
            ->setIsPartialEventBased($isPartialEventBased)
            ->setSeriesId($seriesId)
            ->setSubscriptionsInfo($subscriptionsInfo);
    }
    /**
     * Get AlreadyLinkedEventsToSeriesCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAlreadyLinkedEventsToSeriesCount()
    {
        return isset($this->AlreadyLinkedEventsToSeriesCount) ? $this->AlreadyLinkedEventsToSeriesCount : null;
    }
    /**
     * Set AlreadyLinkedEventsToSeriesCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $alreadyLinkedEventsToSeriesCount
     * @return \patest\StructType\BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request
     */
    public function setAlreadyLinkedEventsToSeriesCount($alreadyLinkedEventsToSeriesCount = null)
    {
        // validation for constraint: int
        if (!is_null($alreadyLinkedEventsToSeriesCount) && !(is_int($alreadyLinkedEventsToSeriesCount) || ctype_digit($alreadyLinkedEventsToSeriesCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($alreadyLinkedEventsToSeriesCount, true), gettype($alreadyLinkedEventsToSeriesCount)), __LINE__);
        }
        if (is_null($alreadyLinkedEventsToSeriesCount) || (is_array($alreadyLinkedEventsToSeriesCount) && empty($alreadyLinkedEventsToSeriesCount))) {
            unset($this->AlreadyLinkedEventsToSeriesCount);
        } else {
            $this->AlreadyLinkedEventsToSeriesCount = $alreadyLinkedEventsToSeriesCount;
        }
        return $this;
    }
    /**
     * Get HasSubscriptionsProblems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasSubscriptionsProblems()
    {
        return isset($this->HasSubscriptionsProblems) ? $this->HasSubscriptionsProblems : null;
    }
    /**
     * Set HasSubscriptionsProblems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasSubscriptionsProblems
     * @return \patest\StructType\BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request
     */
    public function setHasSubscriptionsProblems($hasSubscriptionsProblems = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasSubscriptionsProblems) && !is_bool($hasSubscriptionsProblems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasSubscriptionsProblems, true), gettype($hasSubscriptionsProblems)), __LINE__);
        }
        if (is_null($hasSubscriptionsProblems) || (is_array($hasSubscriptionsProblems) && empty($hasSubscriptionsProblems))) {
            unset($this->HasSubscriptionsProblems);
        } else {
            $this->HasSubscriptionsProblems = $hasSubscriptionsProblems;
        }
        return $this;
    }
    /**
     * Get IsMatchingByPriceRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsMatchingByPriceRequired()
    {
        return isset($this->IsMatchingByPriceRequired) ? $this->IsMatchingByPriceRequired : null;
    }
    /**
     * Set IsMatchingByPriceRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isMatchingByPriceRequired
     * @return \patest\StructType\BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request
     */
    public function setIsMatchingByPriceRequired($isMatchingByPriceRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isMatchingByPriceRequired) && !is_bool($isMatchingByPriceRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isMatchingByPriceRequired, true), gettype($isMatchingByPriceRequired)), __LINE__);
        }
        if (is_null($isMatchingByPriceRequired) || (is_array($isMatchingByPriceRequired) && empty($isMatchingByPriceRequired))) {
            unset($this->IsMatchingByPriceRequired);
        } else {
            $this->IsMatchingByPriceRequired = $isMatchingByPriceRequired;
        }
        return $this;
    }
    /**
     * Get IsPartialEventBased value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPartialEventBased()
    {
        return isset($this->IsPartialEventBased) ? $this->IsPartialEventBased : null;
    }
    /**
     * Set IsPartialEventBased value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPartialEventBased
     * @return \patest\StructType\BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request
     */
    public function setIsPartialEventBased($isPartialEventBased = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPartialEventBased) && !is_bool($isPartialEventBased)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPartialEventBased, true), gettype($isPartialEventBased)), __LINE__);
        }
        if (is_null($isPartialEventBased) || (is_array($isPartialEventBased) && empty($isPartialEventBased))) {
            unset($this->IsPartialEventBased);
        } else {
            $this->IsPartialEventBased = $isPartialEventBased;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
    /**
     * Get SubscriptionsInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo|null
     */
    public function getSubscriptionsInfo()
    {
        return isset($this->SubscriptionsInfo) ? $this->SubscriptionsInfo : null;
    }
    /**
     * Set SubscriptionsInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo $subscriptionsInfo
     * @return \patest\StructType\BizAction_Subscription_InitiateSubsTicketsAllocationOnSwitchPricingToEventBased_Request
     */
    public function setSubscriptionsInfo(\patest\StructType\RecordSetOfBizAction_Subscription_SwitchToEventBasedPricingValidationSubscriptionInfo $subscriptionsInfo = null)
    {
        if (is_null($subscriptionsInfo) || (is_array($subscriptionsInfo) && empty($subscriptionsInfo))) {
            unset($this->SubscriptionsInfo);
        } else {
            $this->SubscriptionsInfo = $subscriptionsInfo;
        }
        return $this;
    }
}
