<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Security.LogIntoOrgUnit.Request StructType
 * @subpackage Structs
 */
class BizAction_Security_LogIntoOrgUnit_Request extends AnyEntity
{
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ReturnToDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnToDefault;
    /**
     * Constructor method for BizAction.Security.LogIntoOrgUnit.Request
     * @uses BizAction_Security_LogIntoOrgUnit_Request::setOrganizationUnitId()
     * @uses BizAction_Security_LogIntoOrgUnit_Request::setReturnToDefault()
     * @param string $organizationUnitId
     * @param bool $returnToDefault
     */
    public function __construct($organizationUnitId = null, $returnToDefault = null)
    {
        $this
            ->setOrganizationUnitId($organizationUnitId)
            ->setReturnToDefault($returnToDefault);
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\BizAction_Security_LogIntoOrgUnit_Request
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ReturnToDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnToDefault()
    {
        return isset($this->ReturnToDefault) ? $this->ReturnToDefault : null;
    }
    /**
     * Set ReturnToDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnToDefault
     * @return \patest\StructType\BizAction_Security_LogIntoOrgUnit_Request
     */
    public function setReturnToDefault($returnToDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnToDefault) && !is_bool($returnToDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnToDefault, true), gettype($returnToDefault)), __LINE__);
        }
        if (is_null($returnToDefault) || (is_array($returnToDefault) && empty($returnToDefault))) {
            unset($this->ReturnToDefault);
        } else {
            $this->ReturnToDefault = $returnToDefault;
        }
        return $this;
    }
}
