<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.UnpayForPaidItems.Request StructType
 * @subpackage Structs
 */
class BizAction_Sales_UnpayForPaidItems_Request extends AnyEntity
{
    /**
     * The EditedTotalToUnpay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $EditedTotalToUnpay;
    /**
     * The ItemsToUnpay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_FinancialJournalTargetSummary
     */
    public $ItemsToUnpay;
    /**
     * The TotalToUnpay
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $TotalToUnpay;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for BizAction.Sales.UnpayForPaidItems.Request
     * @uses BizAction_Sales_UnpayForPaidItems_Request::setEditedTotalToUnpay()
     * @uses BizAction_Sales_UnpayForPaidItems_Request::setItemsToUnpay()
     * @uses BizAction_Sales_UnpayForPaidItems_Request::setTotalToUnpay()
     * @uses BizAction_Sales_UnpayForPaidItems_Request::setTransactionGuid()
     * @param \patest\StructType\Money $editedTotalToUnpay
     * @param \patest\StructType\RecordSetOfSales_FinancialJournalTargetSummary $itemsToUnpay
     * @param \patest\StructType\Money $totalToUnpay
     * @param string $transactionGuid
     */
    public function __construct(\patest\StructType\Money $editedTotalToUnpay = null, \patest\StructType\RecordSetOfSales_FinancialJournalTargetSummary $itemsToUnpay = null, \patest\StructType\Money $totalToUnpay = null, $transactionGuid = null)
    {
        $this
            ->setEditedTotalToUnpay($editedTotalToUnpay)
            ->setItemsToUnpay($itemsToUnpay)
            ->setTotalToUnpay($totalToUnpay)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get EditedTotalToUnpay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getEditedTotalToUnpay()
    {
        return isset($this->EditedTotalToUnpay) ? $this->EditedTotalToUnpay : null;
    }
    /**
     * Set EditedTotalToUnpay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $editedTotalToUnpay
     * @return \patest\StructType\BizAction_Sales_UnpayForPaidItems_Request
     */
    public function setEditedTotalToUnpay(\patest\StructType\Money $editedTotalToUnpay = null)
    {
        if (is_null($editedTotalToUnpay) || (is_array($editedTotalToUnpay) && empty($editedTotalToUnpay))) {
            unset($this->EditedTotalToUnpay);
        } else {
            $this->EditedTotalToUnpay = $editedTotalToUnpay;
        }
        return $this;
    }
    /**
     * Get ItemsToUnpay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_FinancialJournalTargetSummary|null
     */
    public function getItemsToUnpay()
    {
        return isset($this->ItemsToUnpay) ? $this->ItemsToUnpay : null;
    }
    /**
     * Set ItemsToUnpay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_FinancialJournalTargetSummary $itemsToUnpay
     * @return \patest\StructType\BizAction_Sales_UnpayForPaidItems_Request
     */
    public function setItemsToUnpay(\patest\StructType\RecordSetOfSales_FinancialJournalTargetSummary $itemsToUnpay = null)
    {
        if (is_null($itemsToUnpay) || (is_array($itemsToUnpay) && empty($itemsToUnpay))) {
            unset($this->ItemsToUnpay);
        } else {
            $this->ItemsToUnpay = $itemsToUnpay;
        }
        return $this;
    }
    /**
     * Get TotalToUnpay value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getTotalToUnpay()
    {
        return isset($this->TotalToUnpay) ? $this->TotalToUnpay : null;
    }
    /**
     * Set TotalToUnpay value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $totalToUnpay
     * @return \patest\StructType\BizAction_Sales_UnpayForPaidItems_Request
     */
    public function setTotalToUnpay(\patest\StructType\Money $totalToUnpay = null)
    {
        if (is_null($totalToUnpay) || (is_array($totalToUnpay) && empty($totalToUnpay))) {
            unset($this->TotalToUnpay);
        } else {
            $this->TotalToUnpay = $totalToUnpay;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Sales_UnpayForPaidItems_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
