<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Sales.BenefitPackages.SetWaiveStatus.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Sales_BenefitPackages_SetWaiveStatus_Request extends AnyEntity
{
    /**
     * The InstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $InstanceId;
    /**
     * The Toggle
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Toggle;
    /**
     * The Value
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Value;
    /**
     * Constructor method for BizAction.Sales.BenefitPackages.SetWaiveStatus.Request
     * @uses BizAction_Sales_BenefitPackages_SetWaiveStatus_Request::setInstanceId()
     * @uses BizAction_Sales_BenefitPackages_SetWaiveStatus_Request::setToggle()
     * @uses BizAction_Sales_BenefitPackages_SetWaiveStatus_Request::setValue()
     * @param string $instanceId
     * @param bool $toggle
     * @param bool $value
     */
    public function __construct($instanceId = null, $toggle = null, $value = null)
    {
        $this
            ->setInstanceId($instanceId)
            ->setToggle($toggle)
            ->setValue($value);
    }
    /**
     * Get InstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstanceId()
    {
        return isset($this->InstanceId) ? $this->InstanceId : null;
    }
    /**
     * Set InstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instanceId
     * @return \patest\StructType\BizAction_Sales_BenefitPackages_SetWaiveStatus_Request
     */
    public function setInstanceId($instanceId = null)
    {
        // validation for constraint: string
        if (!is_null($instanceId) && !is_string($instanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($instanceId, true), gettype($instanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($instanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $instanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($instanceId, true)), __LINE__);
        }
        if (is_null($instanceId) || (is_array($instanceId) && empty($instanceId))) {
            unset($this->InstanceId);
        } else {
            $this->InstanceId = $instanceId;
        }
        return $this;
    }
    /**
     * Get Toggle value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getToggle()
    {
        return isset($this->Toggle) ? $this->Toggle : null;
    }
    /**
     * Set Toggle value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $toggle
     * @return \patest\StructType\BizAction_Sales_BenefitPackages_SetWaiveStatus_Request
     */
    public function setToggle($toggle = null)
    {
        // validation for constraint: boolean
        if (!is_null($toggle) && !is_bool($toggle)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($toggle, true), gettype($toggle)), __LINE__);
        }
        if (is_null($toggle) || (is_array($toggle) && empty($toggle))) {
            unset($this->Toggle);
        } else {
            $this->Toggle = $toggle;
        }
        return $this;
    }
    /**
     * Get Value value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getValue()
    {
        return isset($this->Value) ? $this->Value : null;
    }
    /**
     * Set Value value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $value
     * @return \patest\StructType\BizAction_Sales_BenefitPackages_SetWaiveStatus_Request
     */
    public function setValue($value = null)
    {
        // validation for constraint: boolean
        if (!is_null($value) && !is_bool($value)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($value, true), gettype($value)), __LINE__);
        }
        if (is_null($value) || (is_array($value) && empty($value))) {
            unset($this->Value);
        } else {
            $this->Value = $value;
        }
        return $this;
    }
}
