<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Sales.BenefitPackages.CancelOneUtilization.Request StructType
 * @subpackage Structs
 */
class BizAction_Sales_BenefitPackages_CancelOneUtilization_Request extends AnyEntity
{
    /**
     * The HistoryRecordId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HistoryRecordId;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * Constructor method for
     * BizAction.Sales.BenefitPackages.CancelOneUtilization.Request
     * @uses BizAction_Sales_BenefitPackages_CancelOneUtilization_Request::setHistoryRecordId()
     * @uses BizAction_Sales_BenefitPackages_CancelOneUtilization_Request::setNote()
     * @param string $historyRecordId
     * @param string $note
     */
    public function __construct($historyRecordId = null, $note = null)
    {
        $this
            ->setHistoryRecordId($historyRecordId)
            ->setNote($note);
    }
    /**
     * Get HistoryRecordId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHistoryRecordId()
    {
        return isset($this->HistoryRecordId) ? $this->HistoryRecordId : null;
    }
    /**
     * Set HistoryRecordId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $historyRecordId
     * @return \patest\StructType\BizAction_Sales_BenefitPackages_CancelOneUtilization_Request
     */
    public function setHistoryRecordId($historyRecordId = null)
    {
        // validation for constraint: string
        if (!is_null($historyRecordId) && !is_string($historyRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($historyRecordId, true), gettype($historyRecordId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($historyRecordId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $historyRecordId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($historyRecordId, true)), __LINE__);
        }
        if (is_null($historyRecordId) || (is_array($historyRecordId) && empty($historyRecordId))) {
            unset($this->HistoryRecordId);
        } else {
            $this->HistoryRecordId = $historyRecordId;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\BizAction_Sales_BenefitPackages_CancelOneUtilization_Request
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
}
