<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Sale.Accounting.RecalculateInvoiceDueDate.Request StructType
 * @subpackage Structs
 */
class BizAction_Sale_Accounting_RecalculateInvoiceDueDate_Request extends AnyEntity
{
    /**
     * The OldDueDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OldDueDate;
    /**
     * The PaymentTermsId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTermsId;
    /**
     * The TransactionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TransactionIds
     */
    public $TransactionIds;
    /**
     * Constructor method for
     * BizAction.Sale.Accounting.RecalculateInvoiceDueDate.Request
     * @uses BizAction_Sale_Accounting_RecalculateInvoiceDueDate_Request::setOldDueDate()
     * @uses BizAction_Sale_Accounting_RecalculateInvoiceDueDate_Request::setPaymentTermsId()
     * @uses BizAction_Sale_Accounting_RecalculateInvoiceDueDate_Request::setTransactionIds()
     * @param string $oldDueDate
     * @param string $paymentTermsId
     * @param \patest\StructType\TransactionIds $transactionIds
     */
    public function __construct($oldDueDate = null, $paymentTermsId = null, \patest\StructType\TransactionIds $transactionIds = null)
    {
        $this
            ->setOldDueDate($oldDueDate)
            ->setPaymentTermsId($paymentTermsId)
            ->setTransactionIds($transactionIds);
    }
    /**
     * Get OldDueDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOldDueDate()
    {
        return isset($this->OldDueDate) ? $this->OldDueDate : null;
    }
    /**
     * Set OldDueDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $oldDueDate
     * @return \patest\StructType\BizAction_Sale_Accounting_RecalculateInvoiceDueDate_Request
     */
    public function setOldDueDate($oldDueDate = null)
    {
        // validation for constraint: string
        if (!is_null($oldDueDate) && !is_string($oldDueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($oldDueDate, true), gettype($oldDueDate)), __LINE__);
        }
        if (is_null($oldDueDate) || (is_array($oldDueDate) && empty($oldDueDate))) {
            unset($this->OldDueDate);
        } else {
            $this->OldDueDate = $oldDueDate;
        }
        return $this;
    }
    /**
     * Get PaymentTermsId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTermsId()
    {
        return isset($this->PaymentTermsId) ? $this->PaymentTermsId : null;
    }
    /**
     * Set PaymentTermsId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTermsId
     * @return \patest\StructType\BizAction_Sale_Accounting_RecalculateInvoiceDueDate_Request
     */
    public function setPaymentTermsId($paymentTermsId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTermsId) && !is_string($paymentTermsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTermsId, true), gettype($paymentTermsId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTermsId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTermsId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTermsId, true)), __LINE__);
        }
        if (is_null($paymentTermsId) || (is_array($paymentTermsId) && empty($paymentTermsId))) {
            unset($this->PaymentTermsId);
        } else {
            $this->PaymentTermsId = $paymentTermsId;
        }
        return $this;
    }
    /**
     * Get TransactionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TransactionIds|null
     */
    public function getTransactionIds()
    {
        return isset($this->TransactionIds) ? $this->TransactionIds : null;
    }
    /**
     * Set TransactionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TransactionIds $transactionIds
     * @return \patest\StructType\BizAction_Sale_Accounting_RecalculateInvoiceDueDate_Request
     */
    public function setTransactionIds(\patest\StructType\TransactionIds $transactionIds = null)
    {
        if (is_null($transactionIds) || (is_array($transactionIds) && empty($transactionIds))) {
            unset($this->TransactionIds);
        } else {
            $this->TransactionIds = $transactionIds;
        }
        return $this;
    }
}
