<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Reporting.Script.Delete.Request StructType
 * @subpackage Structs
 */
class BizAction_Reporting_Script_Delete_Request extends AnyEntity
{
    /**
     * The ScriptId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ScriptId;
    /**
     * Constructor method for BizAction.Reporting.Script.Delete.Request
     * @uses BizAction_Reporting_Script_Delete_Request::setScriptId()
     * @param string $scriptId
     */
    public function __construct($scriptId = null)
    {
        $this
            ->setScriptId($scriptId);
    }
    /**
     * Get ScriptId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScriptId()
    {
        return isset($this->ScriptId) ? $this->ScriptId : null;
    }
    /**
     * Set ScriptId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scriptId
     * @return \patest\StructType\BizAction_Reporting_Script_Delete_Request
     */
    public function setScriptId($scriptId = null)
    {
        // validation for constraint: string
        if (!is_null($scriptId) && !is_string($scriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scriptId, true), gettype($scriptId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($scriptId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $scriptId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($scriptId, true)), __LINE__);
        }
        if (is_null($scriptId) || (is_array($scriptId) && empty($scriptId))) {
            unset($this->ScriptId);
        } else {
            $this->ScriptId = $scriptId;
        }
        return $this;
    }
}
