<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.PrintItems.Request StructType
 * @subpackage Structs
 */
class BizAction_Printing_PrintItems_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The ItemsPrintData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_ItemsPrintData
     */
    public $ItemsPrintData;
    /**
     * Constructor method for BizAction.Printing.PrintItems.Request
     * @uses BizAction_Printing_PrintItems_Request::setClientId()
     * @uses BizAction_Printing_PrintItems_Request::setItemsPrintData()
     * @param string $clientId
     * @param \patest\StructType\RecordSetOfPrinting_ItemsPrintData $itemsPrintData
     */
    public function __construct($clientId = null, \patest\StructType\RecordSetOfPrinting_ItemsPrintData $itemsPrintData = null)
    {
        $this
            ->setClientId($clientId)
            ->setItemsPrintData($itemsPrintData);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Printing_PrintItems_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get ItemsPrintData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_ItemsPrintData|null
     */
    public function getItemsPrintData()
    {
        return isset($this->ItemsPrintData) ? $this->ItemsPrintData : null;
    }
    /**
     * Set ItemsPrintData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_ItemsPrintData $itemsPrintData
     * @return \patest\StructType\BizAction_Printing_PrintItems_Request
     */
    public function setItemsPrintData(\patest\StructType\RecordSetOfPrinting_ItemsPrintData $itemsPrintData = null)
    {
        if (is_null($itemsPrintData) || (is_array($itemsPrintData) && empty($itemsPrintData))) {
            unset($this->ItemsPrintData);
        } else {
            $this->ItemsPrintData = $itemsPrintData;
        }
        return $this;
    }
}
