<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.BatchPrint.Tickets.Request StructType
 * @subpackage Structs
 */
class BizAction_Printing_BatchPrint_Tickets_Request extends BizAction_Printing_BatchPrint_Request_Base
{
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The CollectionMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectionMethod;
    /**
     * The DefaultCardType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultCardType;
    /**
     * The DefaultSeriesIdToLoad
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultSeriesIdToLoad;
    /**
     * The EventExtendedData1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventExtendedData1;
    /**
     * The EventFromDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventFromDate;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The EventOwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventOwnerId;
    /**
     * The EventToDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventToDate;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The IncludeAgentTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeAgentTickets;
    /**
     * The IncludeHospitalityTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeHospitalityTickets;
    /**
     * The IncludeLoadedOnCardTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeLoadedOnCardTickets;
    /**
     * The IncludeMarketDriven
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeMarketDriven;
    /**
     * The IncludeMovedTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeMovedTickets;
    /**
     * The IncludeTicketsInSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeTicketsInSubscription;
    /**
     * The IncludeTransferredResoldTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IncludeTransferredResoldTickets;
    /**
     * The IsTicketSchemesReservationsFeatureOn
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTicketSchemesReservationsFeatureOn;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypeIds
     */
    public $PriceTypeIds;
    /**
     * The Printer
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Printer;
    /**
     * The PrintFullTransaction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintFullTransaction;
    /**
     * The PrintOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PrintOperation;
    /**
     * The ReportId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReportId;
    /**
     * The ShowIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ShowIds
     */
    public $ShowIds;
    /**
     * The ShowTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ShowTypeIds
     */
    public $ShowTypeIds;
    /**
     * The TicketSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSchemeId;
    /**
     * The TicketsQtyToPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketsQtyToPrint;
    /**
     * The TicketsSorting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketsSorting;
    /**
     * Constructor method for BizAction.Printing.BatchPrint.Tickets.Request
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setAreaIds()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setCollectionMethod()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setDefaultCardType()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setDefaultSeriesIdToLoad()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setEventExtendedData1()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setEventFromDate()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setEventIds()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setEventOwnerId()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setEventToDate()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setHallId()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setIncludeAgentTickets()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setIncludeHospitalityTickets()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setIncludeLoadedOnCardTickets()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setIncludeMarketDriven()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setIncludeMovedTickets()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setIncludeTicketsInSubscription()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setIncludeTransferredResoldTickets()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setIsTicketSchemesReservationsFeatureOn()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setPriceTypeIds()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setPrinter()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setPrintFullTransaction()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setPrintOperation()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setReportId()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setShowIds()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setShowTypeIds()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setTicketSchemeId()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setTicketsQtyToPrint()
     * @uses BizAction_Printing_BatchPrint_Tickets_Request::setTicketsSorting()
     * @param \patest\StructType\AreaIds $areaIds
     * @param string $collectionMethod
     * @param string $defaultCardType
     * @param string $defaultSeriesIdToLoad
     * @param string $eventExtendedData1
     * @param string $eventFromDate
     * @param \patest\StructType\EventIds $eventIds
     * @param string $eventOwnerId
     * @param string $eventToDate
     * @param string $hallId
     * @param string $includeAgentTickets
     * @param string $includeHospitalityTickets
     * @param string $includeLoadedOnCardTickets
     * @param bool $includeMarketDriven
     * @param string $includeMovedTickets
     * @param string $includeTicketsInSubscription
     * @param string $includeTransferredResoldTickets
     * @param bool $isTicketSchemesReservationsFeatureOn
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @param string $printer
     * @param string $printFullTransaction
     * @param string $printOperation
     * @param int $reportId
     * @param \patest\StructType\ShowIds $showIds
     * @param \patest\StructType\ShowTypeIds $showTypeIds
     * @param string $ticketSchemeId
     * @param int $ticketsQtyToPrint
     * @param string $ticketsSorting
     */
    public function __construct(\patest\StructType\AreaIds $areaIds = null, $collectionMethod = null, $defaultCardType = null, $defaultSeriesIdToLoad = null, $eventExtendedData1 = null, $eventFromDate = null, \patest\StructType\EventIds $eventIds = null, $eventOwnerId = null, $eventToDate = null, $hallId = null, $includeAgentTickets = null, $includeHospitalityTickets = null, $includeLoadedOnCardTickets = null, $includeMarketDriven = null, $includeMovedTickets = null, $includeTicketsInSubscription = null, $includeTransferredResoldTickets = null, $isTicketSchemesReservationsFeatureOn = null, \patest\StructType\PriceTypeIds $priceTypeIds = null, $printer = null, $printFullTransaction = null, $printOperation = null, $reportId = null, \patest\StructType\ShowIds $showIds = null, \patest\StructType\ShowTypeIds $showTypeIds = null, $ticketSchemeId = null, $ticketsQtyToPrint = null, $ticketsSorting = null)
    {
        $this
            ->setAreaIds($areaIds)
            ->setCollectionMethod($collectionMethod)
            ->setDefaultCardType($defaultCardType)
            ->setDefaultSeriesIdToLoad($defaultSeriesIdToLoad)
            ->setEventExtendedData1($eventExtendedData1)
            ->setEventFromDate($eventFromDate)
            ->setEventIds($eventIds)
            ->setEventOwnerId($eventOwnerId)
            ->setEventToDate($eventToDate)
            ->setHallId($hallId)
            ->setIncludeAgentTickets($includeAgentTickets)
            ->setIncludeHospitalityTickets($includeHospitalityTickets)
            ->setIncludeLoadedOnCardTickets($includeLoadedOnCardTickets)
            ->setIncludeMarketDriven($includeMarketDriven)
            ->setIncludeMovedTickets($includeMovedTickets)
            ->setIncludeTicketsInSubscription($includeTicketsInSubscription)
            ->setIncludeTransferredResoldTickets($includeTransferredResoldTickets)
            ->setIsTicketSchemesReservationsFeatureOn($isTicketSchemesReservationsFeatureOn)
            ->setPriceTypeIds($priceTypeIds)
            ->setPrinter($printer)
            ->setPrintFullTransaction($printFullTransaction)
            ->setPrintOperation($printOperation)
            ->setReportId($reportId)
            ->setShowIds($showIds)
            ->setShowTypeIds($showTypeIds)
            ->setTicketSchemeId($ticketSchemeId)
            ->setTicketsQtyToPrint($ticketsQtyToPrint)
            ->setTicketsSorting($ticketsSorting);
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get CollectionMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectionMethod()
    {
        return isset($this->CollectionMethod) ? $this->CollectionMethod : null;
    }
    /**
     * Set CollectionMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintCollectionMethodPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintCollectionMethodPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $collectionMethod
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setCollectionMethod($collectionMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintCollectionMethodPolicy::valueIsValid($collectionMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintCollectionMethodPolicy', is_array($collectionMethod) ? implode(', ', $collectionMethod) : var_export($collectionMethod, true), implode(', ', \patest\EnumType\BatchPrintCollectionMethodPolicy::getValidValues())), __LINE__);
        }
        if (is_null($collectionMethod) || (is_array($collectionMethod) && empty($collectionMethod))) {
            unset($this->CollectionMethod);
        } else {
            $this->CollectionMethod = $collectionMethod;
        }
        return $this;
    }
    /**
     * Get DefaultCardType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultCardType()
    {
        return isset($this->DefaultCardType) ? $this->DefaultCardType : null;
    }
    /**
     * Set DefaultCardType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintDefaultCardTypePolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintDefaultCardTypePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $defaultCardType
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setDefaultCardType($defaultCardType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintDefaultCardTypePolicy::valueIsValid($defaultCardType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintDefaultCardTypePolicy', is_array($defaultCardType) ? implode(', ', $defaultCardType) : var_export($defaultCardType, true), implode(', ', \patest\EnumType\BatchPrintDefaultCardTypePolicy::getValidValues())), __LINE__);
        }
        if (is_null($defaultCardType) || (is_array($defaultCardType) && empty($defaultCardType))) {
            unset($this->DefaultCardType);
        } else {
            $this->DefaultCardType = $defaultCardType;
        }
        return $this;
    }
    /**
     * Get DefaultSeriesIdToLoad value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSeriesIdToLoad()
    {
        return isset($this->DefaultSeriesIdToLoad) ? $this->DefaultSeriesIdToLoad : null;
    }
    /**
     * Set DefaultSeriesIdToLoad value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSeriesIdToLoad
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setDefaultSeriesIdToLoad($defaultSeriesIdToLoad = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSeriesIdToLoad) && !is_string($defaultSeriesIdToLoad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSeriesIdToLoad, true), gettype($defaultSeriesIdToLoad)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultSeriesIdToLoad) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultSeriesIdToLoad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultSeriesIdToLoad, true)), __LINE__);
        }
        if (is_null($defaultSeriesIdToLoad) || (is_array($defaultSeriesIdToLoad) && empty($defaultSeriesIdToLoad))) {
            unset($this->DefaultSeriesIdToLoad);
        } else {
            $this->DefaultSeriesIdToLoad = $defaultSeriesIdToLoad;
        }
        return $this;
    }
    /**
     * Get EventExtendedData1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventExtendedData1()
    {
        return isset($this->EventExtendedData1) ? $this->EventExtendedData1 : null;
    }
    /**
     * Set EventExtendedData1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventExtendedData1
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setEventExtendedData1($eventExtendedData1 = null)
    {
        // validation for constraint: string
        if (!is_null($eventExtendedData1) && !is_string($eventExtendedData1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventExtendedData1, true), gettype($eventExtendedData1)), __LINE__);
        }
        if (is_null($eventExtendedData1) || (is_array($eventExtendedData1) && empty($eventExtendedData1))) {
            unset($this->EventExtendedData1);
        } else {
            $this->EventExtendedData1 = $eventExtendedData1;
        }
        return $this;
    }
    /**
     * Get EventFromDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventFromDate()
    {
        return isset($this->EventFromDate) ? $this->EventFromDate : null;
    }
    /**
     * Set EventFromDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventFromDate
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setEventFromDate($eventFromDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventFromDate) && !is_string($eventFromDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventFromDate, true), gettype($eventFromDate)), __LINE__);
        }
        if (is_null($eventFromDate) || (is_array($eventFromDate) && empty($eventFromDate))) {
            unset($this->EventFromDate);
        } else {
            $this->EventFromDate = $eventFromDate;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get EventOwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventOwnerId()
    {
        return isset($this->EventOwnerId) ? $this->EventOwnerId : null;
    }
    /**
     * Set EventOwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventOwnerId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setEventOwnerId($eventOwnerId = null)
    {
        // validation for constraint: string
        if (!is_null($eventOwnerId) && !is_string($eventOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventOwnerId, true), gettype($eventOwnerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventOwnerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventOwnerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventOwnerId, true)), __LINE__);
        }
        if (is_null($eventOwnerId) || (is_array($eventOwnerId) && empty($eventOwnerId))) {
            unset($this->EventOwnerId);
        } else {
            $this->EventOwnerId = $eventOwnerId;
        }
        return $this;
    }
    /**
     * Get EventToDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventToDate()
    {
        return isset($this->EventToDate) ? $this->EventToDate : null;
    }
    /**
     * Set EventToDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventToDate
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setEventToDate($eventToDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventToDate) && !is_string($eventToDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventToDate, true), gettype($eventToDate)), __LINE__);
        }
        if (is_null($eventToDate) || (is_array($eventToDate) && empty($eventToDate))) {
            unset($this->EventToDate);
        } else {
            $this->EventToDate = $eventToDate;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get IncludeAgentTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeAgentTickets()
    {
        return isset($this->IncludeAgentTickets) ? $this->IncludeAgentTickets : null;
    }
    /**
     * Set IncludeAgentTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeAgentTickets
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setIncludeAgentTickets($includeAgentTickets = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid($includeAgentTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeItemsPolicy', is_array($includeAgentTickets) ? implode(', ', $includeAgentTickets) : var_export($includeAgentTickets, true), implode(', ', \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues())), __LINE__);
        }
        if (is_null($includeAgentTickets) || (is_array($includeAgentTickets) && empty($includeAgentTickets))) {
            unset($this->IncludeAgentTickets);
        } else {
            $this->IncludeAgentTickets = $includeAgentTickets;
        }
        return $this;
    }
    /**
     * Get IncludeHospitalityTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeHospitalityTickets()
    {
        return isset($this->IncludeHospitalityTickets) ? $this->IncludeHospitalityTickets : null;
    }
    /**
     * Set IncludeHospitalityTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeHospitalityTickets
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setIncludeHospitalityTickets($includeHospitalityTickets = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid($includeHospitalityTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeItemsPolicy', is_array($includeHospitalityTickets) ? implode(', ', $includeHospitalityTickets) : var_export($includeHospitalityTickets, true), implode(', ', \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues())), __LINE__);
        }
        if (is_null($includeHospitalityTickets) || (is_array($includeHospitalityTickets) && empty($includeHospitalityTickets))) {
            unset($this->IncludeHospitalityTickets);
        } else {
            $this->IncludeHospitalityTickets = $includeHospitalityTickets;
        }
        return $this;
    }
    /**
     * Get IncludeLoadedOnCardTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeLoadedOnCardTickets()
    {
        return isset($this->IncludeLoadedOnCardTickets) ? $this->IncludeLoadedOnCardTickets : null;
    }
    /**
     * Set IncludeLoadedOnCardTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeLoadedOnCardTickets
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setIncludeLoadedOnCardTickets($includeLoadedOnCardTickets = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid($includeLoadedOnCardTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeItemsPolicy', is_array($includeLoadedOnCardTickets) ? implode(', ', $includeLoadedOnCardTickets) : var_export($includeLoadedOnCardTickets, true), implode(', ', \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues())), __LINE__);
        }
        if (is_null($includeLoadedOnCardTickets) || (is_array($includeLoadedOnCardTickets) && empty($includeLoadedOnCardTickets))) {
            unset($this->IncludeLoadedOnCardTickets);
        } else {
            $this->IncludeLoadedOnCardTickets = $includeLoadedOnCardTickets;
        }
        return $this;
    }
    /**
     * Get IncludeMarketDriven value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeMarketDriven()
    {
        return isset($this->IncludeMarketDriven) ? $this->IncludeMarketDriven : null;
    }
    /**
     * Set IncludeMarketDriven value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeMarketDriven
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setIncludeMarketDriven($includeMarketDriven = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeMarketDriven) && !is_bool($includeMarketDriven)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeMarketDriven, true), gettype($includeMarketDriven)), __LINE__);
        }
        if (is_null($includeMarketDriven) || (is_array($includeMarketDriven) && empty($includeMarketDriven))) {
            unset($this->IncludeMarketDriven);
        } else {
            $this->IncludeMarketDriven = $includeMarketDriven;
        }
        return $this;
    }
    /**
     * Get IncludeMovedTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeMovedTickets()
    {
        return isset($this->IncludeMovedTickets) ? $this->IncludeMovedTickets : null;
    }
    /**
     * Set IncludeMovedTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeMovedTickets
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setIncludeMovedTickets($includeMovedTickets = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid($includeMovedTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeItemsPolicy', is_array($includeMovedTickets) ? implode(', ', $includeMovedTickets) : var_export($includeMovedTickets, true), implode(', ', \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues())), __LINE__);
        }
        if (is_null($includeMovedTickets) || (is_array($includeMovedTickets) && empty($includeMovedTickets))) {
            unset($this->IncludeMovedTickets);
        } else {
            $this->IncludeMovedTickets = $includeMovedTickets;
        }
        return $this;
    }
    /**
     * Get IncludeTicketsInSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeTicketsInSubscription()
    {
        return isset($this->IncludeTicketsInSubscription) ? $this->IncludeTicketsInSubscription : null;
    }
    /**
     * Set IncludeTicketsInSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeTicketsInSubscription
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setIncludeTicketsInSubscription($includeTicketsInSubscription = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid($includeTicketsInSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeItemsPolicy', is_array($includeTicketsInSubscription) ? implode(', ', $includeTicketsInSubscription) : var_export($includeTicketsInSubscription, true), implode(', ', \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues())), __LINE__);
        }
        if (is_null($includeTicketsInSubscription) || (is_array($includeTicketsInSubscription) && empty($includeTicketsInSubscription))) {
            unset($this->IncludeTicketsInSubscription);
        } else {
            $this->IncludeTicketsInSubscription = $includeTicketsInSubscription;
        }
        return $this;
    }
    /**
     * Get IncludeTransferredResoldTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIncludeTransferredResoldTickets()
    {
        return isset($this->IncludeTransferredResoldTickets) ? $this->IncludeTransferredResoldTickets : null;
    }
    /**
     * Set IncludeTransferredResoldTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid()
     * @uses \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $includeTransferredResoldTickets
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setIncludeTransferredResoldTickets($includeTransferredResoldTickets = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintIncludeItemsPolicy::valueIsValid($includeTransferredResoldTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintIncludeItemsPolicy', is_array($includeTransferredResoldTickets) ? implode(', ', $includeTransferredResoldTickets) : var_export($includeTransferredResoldTickets, true), implode(', ', \patest\EnumType\BatchPrintIncludeItemsPolicy::getValidValues())), __LINE__);
        }
        if (is_null($includeTransferredResoldTickets) || (is_array($includeTransferredResoldTickets) && empty($includeTransferredResoldTickets))) {
            unset($this->IncludeTransferredResoldTickets);
        } else {
            $this->IncludeTransferredResoldTickets = $includeTransferredResoldTickets;
        }
        return $this;
    }
    /**
     * Get IsTicketSchemesReservationsFeatureOn value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTicketSchemesReservationsFeatureOn()
    {
        return isset($this->IsTicketSchemesReservationsFeatureOn) ? $this->IsTicketSchemesReservationsFeatureOn : null;
    }
    /**
     * Set IsTicketSchemesReservationsFeatureOn value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTicketSchemesReservationsFeatureOn
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setIsTicketSchemesReservationsFeatureOn($isTicketSchemesReservationsFeatureOn = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTicketSchemesReservationsFeatureOn) && !is_bool($isTicketSchemesReservationsFeatureOn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTicketSchemesReservationsFeatureOn, true), gettype($isTicketSchemesReservationsFeatureOn)), __LINE__);
        }
        if (is_null($isTicketSchemesReservationsFeatureOn) || (is_array($isTicketSchemesReservationsFeatureOn) && empty($isTicketSchemesReservationsFeatureOn))) {
            unset($this->IsTicketSchemesReservationsFeatureOn);
        } else {
            $this->IsTicketSchemesReservationsFeatureOn = $isTicketSchemesReservationsFeatureOn;
        }
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypeIds|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setPriceTypeIds(\patest\StructType\PriceTypeIds $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
    /**
     * Get Printer value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrinter()
    {
        return isset($this->Printer) ? $this->Printer : null;
    }
    /**
     * Set Printer value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printer
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setPrinter($printer = null)
    {
        // validation for constraint: string
        if (!is_null($printer) && !is_string($printer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printer, true), gettype($printer)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($printer) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $printer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($printer, true)), __LINE__);
        }
        if (is_null($printer) || (is_array($printer) && empty($printer))) {
            unset($this->Printer);
        } else {
            $this->Printer = $printer;
        }
        return $this;
    }
    /**
     * Get PrintFullTransaction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintFullTransaction()
    {
        return isset($this->PrintFullTransaction) ? $this->PrintFullTransaction : null;
    }
    /**
     * Set PrintFullTransaction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketBatchPrintFullTransaction::valueIsValid()
     * @uses \patest\EnumType\TicketBatchPrintFullTransaction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printFullTransaction
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setPrintFullTransaction($printFullTransaction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketBatchPrintFullTransaction::valueIsValid($printFullTransaction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketBatchPrintFullTransaction', is_array($printFullTransaction) ? implode(', ', $printFullTransaction) : var_export($printFullTransaction, true), implode(', ', \patest\EnumType\TicketBatchPrintFullTransaction::getValidValues())), __LINE__);
        }
        if (is_null($printFullTransaction) || (is_array($printFullTransaction) && empty($printFullTransaction))) {
            unset($this->PrintFullTransaction);
        } else {
            $this->PrintFullTransaction = $printFullTransaction;
        }
        return $this;
    }
    /**
     * Get PrintOperation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrintOperation()
    {
        return isset($this->PrintOperation) ? $this->PrintOperation : null;
    }
    /**
     * Set PrintOperation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketBatchPrintOperation::valueIsValid()
     * @uses \patest\EnumType\TicketBatchPrintOperation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printOperation
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setPrintOperation($printOperation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketBatchPrintOperation::valueIsValid($printOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketBatchPrintOperation', is_array($printOperation) ? implode(', ', $printOperation) : var_export($printOperation, true), implode(', ', \patest\EnumType\TicketBatchPrintOperation::getValidValues())), __LINE__);
        }
        if (is_null($printOperation) || (is_array($printOperation) && empty($printOperation))) {
            unset($this->PrintOperation);
        } else {
            $this->PrintOperation = $printOperation;
        }
        return $this;
    }
    /**
     * Get ReportId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReportId()
    {
        return isset($this->ReportId) ? $this->ReportId : null;
    }
    /**
     * Set ReportId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reportId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setReportId($reportId = null)
    {
        // validation for constraint: int
        if (!is_null($reportId) && !(is_int($reportId) || ctype_digit($reportId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reportId, true), gettype($reportId)), __LINE__);
        }
        if (is_null($reportId) || (is_array($reportId) && empty($reportId))) {
            unset($this->ReportId);
        } else {
            $this->ReportId = $reportId;
        }
        return $this;
    }
    /**
     * Get ShowIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ShowIds|null
     */
    public function getShowIds()
    {
        return isset($this->ShowIds) ? $this->ShowIds : null;
    }
    /**
     * Set ShowIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ShowIds $showIds
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setShowIds(\patest\StructType\ShowIds $showIds = null)
    {
        if (is_null($showIds) || (is_array($showIds) && empty($showIds))) {
            unset($this->ShowIds);
        } else {
            $this->ShowIds = $showIds;
        }
        return $this;
    }
    /**
     * Get ShowTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ShowTypeIds|null
     */
    public function getShowTypeIds()
    {
        return isset($this->ShowTypeIds) ? $this->ShowTypeIds : null;
    }
    /**
     * Set ShowTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ShowTypeIds $showTypeIds
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setShowTypeIds(\patest\StructType\ShowTypeIds $showTypeIds = null)
    {
        if (is_null($showTypeIds) || (is_array($showTypeIds) && empty($showTypeIds))) {
            unset($this->ShowTypeIds);
        } else {
            $this->ShowTypeIds = $showTypeIds;
        }
        return $this;
    }
    /**
     * Get TicketSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSchemeId()
    {
        return isset($this->TicketSchemeId) ? $this->TicketSchemeId : null;
    }
    /**
     * Set TicketSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSchemeId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setTicketSchemeId($ticketSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeId) && !is_string($ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeId, true), gettype($ticketSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSchemeId, true)), __LINE__);
        }
        if (is_null($ticketSchemeId) || (is_array($ticketSchemeId) && empty($ticketSchemeId))) {
            unset($this->TicketSchemeId);
        } else {
            $this->TicketSchemeId = $ticketSchemeId;
        }
        return $this;
    }
    /**
     * Get TicketsQtyToPrint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketsQtyToPrint()
    {
        return isset($this->TicketsQtyToPrint) ? $this->TicketsQtyToPrint : null;
    }
    /**
     * Set TicketsQtyToPrint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketsQtyToPrint
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setTicketsQtyToPrint($ticketsQtyToPrint = null)
    {
        // validation for constraint: int
        if (!is_null($ticketsQtyToPrint) && !(is_int($ticketsQtyToPrint) || ctype_digit($ticketsQtyToPrint))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketsQtyToPrint, true), gettype($ticketsQtyToPrint)), __LINE__);
        }
        if (is_null($ticketsQtyToPrint) || (is_array($ticketsQtyToPrint) && empty($ticketsQtyToPrint))) {
            unset($this->TicketsQtyToPrint);
        } else {
            $this->TicketsQtyToPrint = $ticketsQtyToPrint;
        }
        return $this;
    }
    /**
     * Get TicketsSorting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketsSorting()
    {
        return isset($this->TicketsSorting) ? $this->TicketsSorting : null;
    }
    /**
     * Set TicketsSorting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintingSorting::valueIsValid()
     * @uses \patest\EnumType\BatchPrintingSorting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketsSorting
     * @return \patest\StructType\BizAction_Printing_BatchPrint_Tickets_Request
     */
    public function setTicketsSorting($ticketsSorting = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintingSorting::valueIsValid($ticketsSorting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintingSorting', is_array($ticketsSorting) ? implode(', ', $ticketsSorting) : var_export($ticketsSorting, true), implode(', ', \patest\EnumType\BatchPrintingSorting::getValidValues())), __LINE__);
        }
        if (is_null($ticketsSorting) || (is_array($ticketsSorting) && empty($ticketsSorting))) {
            unset($this->TicketsSorting);
        } else {
            $this->TicketsSorting = $ticketsSorting;
        }
        return $this;
    }
}
