<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.BatchPrint.GiftVouchers.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Printing_BatchPrint_GiftVouchers_Request extends BizAction_Printing_BatchPrint_Request_Base
{
    /**
     * The GiftVoucherId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherId;
    /**
     * The GiftVouchersSorting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVouchersSorting;
    /**
     * The GiftVoucherTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GiftVoucherTypeId;
    /**
     * Constructor method for BizAction.Printing.BatchPrint.GiftVouchers.Request
     * @uses BizAction_Printing_BatchPrint_GiftVouchers_Request::setGiftVoucherId()
     * @uses BizAction_Printing_BatchPrint_GiftVouchers_Request::setGiftVouchersSorting()
     * @uses BizAction_Printing_BatchPrint_GiftVouchers_Request::setGiftVoucherTypeId()
     * @param string $giftVoucherId
     * @param string $giftVouchersSorting
     * @param string $giftVoucherTypeId
     */
    public function __construct($giftVoucherId = null, $giftVouchersSorting = null, $giftVoucherTypeId = null)
    {
        $this
            ->setGiftVoucherId($giftVoucherId)
            ->setGiftVouchersSorting($giftVouchersSorting)
            ->setGiftVoucherTypeId($giftVoucherTypeId);
    }
    /**
     * Get GiftVoucherId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherId()
    {
        return isset($this->GiftVoucherId) ? $this->GiftVoucherId : null;
    }
    /**
     * Set GiftVoucherId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_GiftVouchers_Request
     */
    public function setGiftVoucherId($giftVoucherId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherId) && !is_string($giftVoucherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherId, true), gettype($giftVoucherId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherId, true)), __LINE__);
        }
        if (is_null($giftVoucherId) || (is_array($giftVoucherId) && empty($giftVoucherId))) {
            unset($this->GiftVoucherId);
        } else {
            $this->GiftVoucherId = $giftVoucherId;
        }
        return $this;
    }
    /**
     * Get GiftVouchersSorting value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVouchersSorting()
    {
        return isset($this->GiftVouchersSorting) ? $this->GiftVouchersSorting : null;
    }
    /**
     * Set GiftVouchersSorting value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchPrintGiftVouchersSorting::valueIsValid()
     * @uses \patest\EnumType\BatchPrintGiftVouchersSorting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $giftVouchersSorting
     * @return \patest\StructType\BizAction_Printing_BatchPrint_GiftVouchers_Request
     */
    public function setGiftVouchersSorting($giftVouchersSorting = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintGiftVouchersSorting::valueIsValid($giftVouchersSorting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintGiftVouchersSorting', is_array($giftVouchersSorting) ? implode(', ', $giftVouchersSorting) : var_export($giftVouchersSorting, true), implode(', ', \patest\EnumType\BatchPrintGiftVouchersSorting::getValidValues())), __LINE__);
        }
        if (is_null($giftVouchersSorting) || (is_array($giftVouchersSorting) && empty($giftVouchersSorting))) {
            unset($this->GiftVouchersSorting);
        } else {
            $this->GiftVouchersSorting = $giftVouchersSorting;
        }
        return $this;
    }
    /**
     * Get GiftVoucherTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVoucherTypeId()
    {
        return isset($this->GiftVoucherTypeId) ? $this->GiftVoucherTypeId : null;
    }
    /**
     * Set GiftVoucherTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $giftVoucherTypeId
     * @return \patest\StructType\BizAction_Printing_BatchPrint_GiftVouchers_Request
     */
    public function setGiftVoucherTypeId($giftVoucherTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($giftVoucherTypeId) && !is_string($giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($giftVoucherTypeId, true), gettype($giftVoucherTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($giftVoucherTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $giftVoucherTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($giftVoucherTypeId, true)), __LINE__);
        }
        if (is_null($giftVoucherTypeId) || (is_array($giftVoucherTypeId) && empty($giftVoucherTypeId))) {
            unset($this->GiftVoucherTypeId);
        } else {
            $this->GiftVoucherTypeId = $giftVoucherTypeId;
        }
        return $this;
    }
}
