<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Printing.AdvancedPrinting.Request StructType
 * @subpackage Structs
 */
class BizAction_Printing_AdvancedPrinting_Request extends AnyEntity
{
    /**
     * The ItemsProductType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemsProductType;
    /**
     * The PrintableTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPrinting_PrintableTransaction
     */
    public $PrintableTransactions;
    /**
     * The TotalItemsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalItemsCount;
    /**
     * Constructor method for BizAction.Printing.AdvancedPrinting.Request
     * @uses BizAction_Printing_AdvancedPrinting_Request::setItemsProductType()
     * @uses BizAction_Printing_AdvancedPrinting_Request::setPrintableTransactions()
     * @uses BizAction_Printing_AdvancedPrinting_Request::setTotalItemsCount()
     * @param int $itemsProductType
     * @param \patest\StructType\RecordSetOfPrinting_PrintableTransaction $printableTransactions
     * @param int $totalItemsCount
     */
    public function __construct($itemsProductType = null, \patest\StructType\RecordSetOfPrinting_PrintableTransaction $printableTransactions = null, $totalItemsCount = null)
    {
        $this
            ->setItemsProductType($itemsProductType)
            ->setPrintableTransactions($printableTransactions)
            ->setTotalItemsCount($totalItemsCount);
    }
    /**
     * Get ItemsProductType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemsProductType()
    {
        return isset($this->ItemsProductType) ? $this->ItemsProductType : null;
    }
    /**
     * Set ItemsProductType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemsProductType
     * @return \patest\StructType\BizAction_Printing_AdvancedPrinting_Request
     */
    public function setItemsProductType($itemsProductType = null)
    {
        // validation for constraint: int
        if (!is_null($itemsProductType) && !(is_int($itemsProductType) || ctype_digit($itemsProductType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemsProductType, true), gettype($itemsProductType)), __LINE__);
        }
        if (is_null($itemsProductType) || (is_array($itemsProductType) && empty($itemsProductType))) {
            unset($this->ItemsProductType);
        } else {
            $this->ItemsProductType = $itemsProductType;
        }
        return $this;
    }
    /**
     * Get PrintableTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPrinting_PrintableTransaction|null
     */
    public function getPrintableTransactions()
    {
        return isset($this->PrintableTransactions) ? $this->PrintableTransactions : null;
    }
    /**
     * Set PrintableTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPrinting_PrintableTransaction $printableTransactions
     * @return \patest\StructType\BizAction_Printing_AdvancedPrinting_Request
     */
    public function setPrintableTransactions(\patest\StructType\RecordSetOfPrinting_PrintableTransaction $printableTransactions = null)
    {
        if (is_null($printableTransactions) || (is_array($printableTransactions) && empty($printableTransactions))) {
            unset($this->PrintableTransactions);
        } else {
            $this->PrintableTransactions = $printableTransactions;
        }
        return $this;
    }
    /**
     * Get TotalItemsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalItemsCount()
    {
        return isset($this->TotalItemsCount) ? $this->TotalItemsCount : null;
    }
    /**
     * Set TotalItemsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalItemsCount
     * @return \patest\StructType\BizAction_Printing_AdvancedPrinting_Request
     */
    public function setTotalItemsCount($totalItemsCount = null)
    {
        // validation for constraint: int
        if (!is_null($totalItemsCount) && !(is_int($totalItemsCount) || ctype_digit($totalItemsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalItemsCount, true), gettype($totalItemsCount)), __LINE__);
        }
        if (is_null($totalItemsCount) || (is_array($totalItemsCount) && empty($totalItemsCount))) {
            unset($this->TotalItemsCount);
        } else {
            $this->TotalItemsCount = $totalItemsCount;
        }
        return $this;
    }
}
