<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Payment.PrepareModifiedInstallmentsForPaymentPlan.Request StructType
 * @subpackage Structs
 */
class BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request extends AnyEntity
{
    /**
     * The Amount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $Amount;
    /**
     * The ChangeKind
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $ChangeKind;
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Date;
    /**
     * The InstallmentItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_InstallmentForOnGoingEdit
     */
    public $InstallmentItems;
    /**
     * The InstallmentsAmountAdjustmentOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InstallmentsAmountAdjustmentOption;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The OrderOfInstallmentToChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $OrderOfInstallmentToChange;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentProviderSpecificTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentProviderSpecificTokenId;
    /**
     * Constructor method for
     * BizAction.Payment.PrepareModifiedInstallmentsForPaymentPlan.Request
     * @uses BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request::setAmount()
     * @uses BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request::setChangeKind()
     * @uses BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request::setClientId()
     * @uses BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request::setDate()
     * @uses BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request::setInstallmentItems()
     * @uses BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request::setInstallmentsAmountAdjustmentOption()
     * @uses BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request::setNotes()
     * @uses BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request::setOrderOfInstallmentToChange()
     * @uses BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request::setPaymentMethodId()
     * @uses BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request::setPaymentProviderSpecificTokenId()
     * @param \patest\StructType\Money $amount
     * @param string[] $changeKind
     * @param string $clientId
     * @param string $date
     * @param \patest\StructType\RecordSetOfPayment_InstallmentForOnGoingEdit $installmentItems
     * @param string $installmentsAmountAdjustmentOption
     * @param string $notes
     * @param int $orderOfInstallmentToChange
     * @param string $paymentMethodId
     * @param string $paymentProviderSpecificTokenId
     */
    public function __construct(\patest\StructType\Money $amount = null, array $changeKind = array(), $clientId = null, $date = null, \patest\StructType\RecordSetOfPayment_InstallmentForOnGoingEdit $installmentItems = null, $installmentsAmountAdjustmentOption = null, $notes = null, $orderOfInstallmentToChange = null, $paymentMethodId = null, $paymentProviderSpecificTokenId = null)
    {
        $this
            ->setAmount($amount)
            ->setChangeKind($changeKind)
            ->setClientId($clientId)
            ->setDate($date)
            ->setInstallmentItems($installmentItems)
            ->setInstallmentsAmountAdjustmentOption($installmentsAmountAdjustmentOption)
            ->setNotes($notes)
            ->setOrderOfInstallmentToChange($orderOfInstallmentToChange)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentProviderSpecificTokenId($paymentProviderSpecificTokenId);
    }
    /**
     * Get Amount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getAmount()
    {
        return isset($this->Amount) ? $this->Amount : null;
    }
    /**
     * Set Amount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $amount
     * @return \patest\StructType\BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request
     */
    public function setAmount(\patest\StructType\Money $amount = null)
    {
        if (is_null($amount) || (is_array($amount) && empty($amount))) {
            unset($this->Amount);
        } else {
            $this->Amount = $amount;
        }
        return $this;
    }
    /**
     * Get ChangeKind value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getChangeKind()
    {
        return isset($this->ChangeKind) ? $this->ChangeKind : null;
    }
    /**
     * This method is responsible for validating the values passed to the setChangeKind method
     * This method is willingly generated in order to preserve the one-line inline validation within the setChangeKind method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateChangeKindForArrayConstraintsFromSetChangeKind(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $bizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_RequestChangeKindItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\PaymentPlanInstallmentsChangeEnum::valueIsValid($bizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_RequestChangeKindItem)) {
                $invalidValues[] = is_object($bizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_RequestChangeKindItem) ? get_class($bizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_RequestChangeKindItem) : sprintf('%s(%s)', gettype($bizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_RequestChangeKindItem), var_export($bizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_RequestChangeKindItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentPlanInstallmentsChangeEnum', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\PaymentPlanInstallmentsChangeEnum::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ChangeKind value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentPlanInstallmentsChangeEnum::valueIsValid()
     * @uses \patest\EnumType\PaymentPlanInstallmentsChangeEnum::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $changeKind
     * @return \patest\StructType\BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request
     */
    public function setChangeKind(array $changeKind = array())
    {
        // validation for constraint: list
        if ('' !== ($changeKindArrayErrorMessage = self::validateChangeKindForArrayConstraintsFromSetChangeKind($changeKind))) {
            throw new \InvalidArgumentException($changeKindArrayErrorMessage, __LINE__);
        }
        if (is_null($changeKind) || (is_array($changeKind) && empty($changeKind))) {
            unset($this->ChangeKind);
        } else {
            $this->ChangeKind = is_array($changeKind) ? implode(' ', $changeKind) : null;
        }
        return $this;
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get Date value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDate()
    {
        return isset($this->Date) ? $this->Date : null;
    }
    /**
     * Set Date value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $date
     * @return \patest\StructType\BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        if (is_null($date) || (is_array($date) && empty($date))) {
            unset($this->Date);
        } else {
            $this->Date = $date;
        }
        return $this;
    }
    /**
     * Get InstallmentItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_InstallmentForOnGoingEdit|null
     */
    public function getInstallmentItems()
    {
        return isset($this->InstallmentItems) ? $this->InstallmentItems : null;
    }
    /**
     * Set InstallmentItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_InstallmentForOnGoingEdit $installmentItems
     * @return \patest\StructType\BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request
     */
    public function setInstallmentItems(\patest\StructType\RecordSetOfPayment_InstallmentForOnGoingEdit $installmentItems = null)
    {
        if (is_null($installmentItems) || (is_array($installmentItems) && empty($installmentItems))) {
            unset($this->InstallmentItems);
        } else {
            $this->InstallmentItems = $installmentItems;
        }
        return $this;
    }
    /**
     * Get InstallmentsAmountAdjustmentOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstallmentsAmountAdjustmentOption()
    {
        return isset($this->InstallmentsAmountAdjustmentOption) ? $this->InstallmentsAmountAdjustmentOption : null;
    }
    /**
     * Set InstallmentsAmountAdjustmentOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid()
     * @uses \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $installmentsAmountAdjustmentOption
     * @return \patest\StructType\BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request
     */
    public function setInstallmentsAmountAdjustmentOption($installmentsAmountAdjustmentOption = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\InstallmentsAmountAdjustmentOption::valueIsValid($installmentsAmountAdjustmentOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\InstallmentsAmountAdjustmentOption', is_array($installmentsAmountAdjustmentOption) ? implode(', ', $installmentsAmountAdjustmentOption) : var_export($installmentsAmountAdjustmentOption, true), implode(', ', \patest\EnumType\InstallmentsAmountAdjustmentOption::getValidValues())), __LINE__);
        }
        if (is_null($installmentsAmountAdjustmentOption) || (is_array($installmentsAmountAdjustmentOption) && empty($installmentsAmountAdjustmentOption))) {
            unset($this->InstallmentsAmountAdjustmentOption);
        } else {
            $this->InstallmentsAmountAdjustmentOption = $installmentsAmountAdjustmentOption;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get OrderOfInstallmentToChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrderOfInstallmentToChange()
    {
        return isset($this->OrderOfInstallmentToChange) ? $this->OrderOfInstallmentToChange : null;
    }
    /**
     * Set OrderOfInstallmentToChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $orderOfInstallmentToChange
     * @return \patest\StructType\BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request
     */
    public function setOrderOfInstallmentToChange($orderOfInstallmentToChange = null)
    {
        // validation for constraint: int
        if (!is_null($orderOfInstallmentToChange) && !(is_int($orderOfInstallmentToChange) || ctype_digit($orderOfInstallmentToChange))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($orderOfInstallmentToChange, true), gettype($orderOfInstallmentToChange)), __LINE__);
        }
        if (is_null($orderOfInstallmentToChange) || (is_array($orderOfInstallmentToChange) && empty($orderOfInstallmentToChange))) {
            unset($this->OrderOfInstallmentToChange);
        } else {
            $this->OrderOfInstallmentToChange = $orderOfInstallmentToChange;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentProviderSpecificTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentProviderSpecificTokenId()
    {
        return isset($this->PaymentProviderSpecificTokenId) ? $this->PaymentProviderSpecificTokenId : null;
    }
    /**
     * Set PaymentProviderSpecificTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentProviderSpecificTokenId
     * @return \patest\StructType\BizAction_Payment_PrepareModifiedInstallmentsForPaymentPlan_Request
     */
    public function setPaymentProviderSpecificTokenId($paymentProviderSpecificTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentProviderSpecificTokenId) && !is_string($paymentProviderSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentProviderSpecificTokenId, true), gettype($paymentProviderSpecificTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentProviderSpecificTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentProviderSpecificTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentProviderSpecificTokenId, true)), __LINE__);
        }
        if (is_null($paymentProviderSpecificTokenId) || (is_array($paymentProviderSpecificTokenId) && empty($paymentProviderSpecificTokenId))) {
            unset($this->PaymentProviderSpecificTokenId);
        } else {
            $this->PaymentProviderSpecificTokenId = $paymentProviderSpecificTokenId;
        }
        return $this;
    }
}
