<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Payment.CashDrawerBalanceCount.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Payment_CashDrawerBalanceCount_Request extends AnyEntity
{
    /**
     * The CashEntries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_CashEntry
     */
    public $CashEntries;
    /**
     * The CountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CountId;
    /**
     * The IsNew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsNew;
    /**
     * The NonCashEntries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfPayment_NonCashEntry
     */
    public $NonCashEntries;
    /**
     * The OpenSum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $OpenSum;
    /**
     * The Remark
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Remark;
    /**
     * The ShiftId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShiftId;
    /**
     * The TillId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TillId;
    /**
     * Constructor method for BizAction.Payment.CashDrawerBalanceCount.Request
     * @uses BizAction_Payment_CashDrawerBalanceCount_Request::setCashEntries()
     * @uses BizAction_Payment_CashDrawerBalanceCount_Request::setCountId()
     * @uses BizAction_Payment_CashDrawerBalanceCount_Request::setIsNew()
     * @uses BizAction_Payment_CashDrawerBalanceCount_Request::setNonCashEntries()
     * @uses BizAction_Payment_CashDrawerBalanceCount_Request::setOpenSum()
     * @uses BizAction_Payment_CashDrawerBalanceCount_Request::setRemark()
     * @uses BizAction_Payment_CashDrawerBalanceCount_Request::setShiftId()
     * @uses BizAction_Payment_CashDrawerBalanceCount_Request::setTillId()
     * @param \patest\StructType\RecordSetOfPayment_CashEntry $cashEntries
     * @param string $countId
     * @param bool $isNew
     * @param \patest\StructType\RecordSetOfPayment_NonCashEntry $nonCashEntries
     * @param \patest\StructType\Money $openSum
     * @param string $remark
     * @param int $shiftId
     * @param string $tillId
     */
    public function __construct(\patest\StructType\RecordSetOfPayment_CashEntry $cashEntries = null, $countId = null, $isNew = null, \patest\StructType\RecordSetOfPayment_NonCashEntry $nonCashEntries = null, \patest\StructType\Money $openSum = null, $remark = null, $shiftId = null, $tillId = null)
    {
        $this
            ->setCashEntries($cashEntries)
            ->setCountId($countId)
            ->setIsNew($isNew)
            ->setNonCashEntries($nonCashEntries)
            ->setOpenSum($openSum)
            ->setRemark($remark)
            ->setShiftId($shiftId)
            ->setTillId($tillId);
    }
    /**
     * Get CashEntries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_CashEntry|null
     */
    public function getCashEntries()
    {
        return isset($this->CashEntries) ? $this->CashEntries : null;
    }
    /**
     * Set CashEntries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_CashEntry $cashEntries
     * @return \patest\StructType\BizAction_Payment_CashDrawerBalanceCount_Request
     */
    public function setCashEntries(\patest\StructType\RecordSetOfPayment_CashEntry $cashEntries = null)
    {
        if (is_null($cashEntries) || (is_array($cashEntries) && empty($cashEntries))) {
            unset($this->CashEntries);
        } else {
            $this->CashEntries = $cashEntries;
        }
        return $this;
    }
    /**
     * Get CountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountId()
    {
        return isset($this->CountId) ? $this->CountId : null;
    }
    /**
     * Set CountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $countId
     * @return \patest\StructType\BizAction_Payment_CashDrawerBalanceCount_Request
     */
    public function setCountId($countId = null)
    {
        // validation for constraint: string
        if (!is_null($countId) && !is_string($countId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($countId, true), gettype($countId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($countId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $countId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($countId, true)), __LINE__);
        }
        if (is_null($countId) || (is_array($countId) && empty($countId))) {
            unset($this->CountId);
        } else {
            $this->CountId = $countId;
        }
        return $this;
    }
    /**
     * Get IsNew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsNew()
    {
        return isset($this->IsNew) ? $this->IsNew : null;
    }
    /**
     * Set IsNew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isNew
     * @return \patest\StructType\BizAction_Payment_CashDrawerBalanceCount_Request
     */
    public function setIsNew($isNew = null)
    {
        // validation for constraint: boolean
        if (!is_null($isNew) && !is_bool($isNew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isNew, true), gettype($isNew)), __LINE__);
        }
        if (is_null($isNew) || (is_array($isNew) && empty($isNew))) {
            unset($this->IsNew);
        } else {
            $this->IsNew = $isNew;
        }
        return $this;
    }
    /**
     * Get NonCashEntries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfPayment_NonCashEntry|null
     */
    public function getNonCashEntries()
    {
        return isset($this->NonCashEntries) ? $this->NonCashEntries : null;
    }
    /**
     * Set NonCashEntries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfPayment_NonCashEntry $nonCashEntries
     * @return \patest\StructType\BizAction_Payment_CashDrawerBalanceCount_Request
     */
    public function setNonCashEntries(\patest\StructType\RecordSetOfPayment_NonCashEntry $nonCashEntries = null)
    {
        if (is_null($nonCashEntries) || (is_array($nonCashEntries) && empty($nonCashEntries))) {
            unset($this->NonCashEntries);
        } else {
            $this->NonCashEntries = $nonCashEntries;
        }
        return $this;
    }
    /**
     * Get OpenSum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getOpenSum()
    {
        return isset($this->OpenSum) ? $this->OpenSum : null;
    }
    /**
     * Set OpenSum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $openSum
     * @return \patest\StructType\BizAction_Payment_CashDrawerBalanceCount_Request
     */
    public function setOpenSum(\patest\StructType\Money $openSum = null)
    {
        if (is_null($openSum) || (is_array($openSum) && empty($openSum))) {
            unset($this->OpenSum);
        } else {
            $this->OpenSum = $openSum;
        }
        return $this;
    }
    /**
     * Get Remark value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRemark()
    {
        return isset($this->Remark) ? $this->Remark : null;
    }
    /**
     * Set Remark value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $remark
     * @return \patest\StructType\BizAction_Payment_CashDrawerBalanceCount_Request
     */
    public function setRemark($remark = null)
    {
        // validation for constraint: string
        if (!is_null($remark) && !is_string($remark)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($remark, true), gettype($remark)), __LINE__);
        }
        if (is_null($remark) || (is_array($remark) && empty($remark))) {
            unset($this->Remark);
        } else {
            $this->Remark = $remark;
        }
        return $this;
    }
    /**
     * Get ShiftId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShiftId()
    {
        return isset($this->ShiftId) ? $this->ShiftId : null;
    }
    /**
     * Set ShiftId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $shiftId
     * @return \patest\StructType\BizAction_Payment_CashDrawerBalanceCount_Request
     */
    public function setShiftId($shiftId = null)
    {
        // validation for constraint: int
        if (!is_null($shiftId) && !(is_int($shiftId) || ctype_digit($shiftId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($shiftId, true), gettype($shiftId)), __LINE__);
        }
        if (is_null($shiftId) || (is_array($shiftId) && empty($shiftId))) {
            unset($this->ShiftId);
        } else {
            $this->ShiftId = $shiftId;
        }
        return $this;
    }
    /**
     * Get TillId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTillId()
    {
        return isset($this->TillId) ? $this->TillId : null;
    }
    /**
     * Set TillId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tillId
     * @return \patest\StructType\BizAction_Payment_CashDrawerBalanceCount_Request
     */
    public function setTillId($tillId = null)
    {
        // validation for constraint: string
        if (!is_null($tillId) && !is_string($tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tillId, true), gettype($tillId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tillId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tillId, true)), __LINE__);
        }
        if (is_null($tillId) || (is_array($tillId) && empty($tillId))) {
            unset($this->TillId);
        } else {
            $this->TillId = $tillId;
        }
        return $this;
    }
}
