<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Payment.BulkExpireClientsPoints.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Payment_BulkExpireClientsPoints_Request extends BizAction_Foundation_BulkOperation_Request
{
    /**
     * The BankingDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankingDateFrom;
    /**
     * The BankingDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BankingDateTo;
    /**
     * The ExpiryDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDateFrom;
    /**
     * The ExpiryDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDateTo;
    /**
     * The ExpiryDateToSet
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpiryDateToSet;
    /**
     * The GrantDateFrom
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GrantDateFrom;
    /**
     * The GrantDateTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GrantDateTo;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The PointsMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PointsMode;
    /**
     * The ProductIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProductIds;
    /**
     * Constructor method for BizAction.Payment.BulkExpireClientsPoints.Request
     * @uses BizAction_Payment_BulkExpireClientsPoints_Request::setBankingDateFrom()
     * @uses BizAction_Payment_BulkExpireClientsPoints_Request::setBankingDateTo()
     * @uses BizAction_Payment_BulkExpireClientsPoints_Request::setExpiryDateFrom()
     * @uses BizAction_Payment_BulkExpireClientsPoints_Request::setExpiryDateTo()
     * @uses BizAction_Payment_BulkExpireClientsPoints_Request::setExpiryDateToSet()
     * @uses BizAction_Payment_BulkExpireClientsPoints_Request::setGrantDateFrom()
     * @uses BizAction_Payment_BulkExpireClientsPoints_Request::setGrantDateTo()
     * @uses BizAction_Payment_BulkExpireClientsPoints_Request::setItemType()
     * @uses BizAction_Payment_BulkExpireClientsPoints_Request::setPointsMode()
     * @uses BizAction_Payment_BulkExpireClientsPoints_Request::setProductIds()
     * @param string $bankingDateFrom
     * @param string $bankingDateTo
     * @param string $expiryDateFrom
     * @param string $expiryDateTo
     * @param string $expiryDateToSet
     * @param string $grantDateFrom
     * @param string $grantDateTo
     * @param int $itemType
     * @param string $pointsMode
     * @param string $productIds
     */
    public function __construct($bankingDateFrom = null, $bankingDateTo = null, $expiryDateFrom = null, $expiryDateTo = null, $expiryDateToSet = null, $grantDateFrom = null, $grantDateTo = null, $itemType = null, $pointsMode = null, $productIds = null)
    {
        $this
            ->setBankingDateFrom($bankingDateFrom)
            ->setBankingDateTo($bankingDateTo)
            ->setExpiryDateFrom($expiryDateFrom)
            ->setExpiryDateTo($expiryDateTo)
            ->setExpiryDateToSet($expiryDateToSet)
            ->setGrantDateFrom($grantDateFrom)
            ->setGrantDateTo($grantDateTo)
            ->setItemType($itemType)
            ->setPointsMode($pointsMode)
            ->setProductIds($productIds);
    }
    /**
     * Get BankingDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankingDateFrom()
    {
        return isset($this->BankingDateFrom) ? $this->BankingDateFrom : null;
    }
    /**
     * Set BankingDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankingDateFrom
     * @return \patest\StructType\BizAction_Payment_BulkExpireClientsPoints_Request
     */
    public function setBankingDateFrom($bankingDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($bankingDateFrom) && !is_string($bankingDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankingDateFrom, true), gettype($bankingDateFrom)), __LINE__);
        }
        if (is_null($bankingDateFrom) || (is_array($bankingDateFrom) && empty($bankingDateFrom))) {
            unset($this->BankingDateFrom);
        } else {
            $this->BankingDateFrom = $bankingDateFrom;
        }
        return $this;
    }
    /**
     * Get BankingDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBankingDateTo()
    {
        return isset($this->BankingDateTo) ? $this->BankingDateTo : null;
    }
    /**
     * Set BankingDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bankingDateTo
     * @return \patest\StructType\BizAction_Payment_BulkExpireClientsPoints_Request
     */
    public function setBankingDateTo($bankingDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($bankingDateTo) && !is_string($bankingDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bankingDateTo, true), gettype($bankingDateTo)), __LINE__);
        }
        if (is_null($bankingDateTo) || (is_array($bankingDateTo) && empty($bankingDateTo))) {
            unset($this->BankingDateTo);
        } else {
            $this->BankingDateTo = $bankingDateTo;
        }
        return $this;
    }
    /**
     * Get ExpiryDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDateFrom()
    {
        return isset($this->ExpiryDateFrom) ? $this->ExpiryDateFrom : null;
    }
    /**
     * Set ExpiryDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDateFrom
     * @return \patest\StructType\BizAction_Payment_BulkExpireClientsPoints_Request
     */
    public function setExpiryDateFrom($expiryDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDateFrom) && !is_string($expiryDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDateFrom, true), gettype($expiryDateFrom)), __LINE__);
        }
        if (is_null($expiryDateFrom) || (is_array($expiryDateFrom) && empty($expiryDateFrom))) {
            unset($this->ExpiryDateFrom);
        } else {
            $this->ExpiryDateFrom = $expiryDateFrom;
        }
        return $this;
    }
    /**
     * Get ExpiryDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDateTo()
    {
        return isset($this->ExpiryDateTo) ? $this->ExpiryDateTo : null;
    }
    /**
     * Set ExpiryDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDateTo
     * @return \patest\StructType\BizAction_Payment_BulkExpireClientsPoints_Request
     */
    public function setExpiryDateTo($expiryDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDateTo) && !is_string($expiryDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDateTo, true), gettype($expiryDateTo)), __LINE__);
        }
        if (is_null($expiryDateTo) || (is_array($expiryDateTo) && empty($expiryDateTo))) {
            unset($this->ExpiryDateTo);
        } else {
            $this->ExpiryDateTo = $expiryDateTo;
        }
        return $this;
    }
    /**
     * Get ExpiryDateToSet value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiryDateToSet()
    {
        return isset($this->ExpiryDateToSet) ? $this->ExpiryDateToSet : null;
    }
    /**
     * Set ExpiryDateToSet value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiryDateToSet
     * @return \patest\StructType\BizAction_Payment_BulkExpireClientsPoints_Request
     */
    public function setExpiryDateToSet($expiryDateToSet = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDateToSet) && !is_string($expiryDateToSet)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDateToSet, true), gettype($expiryDateToSet)), __LINE__);
        }
        if (is_null($expiryDateToSet) || (is_array($expiryDateToSet) && empty($expiryDateToSet))) {
            unset($this->ExpiryDateToSet);
        } else {
            $this->ExpiryDateToSet = $expiryDateToSet;
        }
        return $this;
    }
    /**
     * Get GrantDateFrom value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGrantDateFrom()
    {
        return isset($this->GrantDateFrom) ? $this->GrantDateFrom : null;
    }
    /**
     * Set GrantDateFrom value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $grantDateFrom
     * @return \patest\StructType\BizAction_Payment_BulkExpireClientsPoints_Request
     */
    public function setGrantDateFrom($grantDateFrom = null)
    {
        // validation for constraint: string
        if (!is_null($grantDateFrom) && !is_string($grantDateFrom)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grantDateFrom, true), gettype($grantDateFrom)), __LINE__);
        }
        if (is_null($grantDateFrom) || (is_array($grantDateFrom) && empty($grantDateFrom))) {
            unset($this->GrantDateFrom);
        } else {
            $this->GrantDateFrom = $grantDateFrom;
        }
        return $this;
    }
    /**
     * Get GrantDateTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGrantDateTo()
    {
        return isset($this->GrantDateTo) ? $this->GrantDateTo : null;
    }
    /**
     * Set GrantDateTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $grantDateTo
     * @return \patest\StructType\BizAction_Payment_BulkExpireClientsPoints_Request
     */
    public function setGrantDateTo($grantDateTo = null)
    {
        // validation for constraint: string
        if (!is_null($grantDateTo) && !is_string($grantDateTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($grantDateTo, true), gettype($grantDateTo)), __LINE__);
        }
        if (is_null($grantDateTo) || (is_array($grantDateTo) && empty($grantDateTo))) {
            unset($this->GrantDateTo);
        } else {
            $this->GrantDateTo = $grantDateTo;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\BizAction_Payment_BulkExpireClientsPoints_Request
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get PointsMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPointsMode()
    {
        return isset($this->PointsMode) ? $this->PointsMode : null;
    }
    /**
     * Set PointsMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\LoyaltyPointsMode::valueIsValid()
     * @uses \patest\EnumType\LoyaltyPointsMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $pointsMode
     * @return \patest\StructType\BizAction_Payment_BulkExpireClientsPoints_Request
     */
    public function setPointsMode($pointsMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\LoyaltyPointsMode::valueIsValid($pointsMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\LoyaltyPointsMode', is_array($pointsMode) ? implode(', ', $pointsMode) : var_export($pointsMode, true), implode(', ', \patest\EnumType\LoyaltyPointsMode::getValidValues())), __LINE__);
        }
        if (is_null($pointsMode) || (is_array($pointsMode) && empty($pointsMode))) {
            unset($this->PointsMode);
        } else {
            $this->PointsMode = $pointsMode;
        }
        return $this;
    }
    /**
     * Get ProductIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProductIds()
    {
        return isset($this->ProductIds) ? $this->ProductIds : null;
    }
    /**
     * Set ProductIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $productIds
     * @return \patest\StructType\BizAction_Payment_BulkExpireClientsPoints_Request
     */
    public function setProductIds($productIds = null)
    {
        // validation for constraint: string
        if (!is_null($productIds) && !is_string($productIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($productIds, true), gettype($productIds)), __LINE__);
        }
        if (is_null($productIds) || (is_array($productIds) && empty($productIds))) {
            unset($this->ProductIds);
        } else {
            $this->ProductIds = $productIds;
        }
        return $this;
    }
}
