<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Merchandise.Print.BaseRequest StructType
 * @subpackage Structs
 */
class BizAction_Merchandise_Print_BaseRequest extends AnyEntity
{
    /**
     * The NumberOfCopies
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfCopies;
    /**
     * The TargetDocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetDocumentId;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * Constructor method for BizAction.Merchandise.Print.BaseRequest
     * @uses BizAction_Merchandise_Print_BaseRequest::setNumberOfCopies()
     * @uses BizAction_Merchandise_Print_BaseRequest::setTargetDocumentId()
     * @uses BizAction_Merchandise_Print_BaseRequest::setTargetPrinterId()
     * @param int $numberOfCopies
     * @param string $targetDocumentId
     * @param string $targetPrinterId
     */
    public function __construct($numberOfCopies = null, $targetDocumentId = null, $targetPrinterId = null)
    {
        $this
            ->setNumberOfCopies($numberOfCopies)
            ->setTargetDocumentId($targetDocumentId)
            ->setTargetPrinterId($targetPrinterId);
    }
    /**
     * Get NumberOfCopies value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfCopies()
    {
        return isset($this->NumberOfCopies) ? $this->NumberOfCopies : null;
    }
    /**
     * Set NumberOfCopies value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfCopies
     * @return \patest\StructType\BizAction_Merchandise_Print_BaseRequest
     */
    public function setNumberOfCopies($numberOfCopies = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfCopies) && !(is_int($numberOfCopies) || ctype_digit($numberOfCopies))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfCopies, true), gettype($numberOfCopies)), __LINE__);
        }
        if (is_null($numberOfCopies) || (is_array($numberOfCopies) && empty($numberOfCopies))) {
            unset($this->NumberOfCopies);
        } else {
            $this->NumberOfCopies = $numberOfCopies;
        }
        return $this;
    }
    /**
     * Get TargetDocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetDocumentId()
    {
        return isset($this->TargetDocumentId) ? $this->TargetDocumentId : null;
    }
    /**
     * Set TargetDocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetDocumentId
     * @return \patest\StructType\BizAction_Merchandise_Print_BaseRequest
     */
    public function setTargetDocumentId($targetDocumentId = null)
    {
        // validation for constraint: string
        if (!is_null($targetDocumentId) && !is_string($targetDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetDocumentId, true), gettype($targetDocumentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetDocumentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetDocumentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetDocumentId, true)), __LINE__);
        }
        if (is_null($targetDocumentId) || (is_array($targetDocumentId) && empty($targetDocumentId))) {
            unset($this->TargetDocumentId);
        } else {
            $this->TargetDocumentId = $targetDocumentId;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\BizAction_Merchandise_Print_BaseRequest
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
}
