<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Membership.Sales.UtilizeBenefits.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Membership_Sales_UtilizeBenefits_Request extends AnyEntity
{
    /**
     * The RequestedBasketItems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSales_ItemInformation
     */
    public $RequestedBasketItems;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * Constructor method for BizAction.Membership.Sales.UtilizeBenefits.Request
     * @uses BizAction_Membership_Sales_UtilizeBenefits_Request::setRequestedBasketItems()
     * @uses BizAction_Membership_Sales_UtilizeBenefits_Request::setTransactionGuid()
     * @param \patest\StructType\RecordSetOfSales_ItemInformation $requestedBasketItems
     * @param string $transactionGuid
     */
    public function __construct(\patest\StructType\RecordSetOfSales_ItemInformation $requestedBasketItems = null, $transactionGuid = null)
    {
        $this
            ->setRequestedBasketItems($requestedBasketItems)
            ->setTransactionGuid($transactionGuid);
    }
    /**
     * Get RequestedBasketItems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSales_ItemInformation|null
     */
    public function getRequestedBasketItems()
    {
        return isset($this->RequestedBasketItems) ? $this->RequestedBasketItems : null;
    }
    /**
     * Set RequestedBasketItems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSales_ItemInformation $requestedBasketItems
     * @return \patest\StructType\BizAction_Membership_Sales_UtilizeBenefits_Request
     */
    public function setRequestedBasketItems(\patest\StructType\RecordSetOfSales_ItemInformation $requestedBasketItems = null)
    {
        if (is_null($requestedBasketItems) || (is_array($requestedBasketItems) && empty($requestedBasketItems))) {
            unset($this->RequestedBasketItems);
        } else {
            $this->RequestedBasketItems = $requestedBasketItems;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\BizAction_Membership_Sales_UtilizeBenefits_Request
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
}
