<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Marketing.ScheduleQuery.Request StructType
 * @subpackage Structs
 */
class BizAction_Marketing_ScheduleQuery_Request extends BizActionLogics_Foundation_ProcessSchedule_Schedule_Request
{
    /**
     * The AppealId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AppealId;
    /**
     * The AssignRequestTo
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AssignRequestTo;
    /**
     * The CampaignId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CampaignId;
    /**
     * The DynamicAttributeAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DynamicAttributeAction;
    /**
     * The DynamicClientTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicClientTypeId;
    /**
     * The DynamicPreferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DynamicPreferenceId;
    /**
     * The EmailSubject
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailSubject;
    /**
     * The IncludeManuallyAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IncludeManuallyAttributes;
    /**
     * The IsApplyDynamicAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsApplyDynamicAttributes;
    /**
     * The IsStoreResultsInHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsStoreResultsInHistory;
    /**
     * The OpenServiceRequestForEachClient
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $OpenServiceRequestForEachClient;
    /**
     * The OutputProperties
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty
     */
    public $OutputProperties;
    /**
     * The PlaceHolders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Marketing_ScheduleQuery_PlaceHolder
     */
    public $PlaceHolders;
    /**
     * The QueryId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $QueryId;
    /**
     * The RunningUserId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RunningUserId;
    /**
     * The SendEmailOnCompletion
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendEmailOnCompletion;
    /**
     * The SendEmailTo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SendEmailTo;
    /**
     * The SendEmptyResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendEmptyResults;
    /**
     * The SendResultsByEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendResultsByEmail;
    /**
     * The SendToUserEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendToUserEmail;
    /**
     * The ServiceRequestAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceRequestAction;
    /**
     * The ServiceRequestDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceRequestDetails;
    /**
     * The ServiceRequestExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceRequestExpiryDate;
    /**
     * The ServiceRequestPriority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ServiceRequestPriority;
    /**
     * The ServiceRequestTypeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ServiceRequestTypeId;
    /**
     * The StoreResults
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $StoreResults;
    /**
     * The SubQueries
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfQueryBuilder_SubQuery
     */
    public $SubQueries;
    /**
     * The WriteClientActivities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $WriteClientActivities;
    /**
     * Constructor method for BizAction.Marketing.ScheduleQuery.Request
     * @uses BizAction_Marketing_ScheduleQuery_Request::setAppealId()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setAssignRequestTo()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setCampaignId()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setDynamicAttributeAction()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setDynamicClientTypeId()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setDynamicPreferenceId()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setEmailSubject()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setIncludeManuallyAttributes()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setIsApplyDynamicAttributes()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setIsStoreResultsInHistory()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setOpenServiceRequestForEachClient()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setOutputProperties()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setPlaceHolders()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setQueryId()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setRunningUserId()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setSendEmailOnCompletion()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setSendEmailTo()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setSendEmptyResults()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setSendResultsByEmail()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setSendToUserEmail()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setServiceRequestAction()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setServiceRequestDetails()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setServiceRequestExpiryDate()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setServiceRequestPriority()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setServiceRequestTypeId()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setStoreResults()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setSubQueries()
     * @uses BizAction_Marketing_ScheduleQuery_Request::setWriteClientActivities()
     * @param string $appealId
     * @param string $assignRequestTo
     * @param string $campaignId
     * @param string $dynamicAttributeAction
     * @param string $dynamicClientTypeId
     * @param string $dynamicPreferenceId
     * @param string $emailSubject
     * @param bool $includeManuallyAttributes
     * @param bool $isApplyDynamicAttributes
     * @param bool $isStoreResultsInHistory
     * @param bool $openServiceRequestForEachClient
     * @param \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty $outputProperties
     * @param \patest\StructType\RecordSetOfBizAction_Marketing_ScheduleQuery_PlaceHolder $placeHolders
     * @param string $queryId
     * @param string $runningUserId
     * @param bool $sendEmailOnCompletion
     * @param string $sendEmailTo
     * @param bool $sendEmptyResults
     * @param bool $sendResultsByEmail
     * @param bool $sendToUserEmail
     * @param string $serviceRequestAction
     * @param string $serviceRequestDetails
     * @param string $serviceRequestExpiryDate
     * @param string $serviceRequestPriority
     * @param string $serviceRequestTypeId
     * @param bool $storeResults
     * @param \patest\StructType\RecordSetOfQueryBuilder_SubQuery $subQueries
     * @param bool $writeClientActivities
     */
    public function __construct($appealId = null, $assignRequestTo = null, $campaignId = null, $dynamicAttributeAction = null, $dynamicClientTypeId = null, $dynamicPreferenceId = null, $emailSubject = null, $includeManuallyAttributes = null, $isApplyDynamicAttributes = null, $isStoreResultsInHistory = null, $openServiceRequestForEachClient = null, \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty $outputProperties = null, \patest\StructType\RecordSetOfBizAction_Marketing_ScheduleQuery_PlaceHolder $placeHolders = null, $queryId = null, $runningUserId = null, $sendEmailOnCompletion = null, $sendEmailTo = null, $sendEmptyResults = null, $sendResultsByEmail = null, $sendToUserEmail = null, $serviceRequestAction = null, $serviceRequestDetails = null, $serviceRequestExpiryDate = null, $serviceRequestPriority = null, $serviceRequestTypeId = null, $storeResults = null, \patest\StructType\RecordSetOfQueryBuilder_SubQuery $subQueries = null, $writeClientActivities = null)
    {
        $this
            ->setAppealId($appealId)
            ->setAssignRequestTo($assignRequestTo)
            ->setCampaignId($campaignId)
            ->setDynamicAttributeAction($dynamicAttributeAction)
            ->setDynamicClientTypeId($dynamicClientTypeId)
            ->setDynamicPreferenceId($dynamicPreferenceId)
            ->setEmailSubject($emailSubject)
            ->setIncludeManuallyAttributes($includeManuallyAttributes)
            ->setIsApplyDynamicAttributes($isApplyDynamicAttributes)
            ->setIsStoreResultsInHistory($isStoreResultsInHistory)
            ->setOpenServiceRequestForEachClient($openServiceRequestForEachClient)
            ->setOutputProperties($outputProperties)
            ->setPlaceHolders($placeHolders)
            ->setQueryId($queryId)
            ->setRunningUserId($runningUserId)
            ->setSendEmailOnCompletion($sendEmailOnCompletion)
            ->setSendEmailTo($sendEmailTo)
            ->setSendEmptyResults($sendEmptyResults)
            ->setSendResultsByEmail($sendResultsByEmail)
            ->setSendToUserEmail($sendToUserEmail)
            ->setServiceRequestAction($serviceRequestAction)
            ->setServiceRequestDetails($serviceRequestDetails)
            ->setServiceRequestExpiryDate($serviceRequestExpiryDate)
            ->setServiceRequestPriority($serviceRequestPriority)
            ->setServiceRequestTypeId($serviceRequestTypeId)
            ->setStoreResults($storeResults)
            ->setSubQueries($subQueries)
            ->setWriteClientActivities($writeClientActivities);
    }
    /**
     * Get AppealId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAppealId()
    {
        return isset($this->AppealId) ? $this->AppealId : null;
    }
    /**
     * Set AppealId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $appealId
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setAppealId($appealId = null)
    {
        // validation for constraint: string
        if (!is_null($appealId) && !is_string($appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appealId, true), gettype($appealId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($appealId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $appealId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($appealId, true)), __LINE__);
        }
        if (is_null($appealId) || (is_array($appealId) && empty($appealId))) {
            unset($this->AppealId);
        } else {
            $this->AppealId = $appealId;
        }
        return $this;
    }
    /**
     * Get AssignRequestTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssignRequestTo()
    {
        return isset($this->AssignRequestTo) ? $this->AssignRequestTo : null;
    }
    /**
     * Set AssignRequestTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $assignRequestTo
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setAssignRequestTo($assignRequestTo = null)
    {
        // validation for constraint: string
        if (!is_null($assignRequestTo) && !is_string($assignRequestTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($assignRequestTo, true), gettype($assignRequestTo)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($assignRequestTo) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $assignRequestTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($assignRequestTo, true)), __LINE__);
        }
        if (is_null($assignRequestTo) || (is_array($assignRequestTo) && empty($assignRequestTo))) {
            unset($this->AssignRequestTo);
        } else {
            $this->AssignRequestTo = $assignRequestTo;
        }
        return $this;
    }
    /**
     * Get CampaignId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCampaignId()
    {
        return isset($this->CampaignId) ? $this->CampaignId : null;
    }
    /**
     * Set CampaignId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $campaignId
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setCampaignId($campaignId = null)
    {
        // validation for constraint: string
        if (!is_null($campaignId) && !is_string($campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($campaignId, true), gettype($campaignId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($campaignId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $campaignId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($campaignId, true)), __LINE__);
        }
        if (is_null($campaignId) || (is_array($campaignId) && empty($campaignId))) {
            unset($this->CampaignId);
        } else {
            $this->CampaignId = $campaignId;
        }
        return $this;
    }
    /**
     * Get DynamicAttributeAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicAttributeAction()
    {
        return isset($this->DynamicAttributeAction) ? $this->DynamicAttributeAction : null;
    }
    /**
     * Set DynamicAttributeAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DynamicAttributeAction::valueIsValid()
     * @uses \patest\EnumType\DynamicAttributeAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dynamicAttributeAction
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setDynamicAttributeAction($dynamicAttributeAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DynamicAttributeAction::valueIsValid($dynamicAttributeAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DynamicAttributeAction', is_array($dynamicAttributeAction) ? implode(', ', $dynamicAttributeAction) : var_export($dynamicAttributeAction, true), implode(', ', \patest\EnumType\DynamicAttributeAction::getValidValues())), __LINE__);
        }
        if (is_null($dynamicAttributeAction) || (is_array($dynamicAttributeAction) && empty($dynamicAttributeAction))) {
            unset($this->DynamicAttributeAction);
        } else {
            $this->DynamicAttributeAction = $dynamicAttributeAction;
        }
        return $this;
    }
    /**
     * Get DynamicClientTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicClientTypeId()
    {
        return isset($this->DynamicClientTypeId) ? $this->DynamicClientTypeId : null;
    }
    /**
     * Set DynamicClientTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicClientTypeId
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setDynamicClientTypeId($dynamicClientTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicClientTypeId) && !is_string($dynamicClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicClientTypeId, true), gettype($dynamicClientTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicClientTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicClientTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicClientTypeId, true)), __LINE__);
        }
        if (is_null($dynamicClientTypeId) || (is_array($dynamicClientTypeId) && empty($dynamicClientTypeId))) {
            unset($this->DynamicClientTypeId);
        } else {
            $this->DynamicClientTypeId = $dynamicClientTypeId;
        }
        return $this;
    }
    /**
     * Get DynamicPreferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDynamicPreferenceId()
    {
        return isset($this->DynamicPreferenceId) ? $this->DynamicPreferenceId : null;
    }
    /**
     * Set DynamicPreferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dynamicPreferenceId
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setDynamicPreferenceId($dynamicPreferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($dynamicPreferenceId) && !is_string($dynamicPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dynamicPreferenceId, true), gettype($dynamicPreferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($dynamicPreferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $dynamicPreferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($dynamicPreferenceId, true)), __LINE__);
        }
        if (is_null($dynamicPreferenceId) || (is_array($dynamicPreferenceId) && empty($dynamicPreferenceId))) {
            unset($this->DynamicPreferenceId);
        } else {
            $this->DynamicPreferenceId = $dynamicPreferenceId;
        }
        return $this;
    }
    /**
     * Get EmailSubject value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailSubject()
    {
        return isset($this->EmailSubject) ? $this->EmailSubject : null;
    }
    /**
     * Set EmailSubject value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailSubject
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setEmailSubject($emailSubject = null)
    {
        // validation for constraint: string
        if (!is_null($emailSubject) && !is_string($emailSubject)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailSubject, true), gettype($emailSubject)), __LINE__);
        }
        if (is_null($emailSubject) || (is_array($emailSubject) && empty($emailSubject))) {
            unset($this->EmailSubject);
        } else {
            $this->EmailSubject = $emailSubject;
        }
        return $this;
    }
    /**
     * Get IncludeManuallyAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIncludeManuallyAttributes()
    {
        return isset($this->IncludeManuallyAttributes) ? $this->IncludeManuallyAttributes : null;
    }
    /**
     * Set IncludeManuallyAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $includeManuallyAttributes
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setIncludeManuallyAttributes($includeManuallyAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeManuallyAttributes) && !is_bool($includeManuallyAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeManuallyAttributes, true), gettype($includeManuallyAttributes)), __LINE__);
        }
        if (is_null($includeManuallyAttributes) || (is_array($includeManuallyAttributes) && empty($includeManuallyAttributes))) {
            unset($this->IncludeManuallyAttributes);
        } else {
            $this->IncludeManuallyAttributes = $includeManuallyAttributes;
        }
        return $this;
    }
    /**
     * Get IsApplyDynamicAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsApplyDynamicAttributes()
    {
        return isset($this->IsApplyDynamicAttributes) ? $this->IsApplyDynamicAttributes : null;
    }
    /**
     * Set IsApplyDynamicAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isApplyDynamicAttributes
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setIsApplyDynamicAttributes($isApplyDynamicAttributes = null)
    {
        // validation for constraint: boolean
        if (!is_null($isApplyDynamicAttributes) && !is_bool($isApplyDynamicAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isApplyDynamicAttributes, true), gettype($isApplyDynamicAttributes)), __LINE__);
        }
        if (is_null($isApplyDynamicAttributes) || (is_array($isApplyDynamicAttributes) && empty($isApplyDynamicAttributes))) {
            unset($this->IsApplyDynamicAttributes);
        } else {
            $this->IsApplyDynamicAttributes = $isApplyDynamicAttributes;
        }
        return $this;
    }
    /**
     * Get IsStoreResultsInHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsStoreResultsInHistory()
    {
        return isset($this->IsStoreResultsInHistory) ? $this->IsStoreResultsInHistory : null;
    }
    /**
     * Set IsStoreResultsInHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isStoreResultsInHistory
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setIsStoreResultsInHistory($isStoreResultsInHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($isStoreResultsInHistory) && !is_bool($isStoreResultsInHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isStoreResultsInHistory, true), gettype($isStoreResultsInHistory)), __LINE__);
        }
        if (is_null($isStoreResultsInHistory) || (is_array($isStoreResultsInHistory) && empty($isStoreResultsInHistory))) {
            unset($this->IsStoreResultsInHistory);
        } else {
            $this->IsStoreResultsInHistory = $isStoreResultsInHistory;
        }
        return $this;
    }
    /**
     * Get OpenServiceRequestForEachClient value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getOpenServiceRequestForEachClient()
    {
        return isset($this->OpenServiceRequestForEachClient) ? $this->OpenServiceRequestForEachClient : null;
    }
    /**
     * Set OpenServiceRequestForEachClient value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $openServiceRequestForEachClient
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setOpenServiceRequestForEachClient($openServiceRequestForEachClient = null)
    {
        // validation for constraint: boolean
        if (!is_null($openServiceRequestForEachClient) && !is_bool($openServiceRequestForEachClient)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($openServiceRequestForEachClient, true), gettype($openServiceRequestForEachClient)), __LINE__);
        }
        if (is_null($openServiceRequestForEachClient) || (is_array($openServiceRequestForEachClient) && empty($openServiceRequestForEachClient))) {
            unset($this->OpenServiceRequestForEachClient);
        } else {
            $this->OpenServiceRequestForEachClient = $openServiceRequestForEachClient;
        }
        return $this;
    }
    /**
     * Get OutputProperties value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty|null
     */
    public function getOutputProperties()
    {
        return isset($this->OutputProperties) ? $this->OutputProperties : null;
    }
    /**
     * Set OutputProperties value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty $outputProperties
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setOutputProperties(\patest\StructType\RecordSetOfQueryBuilder_QueryOutputProperty $outputProperties = null)
    {
        if (is_null($outputProperties) || (is_array($outputProperties) && empty($outputProperties))) {
            unset($this->OutputProperties);
        } else {
            $this->OutputProperties = $outputProperties;
        }
        return $this;
    }
    /**
     * Get PlaceHolders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Marketing_ScheduleQuery_PlaceHolder|null
     */
    public function getPlaceHolders()
    {
        return isset($this->PlaceHolders) ? $this->PlaceHolders : null;
    }
    /**
     * Set PlaceHolders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Marketing_ScheduleQuery_PlaceHolder $placeHolders
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setPlaceHolders(\patest\StructType\RecordSetOfBizAction_Marketing_ScheduleQuery_PlaceHolder $placeHolders = null)
    {
        if (is_null($placeHolders) || (is_array($placeHolders) && empty($placeHolders))) {
            unset($this->PlaceHolders);
        } else {
            $this->PlaceHolders = $placeHolders;
        }
        return $this;
    }
    /**
     * Get QueryId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getQueryId()
    {
        return isset($this->QueryId) ? $this->QueryId : null;
    }
    /**
     * Set QueryId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $queryId
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setQueryId($queryId = null)
    {
        // validation for constraint: string
        if (!is_null($queryId) && !is_string($queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($queryId, true), gettype($queryId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($queryId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $queryId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($queryId, true)), __LINE__);
        }
        if (is_null($queryId) || (is_array($queryId) && empty($queryId))) {
            unset($this->QueryId);
        } else {
            $this->QueryId = $queryId;
        }
        return $this;
    }
    /**
     * Get RunningUserId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRunningUserId()
    {
        return isset($this->RunningUserId) ? $this->RunningUserId : null;
    }
    /**
     * Set RunningUserId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $runningUserId
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setRunningUserId($runningUserId = null)
    {
        // validation for constraint: string
        if (!is_null($runningUserId) && !is_string($runningUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($runningUserId, true), gettype($runningUserId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($runningUserId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $runningUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($runningUserId, true)), __LINE__);
        }
        if (is_null($runningUserId) || (is_array($runningUserId) && empty($runningUserId))) {
            unset($this->RunningUserId);
        } else {
            $this->RunningUserId = $runningUserId;
        }
        return $this;
    }
    /**
     * Get SendEmailOnCompletion value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendEmailOnCompletion()
    {
        return isset($this->SendEmailOnCompletion) ? $this->SendEmailOnCompletion : null;
    }
    /**
     * Set SendEmailOnCompletion value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendEmailOnCompletion
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setSendEmailOnCompletion($sendEmailOnCompletion = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmailOnCompletion) && !is_bool($sendEmailOnCompletion)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendEmailOnCompletion, true), gettype($sendEmailOnCompletion)), __LINE__);
        }
        if (is_null($sendEmailOnCompletion) || (is_array($sendEmailOnCompletion) && empty($sendEmailOnCompletion))) {
            unset($this->SendEmailOnCompletion);
        } else {
            $this->SendEmailOnCompletion = $sendEmailOnCompletion;
        }
        return $this;
    }
    /**
     * Get SendEmailTo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSendEmailTo()
    {
        return isset($this->SendEmailTo) ? $this->SendEmailTo : null;
    }
    /**
     * Set SendEmailTo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sendEmailTo
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setSendEmailTo($sendEmailTo = null)
    {
        // validation for constraint: string
        if (!is_null($sendEmailTo) && !is_string($sendEmailTo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sendEmailTo, true), gettype($sendEmailTo)), __LINE__);
        }
        if (is_null($sendEmailTo) || (is_array($sendEmailTo) && empty($sendEmailTo))) {
            unset($this->SendEmailTo);
        } else {
            $this->SendEmailTo = $sendEmailTo;
        }
        return $this;
    }
    /**
     * Get SendEmptyResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendEmptyResults()
    {
        return isset($this->SendEmptyResults) ? $this->SendEmptyResults : null;
    }
    /**
     * Set SendEmptyResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendEmptyResults
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setSendEmptyResults($sendEmptyResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendEmptyResults) && !is_bool($sendEmptyResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendEmptyResults, true), gettype($sendEmptyResults)), __LINE__);
        }
        if (is_null($sendEmptyResults) || (is_array($sendEmptyResults) && empty($sendEmptyResults))) {
            unset($this->SendEmptyResults);
        } else {
            $this->SendEmptyResults = $sendEmptyResults;
        }
        return $this;
    }
    /**
     * Get SendResultsByEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendResultsByEmail()
    {
        return isset($this->SendResultsByEmail) ? $this->SendResultsByEmail : null;
    }
    /**
     * Set SendResultsByEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendResultsByEmail
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setSendResultsByEmail($sendResultsByEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendResultsByEmail) && !is_bool($sendResultsByEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendResultsByEmail, true), gettype($sendResultsByEmail)), __LINE__);
        }
        if (is_null($sendResultsByEmail) || (is_array($sendResultsByEmail) && empty($sendResultsByEmail))) {
            unset($this->SendResultsByEmail);
        } else {
            $this->SendResultsByEmail = $sendResultsByEmail;
        }
        return $this;
    }
    /**
     * Get SendToUserEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendToUserEmail()
    {
        return isset($this->SendToUserEmail) ? $this->SendToUserEmail : null;
    }
    /**
     * Set SendToUserEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendToUserEmail
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setSendToUserEmail($sendToUserEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendToUserEmail) && !is_bool($sendToUserEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendToUserEmail, true), gettype($sendToUserEmail)), __LINE__);
        }
        if (is_null($sendToUserEmail) || (is_array($sendToUserEmail) && empty($sendToUserEmail))) {
            unset($this->SendToUserEmail);
        } else {
            $this->SendToUserEmail = $sendToUserEmail;
        }
        return $this;
    }
    /**
     * Get ServiceRequestAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceRequestAction()
    {
        return isset($this->ServiceRequestAction) ? $this->ServiceRequestAction : null;
    }
    /**
     * Set ServiceRequestAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceRequestAction
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setServiceRequestAction($serviceRequestAction = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRequestAction) && !is_string($serviceRequestAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRequestAction, true), gettype($serviceRequestAction)), __LINE__);
        }
        if (is_null($serviceRequestAction) || (is_array($serviceRequestAction) && empty($serviceRequestAction))) {
            unset($this->ServiceRequestAction);
        } else {
            $this->ServiceRequestAction = $serviceRequestAction;
        }
        return $this;
    }
    /**
     * Get ServiceRequestDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceRequestDetails()
    {
        return isset($this->ServiceRequestDetails) ? $this->ServiceRequestDetails : null;
    }
    /**
     * Set ServiceRequestDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceRequestDetails
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setServiceRequestDetails($serviceRequestDetails = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRequestDetails) && !is_string($serviceRequestDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRequestDetails, true), gettype($serviceRequestDetails)), __LINE__);
        }
        if (is_null($serviceRequestDetails) || (is_array($serviceRequestDetails) && empty($serviceRequestDetails))) {
            unset($this->ServiceRequestDetails);
        } else {
            $this->ServiceRequestDetails = $serviceRequestDetails;
        }
        return $this;
    }
    /**
     * Get ServiceRequestExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceRequestExpiryDate()
    {
        return isset($this->ServiceRequestExpiryDate) ? $this->ServiceRequestExpiryDate : null;
    }
    /**
     * Set ServiceRequestExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceRequestExpiryDate
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setServiceRequestExpiryDate($serviceRequestExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRequestExpiryDate) && !is_string($serviceRequestExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRequestExpiryDate, true), gettype($serviceRequestExpiryDate)), __LINE__);
        }
        if (is_null($serviceRequestExpiryDate) || (is_array($serviceRequestExpiryDate) && empty($serviceRequestExpiryDate))) {
            unset($this->ServiceRequestExpiryDate);
        } else {
            $this->ServiceRequestExpiryDate = $serviceRequestExpiryDate;
        }
        return $this;
    }
    /**
     * Get ServiceRequestPriority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceRequestPriority()
    {
        return isset($this->ServiceRequestPriority) ? $this->ServiceRequestPriority : null;
    }
    /**
     * Set ServiceRequestPriority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\RequestPriority::valueIsValid()
     * @uses \patest\EnumType\RequestPriority::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $serviceRequestPriority
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setServiceRequestPriority($serviceRequestPriority = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\RequestPriority::valueIsValid($serviceRequestPriority)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\RequestPriority', is_array($serviceRequestPriority) ? implode(', ', $serviceRequestPriority) : var_export($serviceRequestPriority, true), implode(', ', \patest\EnumType\RequestPriority::getValidValues())), __LINE__);
        }
        if (is_null($serviceRequestPriority) || (is_array($serviceRequestPriority) && empty($serviceRequestPriority))) {
            unset($this->ServiceRequestPriority);
        } else {
            $this->ServiceRequestPriority = $serviceRequestPriority;
        }
        return $this;
    }
    /**
     * Get ServiceRequestTypeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getServiceRequestTypeId()
    {
        return isset($this->ServiceRequestTypeId) ? $this->ServiceRequestTypeId : null;
    }
    /**
     * Set ServiceRequestTypeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serviceRequestTypeId
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setServiceRequestTypeId($serviceRequestTypeId = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRequestTypeId) && !is_string($serviceRequestTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRequestTypeId, true), gettype($serviceRequestTypeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($serviceRequestTypeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $serviceRequestTypeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($serviceRequestTypeId, true)), __LINE__);
        }
        if (is_null($serviceRequestTypeId) || (is_array($serviceRequestTypeId) && empty($serviceRequestTypeId))) {
            unset($this->ServiceRequestTypeId);
        } else {
            $this->ServiceRequestTypeId = $serviceRequestTypeId;
        }
        return $this;
    }
    /**
     * Get StoreResults value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getStoreResults()
    {
        return isset($this->StoreResults) ? $this->StoreResults : null;
    }
    /**
     * Set StoreResults value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $storeResults
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setStoreResults($storeResults = null)
    {
        // validation for constraint: boolean
        if (!is_null($storeResults) && !is_bool($storeResults)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($storeResults, true), gettype($storeResults)), __LINE__);
        }
        if (is_null($storeResults) || (is_array($storeResults) && empty($storeResults))) {
            unset($this->StoreResults);
        } else {
            $this->StoreResults = $storeResults;
        }
        return $this;
    }
    /**
     * Get SubQueries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfQueryBuilder_SubQuery|null
     */
    public function getSubQueries()
    {
        return isset($this->SubQueries) ? $this->SubQueries : null;
    }
    /**
     * Set SubQueries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfQueryBuilder_SubQuery $subQueries
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setSubQueries(\patest\StructType\RecordSetOfQueryBuilder_SubQuery $subQueries = null)
    {
        if (is_null($subQueries) || (is_array($subQueries) && empty($subQueries))) {
            unset($this->SubQueries);
        } else {
            $this->SubQueries = $subQueries;
        }
        return $this;
    }
    /**
     * Get WriteClientActivities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getWriteClientActivities()
    {
        return isset($this->WriteClientActivities) ? $this->WriteClientActivities : null;
    }
    /**
     * Set WriteClientActivities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $writeClientActivities
     * @return \patest\StructType\BizAction_Marketing_ScheduleQuery_Request
     */
    public function setWriteClientActivities($writeClientActivities = null)
    {
        // validation for constraint: boolean
        if (!is_null($writeClientActivities) && !is_bool($writeClientActivities)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($writeClientActivities, true), gettype($writeClientActivities)), __LINE__);
        }
        if (is_null($writeClientActivities) || (is_array($writeClientActivities) && empty($writeClientActivities))) {
            unset($this->WriteClientActivities);
        } else {
            $this->WriteClientActivities = $writeClientActivities;
        }
        return $this;
    }
}
