<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Foundation.RulesOverview.Rule StructType
 * @subpackage Structs
 */
class BizAction_Foundation_RulesOverview_Rule extends AnyEntity
{
    /**
     * The ActionsDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ActionsDescription;
    /**
     * The ContextEntityId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextEntityId;
    /**
     * The ContextEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContextEntityName;
    /**
     * The Criteria
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfBizAction_Foundation_RulesOverview_Criteria
     */
    public $Criteria;
    /**
     * The DisableUserEdit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisableUserEdit;
    /**
     * The Effective
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Effective;
    /**
     * The Id
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for BizAction.Foundation.RulesOverview.Rule
     * @uses BizAction_Foundation_RulesOverview_Rule::setActionsDescription()
     * @uses BizAction_Foundation_RulesOverview_Rule::setContextEntityId()
     * @uses BizAction_Foundation_RulesOverview_Rule::setContextEntityName()
     * @uses BizAction_Foundation_RulesOverview_Rule::setCriteria()
     * @uses BizAction_Foundation_RulesOverview_Rule::setDisableUserEdit()
     * @uses BizAction_Foundation_RulesOverview_Rule::setEffective()
     * @uses BizAction_Foundation_RulesOverview_Rule::setId()
     * @uses BizAction_Foundation_RulesOverview_Rule::setName()
     * @uses BizAction_Foundation_RulesOverview_Rule::setPriority()
     * @uses BizAction_Foundation_RulesOverview_Rule::setStatus()
     * @param string $actionsDescription
     * @param string $contextEntityId
     * @param string $contextEntityName
     * @param \patest\StructType\RecordSetOfBizAction_Foundation_RulesOverview_Criteria $criteria
     * @param bool $disableUserEdit
     * @param bool $effective
     * @param string $id
     * @param string $name
     * @param int $priority
     * @param string $status
     */
    public function __construct($actionsDescription = null, $contextEntityId = null, $contextEntityName = null, \patest\StructType\RecordSetOfBizAction_Foundation_RulesOverview_Criteria $criteria = null, $disableUserEdit = null, $effective = null, $id = null, $name = null, $priority = null, $status = null)
    {
        $this
            ->setActionsDescription($actionsDescription)
            ->setContextEntityId($contextEntityId)
            ->setContextEntityName($contextEntityName)
            ->setCriteria($criteria)
            ->setDisableUserEdit($disableUserEdit)
            ->setEffective($effective)
            ->setId($id)
            ->setName($name)
            ->setPriority($priority)
            ->setStatus($status);
    }
    /**
     * Get ActionsDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getActionsDescription()
    {
        return isset($this->ActionsDescription) ? $this->ActionsDescription : null;
    }
    /**
     * Set ActionsDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $actionsDescription
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Rule
     */
    public function setActionsDescription($actionsDescription = null)
    {
        // validation for constraint: string
        if (!is_null($actionsDescription) && !is_string($actionsDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($actionsDescription, true), gettype($actionsDescription)), __LINE__);
        }
        if (is_null($actionsDescription) || (is_array($actionsDescription) && empty($actionsDescription))) {
            unset($this->ActionsDescription);
        } else {
            $this->ActionsDescription = $actionsDescription;
        }
        return $this;
    }
    /**
     * Get ContextEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextEntityId()
    {
        return isset($this->ContextEntityId) ? $this->ContextEntityId : null;
    }
    /**
     * Set ContextEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextEntityId
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Rule
     */
    public function setContextEntityId($contextEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($contextEntityId) && !is_string($contextEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextEntityId, true), gettype($contextEntityId)), __LINE__);
        }
        if (is_null($contextEntityId) || (is_array($contextEntityId) && empty($contextEntityId))) {
            unset($this->ContextEntityId);
        } else {
            $this->ContextEntityId = $contextEntityId;
        }
        return $this;
    }
    /**
     * Get ContextEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContextEntityName()
    {
        return isset($this->ContextEntityName) ? $this->ContextEntityName : null;
    }
    /**
     * Set ContextEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contextEntityName
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Rule
     */
    public function setContextEntityName($contextEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($contextEntityName) && !is_string($contextEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contextEntityName, true), gettype($contextEntityName)), __LINE__);
        }
        if (is_null($contextEntityName) || (is_array($contextEntityName) && empty($contextEntityName))) {
            unset($this->ContextEntityName);
        } else {
            $this->ContextEntityName = $contextEntityName;
        }
        return $this;
    }
    /**
     * Get Criteria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfBizAction_Foundation_RulesOverview_Criteria|null
     */
    public function getCriteria()
    {
        return isset($this->Criteria) ? $this->Criteria : null;
    }
    /**
     * Set Criteria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfBizAction_Foundation_RulesOverview_Criteria $criteria
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Rule
     */
    public function setCriteria(\patest\StructType\RecordSetOfBizAction_Foundation_RulesOverview_Criteria $criteria = null)
    {
        if (is_null($criteria) || (is_array($criteria) && empty($criteria))) {
            unset($this->Criteria);
        } else {
            $this->Criteria = $criteria;
        }
        return $this;
    }
    /**
     * Get DisableUserEdit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisableUserEdit()
    {
        return isset($this->DisableUserEdit) ? $this->DisableUserEdit : null;
    }
    /**
     * Set DisableUserEdit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $disableUserEdit
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Rule
     */
    public function setDisableUserEdit($disableUserEdit = null)
    {
        // validation for constraint: boolean
        if (!is_null($disableUserEdit) && !is_bool($disableUserEdit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($disableUserEdit, true), gettype($disableUserEdit)), __LINE__);
        }
        if (is_null($disableUserEdit) || (is_array($disableUserEdit) && empty($disableUserEdit))) {
            unset($this->DisableUserEdit);
        } else {
            $this->DisableUserEdit = $disableUserEdit;
        }
        return $this;
    }
    /**
     * Get Effective value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEffective()
    {
        return isset($this->Effective) ? $this->Effective : null;
    }
    /**
     * Set Effective value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $effective
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Rule
     */
    public function setEffective($effective = null)
    {
        // validation for constraint: boolean
        if (!is_null($effective) && !is_bool($effective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($effective, true), gettype($effective)), __LINE__);
        }
        if (is_null($effective) || (is_array($effective) && empty($effective))) {
            unset($this->Effective);
        } else {
            $this->Effective = $effective;
        }
        return $this;
    }
    /**
     * Get Id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getId()
    {
        return isset($this->Id) ? $this->Id : null;
    }
    /**
     * Set Id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $id
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Rule
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($id, true), gettype($id)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($id, true)), __LINE__);
        }
        if (is_null($id) || (is_array($id) && empty($id))) {
            unset($this->Id);
        } else {
            $this->Id = $id;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Rule
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Rule
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \patest\StructType\BizAction_Foundation_RulesOverview_Rule
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($status, true), gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
