<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Foundation.BulkOperation.Request StructType
 * @subpackage Structs
 */
class BizAction_Foundation_BulkOperation_Request extends AnyEntity
{
    /**
     * The BulkOperation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BulkOperation;
    /**
     * The ConfigurationStepCompleted
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ConfigurationStepCompleted;
    /**
     * The ConfigurationStepDirection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfigurationStepDirection;
    /**
     * The ConfigurationStepIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ConfigurationStepIndex;
    /**
     * The ConfigurationStepName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfigurationStepName;
    /**
     * The DateTimeFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeFormat;
    /**
     * The Delimiter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Delimiter;
    /**
     * The FileData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileData;
    /**
     * The FileFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileFormat;
    /**
     * The FileHasHeaders
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FileHasHeaders;
    /**
     * The FileName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileName;
    /**
     * The Notes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notes;
    /**
     * The PreviewData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PreviewData;
    /**
     * The RelatedId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $RelatedId;
    /**
     * The ScreenSubTitleCaptionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScreenSubTitleCaptionId;
    /**
     * The ScreenTitleCaptionId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScreenTitleCaptionId;
    /**
     * The Step
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Step;
    /**
     * The UIViewName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UIViewName;
    /**
     * The UploadedDataId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UploadedDataId;
    /**
     * Constructor method for BizAction.Foundation.BulkOperation.Request
     * @uses BizAction_Foundation_BulkOperation_Request::setBulkOperation()
     * @uses BizAction_Foundation_BulkOperation_Request::setConfigurationStepCompleted()
     * @uses BizAction_Foundation_BulkOperation_Request::setConfigurationStepDirection()
     * @uses BizAction_Foundation_BulkOperation_Request::setConfigurationStepIndex()
     * @uses BizAction_Foundation_BulkOperation_Request::setConfigurationStepName()
     * @uses BizAction_Foundation_BulkOperation_Request::setDateTimeFormat()
     * @uses BizAction_Foundation_BulkOperation_Request::setDelimiter()
     * @uses BizAction_Foundation_BulkOperation_Request::setFileData()
     * @uses BizAction_Foundation_BulkOperation_Request::setFileFormat()
     * @uses BizAction_Foundation_BulkOperation_Request::setFileHasHeaders()
     * @uses BizAction_Foundation_BulkOperation_Request::setFileName()
     * @uses BizAction_Foundation_BulkOperation_Request::setNotes()
     * @uses BizAction_Foundation_BulkOperation_Request::setPreviewData()
     * @uses BizAction_Foundation_BulkOperation_Request::setRelatedId()
     * @uses BizAction_Foundation_BulkOperation_Request::setScreenSubTitleCaptionId()
     * @uses BizAction_Foundation_BulkOperation_Request::setScreenTitleCaptionId()
     * @uses BizAction_Foundation_BulkOperation_Request::setStep()
     * @uses BizAction_Foundation_BulkOperation_Request::setUIViewName()
     * @uses BizAction_Foundation_BulkOperation_Request::setUploadedDataId()
     * @param string $bulkOperation
     * @param bool $configurationStepCompleted
     * @param string $configurationStepDirection
     * @param int $configurationStepIndex
     * @param string $configurationStepName
     * @param string $dateTimeFormat
     * @param string $delimiter
     * @param string $fileData
     * @param string $fileFormat
     * @param bool $fileHasHeaders
     * @param string $fileName
     * @param string $notes
     * @param string $previewData
     * @param string $relatedId
     * @param string $screenSubTitleCaptionId
     * @param string $screenTitleCaptionId
     * @param string $step
     * @param string $uIViewName
     * @param string $uploadedDataId
     */
    public function __construct($bulkOperation = null, $configurationStepCompleted = null, $configurationStepDirection = null, $configurationStepIndex = null, $configurationStepName = null, $dateTimeFormat = null, $delimiter = null, $fileData = null, $fileFormat = null, $fileHasHeaders = null, $fileName = null, $notes = null, $previewData = null, $relatedId = null, $screenSubTitleCaptionId = null, $screenTitleCaptionId = null, $step = null, $uIViewName = null, $uploadedDataId = null)
    {
        $this
            ->setBulkOperation($bulkOperation)
            ->setConfigurationStepCompleted($configurationStepCompleted)
            ->setConfigurationStepDirection($configurationStepDirection)
            ->setConfigurationStepIndex($configurationStepIndex)
            ->setConfigurationStepName($configurationStepName)
            ->setDateTimeFormat($dateTimeFormat)
            ->setDelimiter($delimiter)
            ->setFileData($fileData)
            ->setFileFormat($fileFormat)
            ->setFileHasHeaders($fileHasHeaders)
            ->setFileName($fileName)
            ->setNotes($notes)
            ->setPreviewData($previewData)
            ->setRelatedId($relatedId)
            ->setScreenSubTitleCaptionId($screenSubTitleCaptionId)
            ->setScreenTitleCaptionId($screenTitleCaptionId)
            ->setStep($step)
            ->setUIViewName($uIViewName)
            ->setUploadedDataId($uploadedDataId);
    }
    /**
     * Get BulkOperation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBulkOperation()
    {
        return isset($this->BulkOperation) ? $this->BulkOperation : null;
    }
    /**
     * Set BulkOperation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bulkOperation
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setBulkOperation($bulkOperation = null)
    {
        // validation for constraint: string
        if (!is_null($bulkOperation) && !is_string($bulkOperation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bulkOperation, true), gettype($bulkOperation)), __LINE__);
        }
        if (is_null($bulkOperation) || (is_array($bulkOperation) && empty($bulkOperation))) {
            unset($this->BulkOperation);
        } else {
            $this->BulkOperation = $bulkOperation;
        }
        return $this;
    }
    /**
     * Get ConfigurationStepCompleted value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getConfigurationStepCompleted()
    {
        return isset($this->ConfigurationStepCompleted) ? $this->ConfigurationStepCompleted : null;
    }
    /**
     * Set ConfigurationStepCompleted value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $configurationStepCompleted
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setConfigurationStepCompleted($configurationStepCompleted = null)
    {
        // validation for constraint: boolean
        if (!is_null($configurationStepCompleted) && !is_bool($configurationStepCompleted)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($configurationStepCompleted, true), gettype($configurationStepCompleted)), __LINE__);
        }
        if (is_null($configurationStepCompleted) || (is_array($configurationStepCompleted) && empty($configurationStepCompleted))) {
            unset($this->ConfigurationStepCompleted);
        } else {
            $this->ConfigurationStepCompleted = $configurationStepCompleted;
        }
        return $this;
    }
    /**
     * Get ConfigurationStepDirection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfigurationStepDirection()
    {
        return isset($this->ConfigurationStepDirection) ? $this->ConfigurationStepDirection : null;
    }
    /**
     * Set ConfigurationStepDirection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BulkOperationConfigurationStepDirection::valueIsValid()
     * @uses \patest\EnumType\BulkOperationConfigurationStepDirection::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $configurationStepDirection
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setConfigurationStepDirection($configurationStepDirection = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BulkOperationConfigurationStepDirection::valueIsValid($configurationStepDirection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BulkOperationConfigurationStepDirection', is_array($configurationStepDirection) ? implode(', ', $configurationStepDirection) : var_export($configurationStepDirection, true), implode(', ', \patest\EnumType\BulkOperationConfigurationStepDirection::getValidValues())), __LINE__);
        }
        if (is_null($configurationStepDirection) || (is_array($configurationStepDirection) && empty($configurationStepDirection))) {
            unset($this->ConfigurationStepDirection);
        } else {
            $this->ConfigurationStepDirection = $configurationStepDirection;
        }
        return $this;
    }
    /**
     * Get ConfigurationStepIndex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getConfigurationStepIndex()
    {
        return isset($this->ConfigurationStepIndex) ? $this->ConfigurationStepIndex : null;
    }
    /**
     * Set ConfigurationStepIndex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $configurationStepIndex
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setConfigurationStepIndex($configurationStepIndex = null)
    {
        // validation for constraint: int
        if (!is_null($configurationStepIndex) && !(is_int($configurationStepIndex) || ctype_digit($configurationStepIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($configurationStepIndex, true), gettype($configurationStepIndex)), __LINE__);
        }
        if (is_null($configurationStepIndex) || (is_array($configurationStepIndex) && empty($configurationStepIndex))) {
            unset($this->ConfigurationStepIndex);
        } else {
            $this->ConfigurationStepIndex = $configurationStepIndex;
        }
        return $this;
    }
    /**
     * Get ConfigurationStepName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfigurationStepName()
    {
        return isset($this->ConfigurationStepName) ? $this->ConfigurationStepName : null;
    }
    /**
     * Set ConfigurationStepName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $configurationStepName
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setConfigurationStepName($configurationStepName = null)
    {
        // validation for constraint: string
        if (!is_null($configurationStepName) && !is_string($configurationStepName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configurationStepName, true), gettype($configurationStepName)), __LINE__);
        }
        if (is_null($configurationStepName) || (is_array($configurationStepName) && empty($configurationStepName))) {
            unset($this->ConfigurationStepName);
        } else {
            $this->ConfigurationStepName = $configurationStepName;
        }
        return $this;
    }
    /**
     * Get DateTimeFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeFormat()
    {
        return isset($this->DateTimeFormat) ? $this->DateTimeFormat : null;
    }
    /**
     * Set DateTimeFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeFormat
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setDateTimeFormat($dateTimeFormat = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeFormat) && !is_string($dateTimeFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeFormat, true), gettype($dateTimeFormat)), __LINE__);
        }
        if (is_null($dateTimeFormat) || (is_array($dateTimeFormat) && empty($dateTimeFormat))) {
            unset($this->DateTimeFormat);
        } else {
            $this->DateTimeFormat = $dateTimeFormat;
        }
        return $this;
    }
    /**
     * Get Delimiter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDelimiter()
    {
        return isset($this->Delimiter) ? $this->Delimiter : null;
    }
    /**
     * Set Delimiter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $delimiter
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setDelimiter($delimiter = null)
    {
        // validation for constraint: string
        if (!is_null($delimiter) && !is_string($delimiter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delimiter, true), gettype($delimiter)), __LINE__);
        }
        if (is_null($delimiter) || (is_array($delimiter) && empty($delimiter))) {
            unset($this->Delimiter);
        } else {
            $this->Delimiter = $delimiter;
        }
        return $this;
    }
    /**
     * Get FileData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileData()
    {
        return isset($this->FileData) ? $this->FileData : null;
    }
    /**
     * Set FileData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileData
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setFileData($fileData = null)
    {
        // validation for constraint: string
        if (!is_null($fileData) && !is_string($fileData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileData, true), gettype($fileData)), __LINE__);
        }
        if (is_null($fileData) || (is_array($fileData) && empty($fileData))) {
            unset($this->FileData);
        } else {
            $this->FileData = $fileData;
        }
        return $this;
    }
    /**
     * Get FileFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileFormat()
    {
        return isset($this->FileFormat) ? $this->FileFormat : null;
    }
    /**
     * Set FileFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileFormat
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setFileFormat($fileFormat = null)
    {
        // validation for constraint: string
        if (!is_null($fileFormat) && !is_string($fileFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileFormat, true), gettype($fileFormat)), __LINE__);
        }
        if (is_null($fileFormat) || (is_array($fileFormat) && empty($fileFormat))) {
            unset($this->FileFormat);
        } else {
            $this->FileFormat = $fileFormat;
        }
        return $this;
    }
    /**
     * Get FileHasHeaders value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFileHasHeaders()
    {
        return isset($this->FileHasHeaders) ? $this->FileHasHeaders : null;
    }
    /**
     * Set FileHasHeaders value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $fileHasHeaders
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setFileHasHeaders($fileHasHeaders = null)
    {
        // validation for constraint: boolean
        if (!is_null($fileHasHeaders) && !is_bool($fileHasHeaders)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($fileHasHeaders, true), gettype($fileHasHeaders)), __LINE__);
        }
        if (is_null($fileHasHeaders) || (is_array($fileHasHeaders) && empty($fileHasHeaders))) {
            unset($this->FileHasHeaders);
        } else {
            $this->FileHasHeaders = $fileHasHeaders;
        }
        return $this;
    }
    /**
     * Get FileName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileName()
    {
        return isset($this->FileName) ? $this->FileName : null;
    }
    /**
     * Set FileName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileName
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setFileName($fileName = null)
    {
        // validation for constraint: string
        if (!is_null($fileName) && !is_string($fileName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileName, true), gettype($fileName)), __LINE__);
        }
        if (is_null($fileName) || (is_array($fileName) && empty($fileName))) {
            unset($this->FileName);
        } else {
            $this->FileName = $fileName;
        }
        return $this;
    }
    /**
     * Get Notes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotes()
    {
        return isset($this->Notes) ? $this->Notes : null;
    }
    /**
     * Set Notes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notes
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($notes, true), gettype($notes)), __LINE__);
        }
        if (is_null($notes) || (is_array($notes) && empty($notes))) {
            unset($this->Notes);
        } else {
            $this->Notes = $notes;
        }
        return $this;
    }
    /**
     * Get PreviewData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPreviewData()
    {
        return isset($this->PreviewData) ? $this->PreviewData : null;
    }
    /**
     * Set PreviewData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $previewData
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setPreviewData($previewData = null)
    {
        // validation for constraint: string
        if (!is_null($previewData) && !is_string($previewData)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($previewData, true), gettype($previewData)), __LINE__);
        }
        if (is_null($previewData) || (is_array($previewData) && empty($previewData))) {
            unset($this->PreviewData);
        } else {
            $this->PreviewData = $previewData;
        }
        return $this;
    }
    /**
     * Get RelatedId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedId()
    {
        return isset($this->RelatedId) ? $this->RelatedId : null;
    }
    /**
     * Set RelatedId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedId
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setRelatedId($relatedId = null)
    {
        // validation for constraint: string
        if (!is_null($relatedId) && !is_string($relatedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedId, true), gettype($relatedId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($relatedId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $relatedId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($relatedId, true)), __LINE__);
        }
        if (is_null($relatedId) || (is_array($relatedId) && empty($relatedId))) {
            unset($this->RelatedId);
        } else {
            $this->RelatedId = $relatedId;
        }
        return $this;
    }
    /**
     * Get ScreenSubTitleCaptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScreenSubTitleCaptionId()
    {
        return isset($this->ScreenSubTitleCaptionId) ? $this->ScreenSubTitleCaptionId : null;
    }
    /**
     * Set ScreenSubTitleCaptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $screenSubTitleCaptionId
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setScreenSubTitleCaptionId($screenSubTitleCaptionId = null)
    {
        // validation for constraint: string
        if (!is_null($screenSubTitleCaptionId) && !is_string($screenSubTitleCaptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($screenSubTitleCaptionId, true), gettype($screenSubTitleCaptionId)), __LINE__);
        }
        if (is_null($screenSubTitleCaptionId) || (is_array($screenSubTitleCaptionId) && empty($screenSubTitleCaptionId))) {
            unset($this->ScreenSubTitleCaptionId);
        } else {
            $this->ScreenSubTitleCaptionId = $screenSubTitleCaptionId;
        }
        return $this;
    }
    /**
     * Get ScreenTitleCaptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScreenTitleCaptionId()
    {
        return isset($this->ScreenTitleCaptionId) ? $this->ScreenTitleCaptionId : null;
    }
    /**
     * Set ScreenTitleCaptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $screenTitleCaptionId
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setScreenTitleCaptionId($screenTitleCaptionId = null)
    {
        // validation for constraint: string
        if (!is_null($screenTitleCaptionId) && !is_string($screenTitleCaptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($screenTitleCaptionId, true), gettype($screenTitleCaptionId)), __LINE__);
        }
        if (is_null($screenTitleCaptionId) || (is_array($screenTitleCaptionId) && empty($screenTitleCaptionId))) {
            unset($this->ScreenTitleCaptionId);
        } else {
            $this->ScreenTitleCaptionId = $screenTitleCaptionId;
        }
        return $this;
    }
    /**
     * Get Step value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStep()
    {
        return isset($this->Step) ? $this->Step : null;
    }
    /**
     * Set Step value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BulkOperationStep::valueIsValid()
     * @uses \patest\EnumType\BulkOperationStep::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $step
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setStep($step = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BulkOperationStep::valueIsValid($step)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BulkOperationStep', is_array($step) ? implode(', ', $step) : var_export($step, true), implode(', ', \patest\EnumType\BulkOperationStep::getValidValues())), __LINE__);
        }
        if (is_null($step) || (is_array($step) && empty($step))) {
            unset($this->Step);
        } else {
            $this->Step = $step;
        }
        return $this;
    }
    /**
     * Get UIViewName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUIViewName()
    {
        return isset($this->UIViewName) ? $this->UIViewName : null;
    }
    /**
     * Set UIViewName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uIViewName
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setUIViewName($uIViewName = null)
    {
        // validation for constraint: string
        if (!is_null($uIViewName) && !is_string($uIViewName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uIViewName, true), gettype($uIViewName)), __LINE__);
        }
        if (is_null($uIViewName) || (is_array($uIViewName) && empty($uIViewName))) {
            unset($this->UIViewName);
        } else {
            $this->UIViewName = $uIViewName;
        }
        return $this;
    }
    /**
     * Get UploadedDataId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUploadedDataId()
    {
        return isset($this->UploadedDataId) ? $this->UploadedDataId : null;
    }
    /**
     * Set UploadedDataId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $uploadedDataId
     * @return \patest\StructType\BizAction_Foundation_BulkOperation_Request
     */
    public function setUploadedDataId($uploadedDataId = null)
    {
        // validation for constraint: string
        if (!is_null($uploadedDataId) && !is_string($uploadedDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uploadedDataId, true), gettype($uploadedDataId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($uploadedDataId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $uploadedDataId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($uploadedDataId, true)), __LINE__);
        }
        if (is_null($uploadedDataId) || (is_array($uploadedDataId) && empty($uploadedDataId))) {
            unset($this->UploadedDataId);
        } else {
            $this->UploadedDataId = $uploadedDataId;
        }
        return $this;
    }
}
