<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizAction.Facade.BatchEntry.UploadDataFileIntoSession.Request StructType
 * @subpackage Structs
 */
class BizAction_Facade_BatchEntry_UploadDataFileIntoSession_Request extends BizAction_Foundation_UploadFileIntoSessionLargeBinaryData_Request
{
    /**
     * The Comment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Comment;
    /**
     * The DateTimeFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateTimeFormat;
    /**
     * The Delimeter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Delimeter;
    /**
     * The Product
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Product;
    /**
     * Constructor method for
     * BizAction.Facade.BatchEntry.UploadDataFileIntoSession.Request
     * @uses BizAction_Facade_BatchEntry_UploadDataFileIntoSession_Request::setComment()
     * @uses BizAction_Facade_BatchEntry_UploadDataFileIntoSession_Request::setDateTimeFormat()
     * @uses BizAction_Facade_BatchEntry_UploadDataFileIntoSession_Request::setDelimeter()
     * @uses BizAction_Facade_BatchEntry_UploadDataFileIntoSession_Request::setProduct()
     * @param \patest\StructType\GlobalString $comment
     * @param string $dateTimeFormat
     * @param string $delimeter
     * @param string $product
     */
    public function __construct(\patest\StructType\GlobalString $comment = null, $dateTimeFormat = null, $delimeter = null, $product = null)
    {
        $this
            ->setComment($comment)
            ->setDateTimeFormat($dateTimeFormat)
            ->setDelimeter($delimeter)
            ->setProduct($product);
    }
    /**
     * Get Comment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getComment()
    {
        return isset($this->Comment) ? $this->Comment : null;
    }
    /**
     * Set Comment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $comment
     * @return \patest\StructType\BizAction_Facade_BatchEntry_UploadDataFileIntoSession_Request
     */
    public function setComment(\patest\StructType\GlobalString $comment = null)
    {
        if (is_null($comment) || (is_array($comment) && empty($comment))) {
            unset($this->Comment);
        } else {
            $this->Comment = $comment;
        }
        return $this;
    }
    /**
     * Get DateTimeFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateTimeFormat()
    {
        return isset($this->DateTimeFormat) ? $this->DateTimeFormat : null;
    }
    /**
     * Set DateTimeFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dateTimeFormat
     * @return \patest\StructType\BizAction_Facade_BatchEntry_UploadDataFileIntoSession_Request
     */
    public function setDateTimeFormat($dateTimeFormat = null)
    {
        // validation for constraint: string
        if (!is_null($dateTimeFormat) && !is_string($dateTimeFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($dateTimeFormat, true), gettype($dateTimeFormat)), __LINE__);
        }
        if (is_null($dateTimeFormat) || (is_array($dateTimeFormat) && empty($dateTimeFormat))) {
            unset($this->DateTimeFormat);
        } else {
            $this->DateTimeFormat = $dateTimeFormat;
        }
        return $this;
    }
    /**
     * Get Delimeter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDelimeter()
    {
        return isset($this->Delimeter) ? $this->Delimeter : null;
    }
    /**
     * Set Delimeter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $delimeter
     * @return \patest\StructType\BizAction_Facade_BatchEntry_UploadDataFileIntoSession_Request
     */
    public function setDelimeter($delimeter = null)
    {
        // validation for constraint: string
        if (!is_null($delimeter) && !is_string($delimeter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($delimeter, true), gettype($delimeter)), __LINE__);
        }
        if (is_null($delimeter) || (is_array($delimeter) && empty($delimeter))) {
            unset($this->Delimeter);
        } else {
            $this->Delimeter = $delimeter;
        }
        return $this;
    }
    /**
     * Get Product value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProduct()
    {
        return isset($this->Product) ? $this->Product : null;
    }
    /**
     * Set Product value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BatchEntrySupportedProductKind::valueIsValid()
     * @uses \patest\EnumType\BatchEntrySupportedProductKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $product
     * @return \patest\StructType\BizAction_Facade_BatchEntry_UploadDataFileIntoSession_Request
     */
    public function setProduct($product = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchEntrySupportedProductKind::valueIsValid($product)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchEntrySupportedProductKind', is_array($product) ? implode(', ', $product) : var_export($product, true), implode(', ', \patest\EnumType\BatchEntrySupportedProductKind::getValidValues())), __LINE__);
        }
        if (is_null($product) || (is_array($product) && empty($product))) {
            unset($this->Product);
        } else {
            $this->Product = $product;
        }
        return $this;
    }
}
