<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Donation.PrintPledge.Request StructType
 * @subpackage Structs
 */
class BizAction_Donation_PrintPledge_Request extends AnyEntity
{
    /**
     * The ContactEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContactEmail;
    /**
     * The DocumentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DocumentId;
    /**
     * The OtherEmails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OtherEmails;
    /**
     * The PledgeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PledgeId;
    /**
     * The SendByEmail
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendByEmail;
    /**
     * The SendToPrinter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SendToPrinter;
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * Constructor method for BizAction.Donation.PrintPledge.Request
     * @uses BizAction_Donation_PrintPledge_Request::setContactEmail()
     * @uses BizAction_Donation_PrintPledge_Request::setDocumentId()
     * @uses BizAction_Donation_PrintPledge_Request::setOtherEmails()
     * @uses BizAction_Donation_PrintPledge_Request::setPledgeId()
     * @uses BizAction_Donation_PrintPledge_Request::setSendByEmail()
     * @uses BizAction_Donation_PrintPledge_Request::setSendToPrinter()
     * @uses BizAction_Donation_PrintPledge_Request::setTargetPrinterId()
     * @param string $contactEmail
     * @param string $documentId
     * @param string $otherEmails
     * @param string $pledgeId
     * @param bool $sendByEmail
     * @param bool $sendToPrinter
     * @param string $targetPrinterId
     */
    public function __construct($contactEmail = null, $documentId = null, $otherEmails = null, $pledgeId = null, $sendByEmail = null, $sendToPrinter = null, $targetPrinterId = null)
    {
        $this
            ->setContactEmail($contactEmail)
            ->setDocumentId($documentId)
            ->setOtherEmails($otherEmails)
            ->setPledgeId($pledgeId)
            ->setSendByEmail($sendByEmail)
            ->setSendToPrinter($sendToPrinter)
            ->setTargetPrinterId($targetPrinterId);
    }
    /**
     * Get ContactEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContactEmail()
    {
        return isset($this->ContactEmail) ? $this->ContactEmail : null;
    }
    /**
     * Set ContactEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contactEmail
     * @return \patest\StructType\BizAction_Donation_PrintPledge_Request
     */
    public function setContactEmail($contactEmail = null)
    {
        // validation for constraint: string
        if (!is_null($contactEmail) && !is_string($contactEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactEmail, true), gettype($contactEmail)), __LINE__);
        }
        if (is_null($contactEmail) || (is_array($contactEmail) && empty($contactEmail))) {
            unset($this->ContactEmail);
        } else {
            $this->ContactEmail = $contactEmail;
        }
        return $this;
    }
    /**
     * Get DocumentId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentId()
    {
        return isset($this->DocumentId) ? $this->DocumentId : null;
    }
    /**
     * Set DocumentId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentId
     * @return \patest\StructType\BizAction_Donation_PrintPledge_Request
     */
    public function setDocumentId($documentId = null)
    {
        // validation for constraint: string
        if (!is_null($documentId) && !is_string($documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($documentId, true), gettype($documentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($documentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $documentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($documentId, true)), __LINE__);
        }
        if (is_null($documentId) || (is_array($documentId) && empty($documentId))) {
            unset($this->DocumentId);
        } else {
            $this->DocumentId = $documentId;
        }
        return $this;
    }
    /**
     * Get OtherEmails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOtherEmails()
    {
        return isset($this->OtherEmails) ? $this->OtherEmails : null;
    }
    /**
     * Set OtherEmails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $otherEmails
     * @return \patest\StructType\BizAction_Donation_PrintPledge_Request
     */
    public function setOtherEmails($otherEmails = null)
    {
        // validation for constraint: string
        if (!is_null($otherEmails) && !is_string($otherEmails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($otherEmails, true), gettype($otherEmails)), __LINE__);
        }
        if (is_null($otherEmails) || (is_array($otherEmails) && empty($otherEmails))) {
            unset($this->OtherEmails);
        } else {
            $this->OtherEmails = $otherEmails;
        }
        return $this;
    }
    /**
     * Get PledgeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPledgeId()
    {
        return isset($this->PledgeId) ? $this->PledgeId : null;
    }
    /**
     * Set PledgeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pledgeId
     * @return \patest\StructType\BizAction_Donation_PrintPledge_Request
     */
    public function setPledgeId($pledgeId = null)
    {
        // validation for constraint: string
        if (!is_null($pledgeId) && !is_string($pledgeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pledgeId, true), gettype($pledgeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($pledgeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $pledgeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($pledgeId, true)), __LINE__);
        }
        if (is_null($pledgeId) || (is_array($pledgeId) && empty($pledgeId))) {
            unset($this->PledgeId);
        } else {
            $this->PledgeId = $pledgeId;
        }
        return $this;
    }
    /**
     * Get SendByEmail value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendByEmail()
    {
        return isset($this->SendByEmail) ? $this->SendByEmail : null;
    }
    /**
     * Set SendByEmail value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendByEmail
     * @return \patest\StructType\BizAction_Donation_PrintPledge_Request
     */
    public function setSendByEmail($sendByEmail = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendByEmail) && !is_bool($sendByEmail)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendByEmail, true), gettype($sendByEmail)), __LINE__);
        }
        if (is_null($sendByEmail) || (is_array($sendByEmail) && empty($sendByEmail))) {
            unset($this->SendByEmail);
        } else {
            $this->SendByEmail = $sendByEmail;
        }
        return $this;
    }
    /**
     * Get SendToPrinter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSendToPrinter()
    {
        return isset($this->SendToPrinter) ? $this->SendToPrinter : null;
    }
    /**
     * Set SendToPrinter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sendToPrinter
     * @return \patest\StructType\BizAction_Donation_PrintPledge_Request
     */
    public function setSendToPrinter($sendToPrinter = null)
    {
        // validation for constraint: boolean
        if (!is_null($sendToPrinter) && !is_bool($sendToPrinter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($sendToPrinter, true), gettype($sendToPrinter)), __LINE__);
        }
        if (is_null($sendToPrinter) || (is_array($sendToPrinter) && empty($sendToPrinter))) {
            unset($this->SendToPrinter);
        } else {
            $this->SendToPrinter = $sendToPrinter;
        }
        return $this;
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\BizAction_Donation_PrintPledge_Request
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
}
