<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.AutoRenewalClientEnrollment StructType
 * @subpackage Structs
 */
class BizAction_Crm_AutoRenewalClientEnrollment extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The EnrolledInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EnrolledInstanceId;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentToken
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentToken;
    /**
     * The PaymentTokenExpiryDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentTokenExpiryDate;
    /**
     * Constructor method for BizAction.Crm.AutoRenewalClientEnrollment
     * @uses BizAction_Crm_AutoRenewalClientEnrollment::setClientId()
     * @uses BizAction_Crm_AutoRenewalClientEnrollment::setEnrolledInstanceId()
     * @uses BizAction_Crm_AutoRenewalClientEnrollment::setPaymentMethodId()
     * @uses BizAction_Crm_AutoRenewalClientEnrollment::setPaymentToken()
     * @uses BizAction_Crm_AutoRenewalClientEnrollment::setPaymentTokenExpiryDate()
     * @param string $clientId
     * @param string $enrolledInstanceId
     * @param string $paymentMethodId
     * @param string $paymentToken
     * @param string $paymentTokenExpiryDate
     */
    public function __construct($clientId = null, $enrolledInstanceId = null, $paymentMethodId = null, $paymentToken = null, $paymentTokenExpiryDate = null)
    {
        $this
            ->setClientId($clientId)
            ->setEnrolledInstanceId($enrolledInstanceId)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentToken($paymentToken)
            ->setPaymentTokenExpiryDate($paymentTokenExpiryDate);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Crm_AutoRenewalClientEnrollment
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get EnrolledInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEnrolledInstanceId()
    {
        return isset($this->EnrolledInstanceId) ? $this->EnrolledInstanceId : null;
    }
    /**
     * Set EnrolledInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $enrolledInstanceId
     * @return \patest\StructType\BizAction_Crm_AutoRenewalClientEnrollment
     */
    public function setEnrolledInstanceId($enrolledInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($enrolledInstanceId) && !is_string($enrolledInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($enrolledInstanceId, true), gettype($enrolledInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($enrolledInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $enrolledInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($enrolledInstanceId, true)), __LINE__);
        }
        if (is_null($enrolledInstanceId) || (is_array($enrolledInstanceId) && empty($enrolledInstanceId))) {
            unset($this->EnrolledInstanceId);
        } else {
            $this->EnrolledInstanceId = $enrolledInstanceId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Crm_AutoRenewalClientEnrollment
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentToken value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentToken()
    {
        return isset($this->PaymentToken) ? $this->PaymentToken : null;
    }
    /**
     * Set PaymentToken value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentToken
     * @return \patest\StructType\BizAction_Crm_AutoRenewalClientEnrollment
     */
    public function setPaymentToken($paymentToken = null)
    {
        // validation for constraint: string
        if (!is_null($paymentToken) && !is_string($paymentToken)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentToken, true), gettype($paymentToken)), __LINE__);
        }
        if (is_null($paymentToken) || (is_array($paymentToken) && empty($paymentToken))) {
            unset($this->PaymentToken);
        } else {
            $this->PaymentToken = $paymentToken;
        }
        return $this;
    }
    /**
     * Get PaymentTokenExpiryDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenExpiryDate()
    {
        return isset($this->PaymentTokenExpiryDate) ? $this->PaymentTokenExpiryDate : null;
    }
    /**
     * Set PaymentTokenExpiryDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenExpiryDate
     * @return \patest\StructType\BizAction_Crm_AutoRenewalClientEnrollment
     */
    public function setPaymentTokenExpiryDate($paymentTokenExpiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenExpiryDate) && !is_string($paymentTokenExpiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenExpiryDate, true), gettype($paymentTokenExpiryDate)), __LINE__);
        }
        if (is_null($paymentTokenExpiryDate) || (is_array($paymentTokenExpiryDate) && empty($paymentTokenExpiryDate))) {
            unset($this->PaymentTokenExpiryDate);
        } else {
            $this->PaymentTokenExpiryDate = $paymentTokenExpiryDate;
        }
        return $this;
    }
}
