<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.AddTicketSchemeEnrollments.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Crm_AddTicketSchemeEnrollments_Request extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DirectDebitMandateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DirectDebitMandateId;
    /**
     * The IsPaymentRequired
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPaymentRequired;
    /**
     * The Media
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Crm_Media
     */
    public $Media;
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PaymentMethodType;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The SubscriptionInstances
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SubscriptionInstances
     */
    public $SubscriptionInstances;
    /**
     * The TicketSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSchemeId;
    /**
     * Constructor method for BizAction.Crm.AddTicketSchemeEnrollments.Request
     * @uses BizAction_Crm_AddTicketSchemeEnrollments_Request::setClientId()
     * @uses BizAction_Crm_AddTicketSchemeEnrollments_Request::setDirectDebitMandateId()
     * @uses BizAction_Crm_AddTicketSchemeEnrollments_Request::setIsPaymentRequired()
     * @uses BizAction_Crm_AddTicketSchemeEnrollments_Request::setMedia()
     * @uses BizAction_Crm_AddTicketSchemeEnrollments_Request::setPaymentMethodId()
     * @uses BizAction_Crm_AddTicketSchemeEnrollments_Request::setPaymentMethodType()
     * @uses BizAction_Crm_AddTicketSchemeEnrollments_Request::setPaymentTokenId()
     * @uses BizAction_Crm_AddTicketSchemeEnrollments_Request::setSubscriptionInstances()
     * @uses BizAction_Crm_AddTicketSchemeEnrollments_Request::setTicketSchemeId()
     * @param string $clientId
     * @param string $directDebitMandateId
     * @param bool $isPaymentRequired
     * @param \patest\StructType\Crm_Media $media
     * @param string $paymentMethodId
     * @param string $paymentMethodType
     * @param string $paymentTokenId
     * @param \patest\StructType\SubscriptionInstances $subscriptionInstances
     * @param string $ticketSchemeId
     */
    public function __construct($clientId = null, $directDebitMandateId = null, $isPaymentRequired = null, \patest\StructType\Crm_Media $media = null, $paymentMethodId = null, $paymentMethodType = null, $paymentTokenId = null, \patest\StructType\SubscriptionInstances $subscriptionInstances = null, $ticketSchemeId = null)
    {
        $this
            ->setClientId($clientId)
            ->setDirectDebitMandateId($directDebitMandateId)
            ->setIsPaymentRequired($isPaymentRequired)
            ->setMedia($media)
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodType($paymentMethodType)
            ->setPaymentTokenId($paymentTokenId)
            ->setSubscriptionInstances($subscriptionInstances)
            ->setTicketSchemeId($ticketSchemeId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\BizAction_Crm_AddTicketSchemeEnrollments_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DirectDebitMandateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDirectDebitMandateId()
    {
        return isset($this->DirectDebitMandateId) ? $this->DirectDebitMandateId : null;
    }
    /**
     * Set DirectDebitMandateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $directDebitMandateId
     * @return \patest\StructType\BizAction_Crm_AddTicketSchemeEnrollments_Request
     */
    public function setDirectDebitMandateId($directDebitMandateId = null)
    {
        // validation for constraint: string
        if (!is_null($directDebitMandateId) && !is_string($directDebitMandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($directDebitMandateId, true), gettype($directDebitMandateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($directDebitMandateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $directDebitMandateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($directDebitMandateId, true)), __LINE__);
        }
        if (is_null($directDebitMandateId) || (is_array($directDebitMandateId) && empty($directDebitMandateId))) {
            unset($this->DirectDebitMandateId);
        } else {
            $this->DirectDebitMandateId = $directDebitMandateId;
        }
        return $this;
    }
    /**
     * Get IsPaymentRequired value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPaymentRequired()
    {
        return isset($this->IsPaymentRequired) ? $this->IsPaymentRequired : null;
    }
    /**
     * Set IsPaymentRequired value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPaymentRequired
     * @return \patest\StructType\BizAction_Crm_AddTicketSchemeEnrollments_Request
     */
    public function setIsPaymentRequired($isPaymentRequired = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPaymentRequired) && !is_bool($isPaymentRequired)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPaymentRequired, true), gettype($isPaymentRequired)), __LINE__);
        }
        if (is_null($isPaymentRequired) || (is_array($isPaymentRequired) && empty($isPaymentRequired))) {
            unset($this->IsPaymentRequired);
        } else {
            $this->IsPaymentRequired = $isPaymentRequired;
        }
        return $this;
    }
    /**
     * Get Media value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Crm_Media|null
     */
    public function getMedia()
    {
        return isset($this->Media) ? $this->Media : null;
    }
    /**
     * Set Media value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Crm_Media $media
     * @return \patest\StructType\BizAction_Crm_AddTicketSchemeEnrollments_Request
     */
    public function setMedia(\patest\StructType\Crm_Media $media = null)
    {
        if (is_null($media) || (is_array($media) && empty($media))) {
            unset($this->Media);
        } else {
            $this->Media = $media;
        }
        return $this;
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\BizAction_Crm_AddTicketSchemeEnrollments_Request
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodType()
    {
        return isset($this->PaymentMethodType) ? $this->PaymentMethodType : null;
    }
    /**
     * Set PaymentMethodType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\PaymentMethodType::valueIsValid()
     * @uses \patest\EnumType\PaymentMethodType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $paymentMethodType
     * @return \patest\StructType\BizAction_Crm_AddTicketSchemeEnrollments_Request
     */
    public function setPaymentMethodType($paymentMethodType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\PaymentMethodType::valueIsValid($paymentMethodType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\PaymentMethodType', is_array($paymentMethodType) ? implode(', ', $paymentMethodType) : var_export($paymentMethodType, true), implode(', ', \patest\EnumType\PaymentMethodType::getValidValues())), __LINE__);
        }
        if (is_null($paymentMethodType) || (is_array($paymentMethodType) && empty($paymentMethodType))) {
            unset($this->PaymentMethodType);
        } else {
            $this->PaymentMethodType = $paymentMethodType;
        }
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return isset($this->PaymentTokenId) ? $this->PaymentTokenId : null;
    }
    /**
     * Set PaymentTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentTokenId
     * @return \patest\StructType\BizAction_Crm_AddTicketSchemeEnrollments_Request
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        if (is_null($paymentTokenId) || (is_array($paymentTokenId) && empty($paymentTokenId))) {
            unset($this->PaymentTokenId);
        } else {
            $this->PaymentTokenId = $paymentTokenId;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstances value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SubscriptionInstances|null
     */
    public function getSubscriptionInstances()
    {
        return isset($this->SubscriptionInstances) ? $this->SubscriptionInstances : null;
    }
    /**
     * Set SubscriptionInstances value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SubscriptionInstances $subscriptionInstances
     * @return \patest\StructType\BizAction_Crm_AddTicketSchemeEnrollments_Request
     */
    public function setSubscriptionInstances(\patest\StructType\SubscriptionInstances $subscriptionInstances = null)
    {
        if (is_null($subscriptionInstances) || (is_array($subscriptionInstances) && empty($subscriptionInstances))) {
            unset($this->SubscriptionInstances);
        } else {
            $this->SubscriptionInstances = $subscriptionInstances;
        }
        return $this;
    }
    /**
     * Get TicketSchemeId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketSchemeId()
    {
        return isset($this->TicketSchemeId) ? $this->TicketSchemeId : null;
    }
    /**
     * Set TicketSchemeId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketSchemeId
     * @return \patest\StructType\BizAction_Crm_AddTicketSchemeEnrollments_Request
     */
    public function setTicketSchemeId($ticketSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeId) && !is_string($ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeId, true), gettype($ticketSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSchemeId, true)), __LINE__);
        }
        if (is_null($ticketSchemeId) || (is_array($ticketSchemeId) && empty($ticketSchemeId))) {
            unset($this->TicketSchemeId);
        } else {
            $this->TicketSchemeId = $ticketSchemeId;
        }
        return $this;
    }
}
