<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizAction.Crm.Account.UpdatePrimaryContactPerson.Request
 * StructType
 * @subpackage Structs
 */
class BizAction_Crm_Account_UpdatePrimaryContactPerson_Request extends AnyEntity
{
    /**
     * The AccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccountId;
    /**
     * The PrimaryContactPersonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrimaryContactPersonId;
    /**
     * Constructor method for BizAction.Crm.Account.UpdatePrimaryContactPerson.Request
     * @uses BizAction_Crm_Account_UpdatePrimaryContactPerson_Request::setAccountId()
     * @uses BizAction_Crm_Account_UpdatePrimaryContactPerson_Request::setPrimaryContactPersonId()
     * @param string $accountId
     * @param string $primaryContactPersonId
     */
    public function __construct($accountId = null, $primaryContactPersonId = null)
    {
        $this
            ->setAccountId($accountId)
            ->setPrimaryContactPersonId($primaryContactPersonId);
    }
    /**
     * Get AccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccountId()
    {
        return isset($this->AccountId) ? $this->AccountId : null;
    }
    /**
     * Set AccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accountId
     * @return \patest\StructType\BizAction_Crm_Account_UpdatePrimaryContactPerson_Request
     */
    public function setAccountId($accountId = null)
    {
        // validation for constraint: string
        if (!is_null($accountId) && !is_string($accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountId, true), gettype($accountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accountId, true)), __LINE__);
        }
        if (is_null($accountId) || (is_array($accountId) && empty($accountId))) {
            unset($this->AccountId);
        } else {
            $this->AccountId = $accountId;
        }
        return $this;
    }
    /**
     * Get PrimaryContactPersonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrimaryContactPersonId()
    {
        return isset($this->PrimaryContactPersonId) ? $this->PrimaryContactPersonId : null;
    }
    /**
     * Set PrimaryContactPersonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $primaryContactPersonId
     * @return \patest\StructType\BizAction_Crm_Account_UpdatePrimaryContactPerson_Request
     */
    public function setPrimaryContactPersonId($primaryContactPersonId = null)
    {
        // validation for constraint: string
        if (!is_null($primaryContactPersonId) && !is_string($primaryContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($primaryContactPersonId, true), gettype($primaryContactPersonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($primaryContactPersonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $primaryContactPersonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($primaryContactPersonId, true)), __LINE__);
        }
        if (is_null($primaryContactPersonId) || (is_array($primaryContactPersonId) && empty($primaryContactPersonId))) {
            unset($this->PrimaryContactPersonId);
        } else {
            $this->PrimaryContactPersonId = $primaryContactPersonId;
        }
        return $this;
    }
}
