<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BizActionLogics.AccessControl.ReprintAccessCardRequest
 * StructType
 * @subpackage Structs
 */
class BizActionLogics_AccessControl_ReprintAccessCardRequest extends BizActionLogics_AccessControl_PrintAccessCardRequest
{
    /**
     * The CardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CardId;
    /**
     * The CardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumber;
    /**
     * Constructor method for BizActionLogics.AccessControl.ReprintAccessCardRequest
     * @uses BizActionLogics_AccessControl_ReprintAccessCardRequest::setCardId()
     * @uses BizActionLogics_AccessControl_ReprintAccessCardRequest::setCardNumber()
     * @param string $cardId
     * @param string $cardNumber
     */
    public function __construct($cardId = null, $cardNumber = null)
    {
        $this
            ->setCardId($cardId)
            ->setCardNumber($cardNumber);
    }
    /**
     * Get CardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardId()
    {
        return isset($this->CardId) ? $this->CardId : null;
    }
    /**
     * Set CardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardId
     * @return \patest\StructType\BizActionLogics_AccessControl_ReprintAccessCardRequest
     */
    public function setCardId($cardId = null)
    {
        // validation for constraint: string
        if (!is_null($cardId) && !is_string($cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardId, true), gettype($cardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($cardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $cardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($cardId, true)), __LINE__);
        }
        if (is_null($cardId) || (is_array($cardId) && empty($cardId))) {
            unset($this->CardId);
        } else {
            $this->CardId = $cardId;
        }
        return $this;
    }
    /**
     * Get CardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumber()
    {
        return isset($this->CardNumber) ? $this->CardNumber : null;
    }
    /**
     * Set CardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumber
     * @return \patest\StructType\BizActionLogics_AccessControl_ReprintAccessCardRequest
     */
    public function setCardNumber($cardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumber) && !is_string($cardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumber, true), gettype($cardNumber)), __LINE__);
        }
        if (is_null($cardNumber) || (is_array($cardNumber) && empty($cardNumber))) {
            unset($this->CardNumber);
        } else {
            $this->CardNumber = $cardNumber;
        }
        return $this;
    }
}
