<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * BizActionLogics.AccessControl.ReactivateSubscriptionBarcode.Request StructType
 * @subpackage Structs
 */
class BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request extends AnyEntity
{
    /**
     * The AccessControlSystemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlSystemId;
    /**
     * The ExecuteAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExecuteAction;
    /**
     * The FirstLoad
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FirstLoad;
    /**
     * The Ids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Ids;
    /**
     * The InputBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InputBarcode;
    /**
     * The ItemCounter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemCounter;
    /**
     * The ItemDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemDescription;
    /**
     * The ItemErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemErrorMessage;
    /**
     * The NextItemIndex
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NextItemIndex;
    /**
     * The ReactivateManner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReactivateManner;
    /**
     * The ReferencedEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ReferencedEntityId;
    /**
     * The SkipItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SkipItem;
    /**
     * The TotalItemsNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TotalItemsNumber;
    /**
     * The ValidItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ValidItem;
    /**
     * Constructor method for
     * BizActionLogics.AccessControl.ReactivateSubscriptionBarcode.Request
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setAccessControlSystemId()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setExecuteAction()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setFirstLoad()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setIds()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setInputBarcode()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setItemCounter()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setItemDescription()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setItemErrorMessage()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setNextItemIndex()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setReactivateManner()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setReferencedEntityId()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setSkipItem()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setTotalItemsNumber()
     * @uses BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request::setValidItem()
     * @param string $accessControlSystemId
     * @param bool $executeAction
     * @param bool $firstLoad
     * @param string $ids
     * @param string $inputBarcode
     * @param string $itemCounter
     * @param string $itemDescription
     * @param string $itemErrorMessage
     * @param int $nextItemIndex
     * @param string $reactivateManner
     * @param string $referencedEntityId
     * @param bool $skipItem
     * @param int $totalItemsNumber
     * @param bool $validItem
     */
    public function __construct($accessControlSystemId = null, $executeAction = null, $firstLoad = null, $ids = null, $inputBarcode = null, $itemCounter = null, $itemDescription = null, $itemErrorMessage = null, $nextItemIndex = null, $reactivateManner = null, $referencedEntityId = null, $skipItem = null, $totalItemsNumber = null, $validItem = null)
    {
        $this
            ->setAccessControlSystemId($accessControlSystemId)
            ->setExecuteAction($executeAction)
            ->setFirstLoad($firstLoad)
            ->setIds($ids)
            ->setInputBarcode($inputBarcode)
            ->setItemCounter($itemCounter)
            ->setItemDescription($itemDescription)
            ->setItemErrorMessage($itemErrorMessage)
            ->setNextItemIndex($nextItemIndex)
            ->setReactivateManner($reactivateManner)
            ->setReferencedEntityId($referencedEntityId)
            ->setSkipItem($skipItem)
            ->setTotalItemsNumber($totalItemsNumber)
            ->setValidItem($validItem);
    }
    /**
     * Get AccessControlSystemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessControlSystemId()
    {
        return isset($this->AccessControlSystemId) ? $this->AccessControlSystemId : null;
    }
    /**
     * Set AccessControlSystemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessControlSystemId
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setAccessControlSystemId($accessControlSystemId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlSystemId) && !is_string($accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlSystemId, true), gettype($accessControlSystemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlSystemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlSystemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlSystemId, true)), __LINE__);
        }
        if (is_null($accessControlSystemId) || (is_array($accessControlSystemId) && empty($accessControlSystemId))) {
            unset($this->AccessControlSystemId);
        } else {
            $this->AccessControlSystemId = $accessControlSystemId;
        }
        return $this;
    }
    /**
     * Get ExecuteAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExecuteAction()
    {
        return isset($this->ExecuteAction) ? $this->ExecuteAction : null;
    }
    /**
     * Set ExecuteAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $executeAction
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setExecuteAction($executeAction = null)
    {
        // validation for constraint: boolean
        if (!is_null($executeAction) && !is_bool($executeAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($executeAction, true), gettype($executeAction)), __LINE__);
        }
        if (is_null($executeAction) || (is_array($executeAction) && empty($executeAction))) {
            unset($this->ExecuteAction);
        } else {
            $this->ExecuteAction = $executeAction;
        }
        return $this;
    }
    /**
     * Get FirstLoad value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFirstLoad()
    {
        return isset($this->FirstLoad) ? $this->FirstLoad : null;
    }
    /**
     * Set FirstLoad value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $firstLoad
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setFirstLoad($firstLoad = null)
    {
        // validation for constraint: boolean
        if (!is_null($firstLoad) && !is_bool($firstLoad)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($firstLoad, true), gettype($firstLoad)), __LINE__);
        }
        if (is_null($firstLoad) || (is_array($firstLoad) && empty($firstLoad))) {
            unset($this->FirstLoad);
        } else {
            $this->FirstLoad = $firstLoad;
        }
        return $this;
    }
    /**
     * Get Ids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIds()
    {
        return isset($this->Ids) ? $this->Ids : null;
    }
    /**
     * Set Ids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ids
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setIds($ids = null)
    {
        // validation for constraint: string
        if (!is_null($ids) && !is_string($ids)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ids, true), gettype($ids)), __LINE__);
        }
        if (is_null($ids) || (is_array($ids) && empty($ids))) {
            unset($this->Ids);
        } else {
            $this->Ids = $ids;
        }
        return $this;
    }
    /**
     * Get InputBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInputBarcode()
    {
        return isset($this->InputBarcode) ? $this->InputBarcode : null;
    }
    /**
     * Set InputBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $inputBarcode
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setInputBarcode($inputBarcode = null)
    {
        // validation for constraint: string
        if (!is_null($inputBarcode) && !is_string($inputBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($inputBarcode, true), gettype($inputBarcode)), __LINE__);
        }
        if (is_null($inputBarcode) || (is_array($inputBarcode) && empty($inputBarcode))) {
            unset($this->InputBarcode);
        } else {
            $this->InputBarcode = $inputBarcode;
        }
        return $this;
    }
    /**
     * Get ItemCounter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemCounter()
    {
        return isset($this->ItemCounter) ? $this->ItemCounter : null;
    }
    /**
     * Set ItemCounter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemCounter
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setItemCounter($itemCounter = null)
    {
        // validation for constraint: string
        if (!is_null($itemCounter) && !is_string($itemCounter)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemCounter, true), gettype($itemCounter)), __LINE__);
        }
        if (is_null($itemCounter) || (is_array($itemCounter) && empty($itemCounter))) {
            unset($this->ItemCounter);
        } else {
            $this->ItemCounter = $itemCounter;
        }
        return $this;
    }
    /**
     * Get ItemDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemDescription()
    {
        return isset($this->ItemDescription) ? $this->ItemDescription : null;
    }
    /**
     * Set ItemDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemDescription
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setItemDescription($itemDescription = null)
    {
        // validation for constraint: string
        if (!is_null($itemDescription) && !is_string($itemDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemDescription, true), gettype($itemDescription)), __LINE__);
        }
        if (is_null($itemDescription) || (is_array($itemDescription) && empty($itemDescription))) {
            unset($this->ItemDescription);
        } else {
            $this->ItemDescription = $itemDescription;
        }
        return $this;
    }
    /**
     * Get ItemErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemErrorMessage()
    {
        return isset($this->ItemErrorMessage) ? $this->ItemErrorMessage : null;
    }
    /**
     * Set ItemErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemErrorMessage
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setItemErrorMessage($itemErrorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($itemErrorMessage) && !is_string($itemErrorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemErrorMessage, true), gettype($itemErrorMessage)), __LINE__);
        }
        if (is_null($itemErrorMessage) || (is_array($itemErrorMessage) && empty($itemErrorMessage))) {
            unset($this->ItemErrorMessage);
        } else {
            $this->ItemErrorMessage = $itemErrorMessage;
        }
        return $this;
    }
    /**
     * Get NextItemIndex value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNextItemIndex()
    {
        return isset($this->NextItemIndex) ? $this->NextItemIndex : null;
    }
    /**
     * Set NextItemIndex value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nextItemIndex
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setNextItemIndex($nextItemIndex = null)
    {
        // validation for constraint: int
        if (!is_null($nextItemIndex) && !(is_int($nextItemIndex) || ctype_digit($nextItemIndex))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nextItemIndex, true), gettype($nextItemIndex)), __LINE__);
        }
        if (is_null($nextItemIndex) || (is_array($nextItemIndex) && empty($nextItemIndex))) {
            unset($this->NextItemIndex);
        } else {
            $this->NextItemIndex = $nextItemIndex;
        }
        return $this;
    }
    /**
     * Get ReactivateManner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReactivateManner()
    {
        return isset($this->ReactivateManner) ? $this->ReactivateManner : null;
    }
    /**
     * Set ReactivateManner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BarcodeReactivateManner::valueIsValid()
     * @uses \patest\EnumType\BarcodeReactivateManner::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $reactivateManner
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setReactivateManner($reactivateManner = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BarcodeReactivateManner::valueIsValid($reactivateManner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BarcodeReactivateManner', is_array($reactivateManner) ? implode(', ', $reactivateManner) : var_export($reactivateManner, true), implode(', ', \patest\EnumType\BarcodeReactivateManner::getValidValues())), __LINE__);
        }
        if (is_null($reactivateManner) || (is_array($reactivateManner) && empty($reactivateManner))) {
            unset($this->ReactivateManner);
        } else {
            $this->ReactivateManner = $reactivateManner;
        }
        return $this;
    }
    /**
     * Get ReferencedEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencedEntityId()
    {
        return isset($this->ReferencedEntityId) ? $this->ReferencedEntityId : null;
    }
    /**
     * Set ReferencedEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencedEntityId
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setReferencedEntityId($referencedEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($referencedEntityId) && !is_string($referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referencedEntityId, true), gettype($referencedEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($referencedEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $referencedEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($referencedEntityId, true)), __LINE__);
        }
        if (is_null($referencedEntityId) || (is_array($referencedEntityId) && empty($referencedEntityId))) {
            unset($this->ReferencedEntityId);
        } else {
            $this->ReferencedEntityId = $referencedEntityId;
        }
        return $this;
    }
    /**
     * Get SkipItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSkipItem()
    {
        return isset($this->SkipItem) ? $this->SkipItem : null;
    }
    /**
     * Set SkipItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $skipItem
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setSkipItem($skipItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($skipItem) && !is_bool($skipItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($skipItem, true), gettype($skipItem)), __LINE__);
        }
        if (is_null($skipItem) || (is_array($skipItem) && empty($skipItem))) {
            unset($this->SkipItem);
        } else {
            $this->SkipItem = $skipItem;
        }
        return $this;
    }
    /**
     * Get TotalItemsNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTotalItemsNumber()
    {
        return isset($this->TotalItemsNumber) ? $this->TotalItemsNumber : null;
    }
    /**
     * Set TotalItemsNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $totalItemsNumber
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setTotalItemsNumber($totalItemsNumber = null)
    {
        // validation for constraint: int
        if (!is_null($totalItemsNumber) && !(is_int($totalItemsNumber) || ctype_digit($totalItemsNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($totalItemsNumber, true), gettype($totalItemsNumber)), __LINE__);
        }
        if (is_null($totalItemsNumber) || (is_array($totalItemsNumber) && empty($totalItemsNumber))) {
            unset($this->TotalItemsNumber);
        } else {
            $this->TotalItemsNumber = $totalItemsNumber;
        }
        return $this;
    }
    /**
     * Get ValidItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getValidItem()
    {
        return isset($this->ValidItem) ? $this->ValidItem : null;
    }
    /**
     * Set ValidItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $validItem
     * @return \patest\StructType\BizActionLogics_AccessControl_ReactivateSubscriptionBarcode_Request
     */
    public function setValidItem($validItem = null)
    {
        // validation for constraint: boolean
        if (!is_null($validItem) && !is_bool($validItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($validItem, true), gettype($validItem)), __LINE__);
        }
        if (is_null($validItem) || (is_array($validItem) && empty($validItem))) {
            unset($this->ValidItem);
        } else {
            $this->ValidItem = $validItem;
        }
        return $this;
    }
}
