<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchPrintRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BatchPrintRequest
 * @subpackage Structs
 */
class BatchPrintRequest extends AbstractStructBase
{
    /**
     * The DocumentTypesToPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $DocumentTypesToPrint;
    /**
     * The PrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PrinterId;
    /**
     * The PrintingMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $PrintingMode;
    /**
     * The SearchParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SearchParameters
     */
    public $SearchParameters;
    /**
     * The Sorting
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Sorting;
    /**
     * The TicketsQtyToPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TicketsQtyToPrint;
    /**
     * The Transactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfBatchPrintingTransaction
     */
    public $Transactions;
    /**
     * Constructor method for BatchPrintRequest
     * @uses BatchPrintRequest::setDocumentTypesToPrint()
     * @uses BatchPrintRequest::setPrinterId()
     * @uses BatchPrintRequest::setPrintingMode()
     * @uses BatchPrintRequest::setSearchParameters()
     * @uses BatchPrintRequest::setSorting()
     * @uses BatchPrintRequest::setTicketsQtyToPrint()
     * @uses BatchPrintRequest::setTransactions()
     * @param \patest\ArrayType\ArrayOfstring $documentTypesToPrint
     * @param string $printerId
     * @param string $printingMode
     * @param \patest\StructType\SearchParameters $searchParameters
     * @param string $sorting
     * @param int $ticketsQtyToPrint
     * @param \patest\ArrayType\ArrayOfBatchPrintingTransaction $transactions
     */
    public function __construct(\patest\ArrayType\ArrayOfstring $documentTypesToPrint = null, $printerId = null, $printingMode = null, \patest\StructType\SearchParameters $searchParameters = null, $sorting = null, $ticketsQtyToPrint = null, \patest\ArrayType\ArrayOfBatchPrintingTransaction $transactions = null)
    {
        $this
            ->setDocumentTypesToPrint($documentTypesToPrint)
            ->setPrinterId($printerId)
            ->setPrintingMode($printingMode)
            ->setSearchParameters($searchParameters)
            ->setSorting($sorting)
            ->setTicketsQtyToPrint($ticketsQtyToPrint)
            ->setTransactions($transactions);
    }
    /**
     * Get DocumentTypesToPrint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getDocumentTypesToPrint()
    {
        return isset($this->DocumentTypesToPrint) ? $this->DocumentTypesToPrint : null;
    }
    /**
     * Set DocumentTypesToPrint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $documentTypesToPrint
     * @return \patest\StructType\BatchPrintRequest
     */
    public function setDocumentTypesToPrint(\patest\ArrayType\ArrayOfstring $documentTypesToPrint = null)
    {
        if (is_null($documentTypesToPrint) || (is_array($documentTypesToPrint) && empty($documentTypesToPrint))) {
            unset($this->DocumentTypesToPrint);
        } else {
            $this->DocumentTypesToPrint = $documentTypesToPrint;
        }
        return $this;
    }
    /**
     * Get PrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPrinterId()
    {
        return isset($this->PrinterId) ? $this->PrinterId : null;
    }
    /**
     * Set PrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $printerId
     * @return \patest\StructType\BatchPrintRequest
     */
    public function setPrinterId($printerId = null)
    {
        // validation for constraint: string
        if (!is_null($printerId) && !is_string($printerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($printerId, true), gettype($printerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($printerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $printerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($printerId, true)), __LINE__);
        }
        if (is_null($printerId) || (is_array($printerId) && empty($printerId))) {
            unset($this->PrinterId);
        } else {
            $this->PrinterId = $printerId;
        }
        return $this;
    }
    /**
     * Get PrintingMode value
     * @return string|null
     */
    public function getPrintingMode()
    {
        return $this->PrintingMode;
    }
    /**
     * Set PrintingMode value
     * @uses \patest\EnumType\BatchPrintingMode::valueIsValid()
     * @uses \patest\EnumType\BatchPrintingMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $printingMode
     * @return \patest\StructType\BatchPrintRequest
     */
    public function setPrintingMode($printingMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintingMode::valueIsValid($printingMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintingMode', is_array($printingMode) ? implode(', ', $printingMode) : var_export($printingMode, true), implode(', ', \patest\EnumType\BatchPrintingMode::getValidValues())), __LINE__);
        }
        $this->PrintingMode = $printingMode;
        return $this;
    }
    /**
     * Get SearchParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SearchParameters|null
     */
    public function getSearchParameters()
    {
        return isset($this->SearchParameters) ? $this->SearchParameters : null;
    }
    /**
     * Set SearchParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SearchParameters $searchParameters
     * @return \patest\StructType\BatchPrintRequest
     */
    public function setSearchParameters(\patest\StructType\SearchParameters $searchParameters = null)
    {
        if (is_null($searchParameters) || (is_array($searchParameters) && empty($searchParameters))) {
            unset($this->SearchParameters);
        } else {
            $this->SearchParameters = $searchParameters;
        }
        return $this;
    }
    /**
     * Get Sorting value
     * @return string|null
     */
    public function getSorting()
    {
        return $this->Sorting;
    }
    /**
     * Set Sorting value
     * @uses \patest\EnumType\BatchPrintingSorting::valueIsValid()
     * @uses \patest\EnumType\BatchPrintingSorting::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sorting
     * @return \patest\StructType\BatchPrintRequest
     */
    public function setSorting($sorting = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BatchPrintingSorting::valueIsValid($sorting)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BatchPrintingSorting', is_array($sorting) ? implode(', ', $sorting) : var_export($sorting, true), implode(', ', \patest\EnumType\BatchPrintingSorting::getValidValues())), __LINE__);
        }
        $this->Sorting = $sorting;
        return $this;
    }
    /**
     * Get TicketsQtyToPrint value
     * @return int|null
     */
    public function getTicketsQtyToPrint()
    {
        return $this->TicketsQtyToPrint;
    }
    /**
     * Set TicketsQtyToPrint value
     * @param int $ticketsQtyToPrint
     * @return \patest\StructType\BatchPrintRequest
     */
    public function setTicketsQtyToPrint($ticketsQtyToPrint = null)
    {
        // validation for constraint: int
        if (!is_null($ticketsQtyToPrint) && !(is_int($ticketsQtyToPrint) || ctype_digit($ticketsQtyToPrint))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketsQtyToPrint, true), gettype($ticketsQtyToPrint)), __LINE__);
        }
        $this->TicketsQtyToPrint = $ticketsQtyToPrint;
        return $this;
    }
    /**
     * Get Transactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfBatchPrintingTransaction|null
     */
    public function getTransactions()
    {
        return isset($this->Transactions) ? $this->Transactions : null;
    }
    /**
     * Set Transactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfBatchPrintingTransaction $transactions
     * @return \patest\StructType\BatchPrintRequest
     */
    public function setTransactions(\patest\ArrayType\ArrayOfBatchPrintingTransaction $transactions = null)
    {
        if (is_null($transactions) || (is_array($transactions) && empty($transactions))) {
            unset($this->Transactions);
        } else {
            $this->Transactions = $transactions;
        }
        return $this;
    }
}
