<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BasketItemAccessControlValidationData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:BasketItemAccessControlValidationData
 * @subpackage Structs
 */
class BasketItemAccessControlValidationData extends AbstractStructBase
{
    /**
     * The AccessCardId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessCardId;
    /**
     * The AccessCardNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessCardNumber;
    /**
     * The AccessControlledEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AccessControlledEntityId;
    /**
     * The ItemId
     * @var int
     */
    public $ItemId;
    /**
     * The ItemTypeId
     * @var int
     */
    public $ItemTypeId;
    /**
     * The OwnerId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerId;
    /**
     * Constructor method for BasketItemAccessControlValidationData
     * @uses BasketItemAccessControlValidationData::setAccessCardId()
     * @uses BasketItemAccessControlValidationData::setAccessCardNumber()
     * @uses BasketItemAccessControlValidationData::setAccessControlledEntityId()
     * @uses BasketItemAccessControlValidationData::setItemId()
     * @uses BasketItemAccessControlValidationData::setItemTypeId()
     * @uses BasketItemAccessControlValidationData::setOwnerId()
     * @param string $accessCardId
     * @param string $accessCardNumber
     * @param string $accessControlledEntityId
     * @param int $itemId
     * @param int $itemTypeId
     * @param string $ownerId
     */
    public function __construct($accessCardId = null, $accessCardNumber = null, $accessControlledEntityId = null, $itemId = null, $itemTypeId = null, $ownerId = null)
    {
        $this
            ->setAccessCardId($accessCardId)
            ->setAccessCardNumber($accessCardNumber)
            ->setAccessControlledEntityId($accessControlledEntityId)
            ->setItemId($itemId)
            ->setItemTypeId($itemTypeId)
            ->setOwnerId($ownerId);
    }
    /**
     * Get AccessCardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardId()
    {
        return isset($this->AccessCardId) ? $this->AccessCardId : null;
    }
    /**
     * Set AccessCardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCardId
     * @return \patest\StructType\BasketItemAccessControlValidationData
     */
    public function setAccessCardId($accessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardId) && !is_string($accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardId, true), gettype($accessCardId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessCardId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessCardId, true)), __LINE__);
        }
        if (is_null($accessCardId) || (is_array($accessCardId) && empty($accessCardId))) {
            unset($this->AccessCardId);
        } else {
            $this->AccessCardId = $accessCardId;
        }
        return $this;
    }
    /**
     * Get AccessCardNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardNumber()
    {
        return isset($this->AccessCardNumber) ? $this->AccessCardNumber : null;
    }
    /**
     * Set AccessCardNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCardNumber
     * @return \patest\StructType\BasketItemAccessControlValidationData
     */
    public function setAccessCardNumber($accessCardNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardNumber) && !is_string($accessCardNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardNumber, true), gettype($accessCardNumber)), __LINE__);
        }
        if (is_null($accessCardNumber) || (is_array($accessCardNumber) && empty($accessCardNumber))) {
            unset($this->AccessCardNumber);
        } else {
            $this->AccessCardNumber = $accessCardNumber;
        }
        return $this;
    }
    /**
     * Get AccessControlledEntityId value
     * @return string|null
     */
    public function getAccessControlledEntityId()
    {
        return $this->AccessControlledEntityId;
    }
    /**
     * Set AccessControlledEntityId value
     * @param string $accessControlledEntityId
     * @return \patest\StructType\BasketItemAccessControlValidationData
     */
    public function setAccessControlledEntityId($accessControlledEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($accessControlledEntityId) && !is_string($accessControlledEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessControlledEntityId, true), gettype($accessControlledEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($accessControlledEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $accessControlledEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($accessControlledEntityId, true)), __LINE__);
        }
        $this->AccessControlledEntityId = $accessControlledEntityId;
        return $this;
    }
    /**
     * Get ItemId value
     * @return int|null
     */
    public function getItemId()
    {
        return $this->ItemId;
    }
    /**
     * Set ItemId value
     * @param int $itemId
     * @return \patest\StructType\BasketItemAccessControlValidationData
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !(is_int($itemId) || ctype_digit($itemId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        $this->ItemId = $itemId;
        return $this;
    }
    /**
     * Get ItemTypeId value
     * @return int|null
     */
    public function getItemTypeId()
    {
        return $this->ItemTypeId;
    }
    /**
     * Set ItemTypeId value
     * @param int $itemTypeId
     * @return \patest\StructType\BasketItemAccessControlValidationData
     */
    public function setItemTypeId($itemTypeId = null)
    {
        // validation for constraint: int
        if (!is_null($itemTypeId) && !(is_int($itemTypeId) || ctype_digit($itemTypeId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemTypeId, true), gettype($itemTypeId)), __LINE__);
        }
        $this->ItemTypeId = $itemTypeId;
        return $this;
    }
    /**
     * Get OwnerId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerId()
    {
        return isset($this->OwnerId) ? $this->OwnerId : null;
    }
    /**
     * Set OwnerId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerId
     * @return \patest\StructType\BasketItemAccessControlValidationData
     */
    public function setOwnerId($ownerId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerId) && !is_string($ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerId, true), gettype($ownerId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerId, true)), __LINE__);
        }
        if (is_null($ownerId) || (is_array($ownerId) && empty($ownerId))) {
            unset($this->OwnerId);
        } else {
            $this->OwnerId = $ownerId;
        }
        return $this;
    }
}
