<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for bSRO.Sales.RelockSeats StructType
 * @subpackage Structs
 */
class BSRO_Sales_RelockSeats extends AnyEntity
{
    /**
     * The Restriction
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Restriction;
    /**
     * Constructor method for bSRO.Sales.RelockSeats
     * @uses BSRO_Sales_RelockSeats::setRestriction()
     * @param string $restriction
     */
    public function __construct($restriction = null)
    {
        $this
            ->setRestriction($restriction);
    }
    /**
     * Get Restriction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRestriction()
    {
        return isset($this->Restriction) ? $this->Restriction : null;
    }
    /**
     * Set Restriction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $restriction
     * @return \patest\StructType\BSRO_Sales_RelockSeats
     */
    public function setRestriction($restriction = null)
    {
        // validation for constraint: string
        if (!is_null($restriction) && !is_string($restriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($restriction, true), gettype($restriction)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($restriction) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $restriction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($restriction, true)), __LINE__);
        }
        if (is_null($restriction) || (is_array($restriction) && empty($restriction))) {
            unset($this->Restriction);
        } else {
            $this->Restriction = $restriction;
        }
        return $this;
    }
}
