<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for
 * Authentication.IdentityPlatform.Auth0.ApplicationInitiateLoginURL StructType
 * @subpackage Structs
 */
class Authentication_IdentityPlatform_Auth0_ApplicationInitiateLoginURL extends AnyEntity
{
    /**
     * The ApplicationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationName;
    /**
     * The InitiateLoginURL
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $InitiateLoginURL;
    /**
     * Constructor method for
     * Authentication.IdentityPlatform.Auth0.ApplicationInitiateLoginURL
     * @uses Authentication_IdentityPlatform_Auth0_ApplicationInitiateLoginURL::setApplicationName()
     * @uses Authentication_IdentityPlatform_Auth0_ApplicationInitiateLoginURL::setInitiateLoginURL()
     * @param string $applicationName
     * @param string $initiateLoginURL
     */
    public function __construct($applicationName = null, $initiateLoginURL = null)
    {
        $this
            ->setApplicationName($applicationName)
            ->setInitiateLoginURL($initiateLoginURL);
    }
    /**
     * Get ApplicationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationName()
    {
        return isset($this->ApplicationName) ? $this->ApplicationName : null;
    }
    /**
     * Set ApplicationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationName
     * @return \patest\StructType\Authentication_IdentityPlatform_Auth0_ApplicationInitiateLoginURL
     */
    public function setApplicationName($applicationName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationName) && !is_string($applicationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationName, true), gettype($applicationName)), __LINE__);
        }
        if (is_null($applicationName) || (is_array($applicationName) && empty($applicationName))) {
            unset($this->ApplicationName);
        } else {
            $this->ApplicationName = $applicationName;
        }
        return $this;
    }
    /**
     * Get InitiateLoginURL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInitiateLoginURL()
    {
        return isset($this->InitiateLoginURL) ? $this->InitiateLoginURL : null;
    }
    /**
     * Set InitiateLoginURL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $initiateLoginURL
     * @return \patest\StructType\Authentication_IdentityPlatform_Auth0_ApplicationInitiateLoginURL
     */
    public function setInitiateLoginURL($initiateLoginURL = null)
    {
        // validation for constraint: string
        if (!is_null($initiateLoginURL) && !is_string($initiateLoginURL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($initiateLoginURL, true), gettype($initiateLoginURL)), __LINE__);
        }
        if (is_null($initiateLoginURL) || (is_array($initiateLoginURL) && empty($initiateLoginURL))) {
            unset($this->InitiateLoginURL);
        } else {
            $this->InitiateLoginURL = $initiateLoginURL;
        }
        return $this;
    }
}
