<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AssetResource StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AssetResource
 * @subpackage Structs
 */
class AssetResource extends AbstractStructBase
{
    /**
     * The Behaviour
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Behaviour;
    /**
     * The CrossOrigin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CrossOrigin;
    /**
     * The Integrity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Integrity;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Type;
    /**
     * The Url
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Url;
    /**
     * Constructor method for AssetResource
     * @uses AssetResource::setBehaviour()
     * @uses AssetResource::setCrossOrigin()
     * @uses AssetResource::setIntegrity()
     * @uses AssetResource::setType()
     * @uses AssetResource::setUrl()
     * @param string $behaviour
     * @param string $crossOrigin
     * @param string $integrity
     * @param string $type
     * @param string $url
     */
    public function __construct($behaviour = null, $crossOrigin = null, $integrity = null, $type = null, $url = null)
    {
        $this
            ->setBehaviour($behaviour)
            ->setCrossOrigin($crossOrigin)
            ->setIntegrity($integrity)
            ->setType($type)
            ->setUrl($url);
    }
    /**
     * Get Behaviour value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBehaviour()
    {
        return isset($this->Behaviour) ? $this->Behaviour : null;
    }
    /**
     * Set Behaviour value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $behaviour
     * @return \patest\StructType\AssetResource
     */
    public function setBehaviour($behaviour = null)
    {
        // validation for constraint: string
        if (!is_null($behaviour) && !is_string($behaviour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($behaviour, true), gettype($behaviour)), __LINE__);
        }
        if (is_null($behaviour) || (is_array($behaviour) && empty($behaviour))) {
            unset($this->Behaviour);
        } else {
            $this->Behaviour = $behaviour;
        }
        return $this;
    }
    /**
     * Get CrossOrigin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCrossOrigin()
    {
        return isset($this->CrossOrigin) ? $this->CrossOrigin : null;
    }
    /**
     * Set CrossOrigin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $crossOrigin
     * @return \patest\StructType\AssetResource
     */
    public function setCrossOrigin($crossOrigin = null)
    {
        // validation for constraint: string
        if (!is_null($crossOrigin) && !is_string($crossOrigin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($crossOrigin, true), gettype($crossOrigin)), __LINE__);
        }
        if (is_null($crossOrigin) || (is_array($crossOrigin) && empty($crossOrigin))) {
            unset($this->CrossOrigin);
        } else {
            $this->CrossOrigin = $crossOrigin;
        }
        return $this;
    }
    /**
     * Get Integrity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntegrity()
    {
        return isset($this->Integrity) ? $this->Integrity : null;
    }
    /**
     * Set Integrity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $integrity
     * @return \patest\StructType\AssetResource
     */
    public function setIntegrity($integrity = null)
    {
        // validation for constraint: string
        if (!is_null($integrity) && !is_string($integrity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($integrity, true), gettype($integrity)), __LINE__);
        }
        if (is_null($integrity) || (is_array($integrity) && empty($integrity))) {
            unset($this->Integrity);
        } else {
            $this->Integrity = $integrity;
        }
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @uses \patest\EnumType\AssetType::valueIsValid()
     * @uses \patest\EnumType\AssetType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $type
     * @return \patest\StructType\AssetResource
     */
    public function setType($type = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AssetType::valueIsValid($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AssetType', is_array($type) ? implode(', ', $type) : var_export($type, true), implode(', ', \patest\EnumType\AssetType::getValidValues())), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get Url value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUrl()
    {
        return isset($this->Url) ? $this->Url : null;
    }
    /**
     * Set Url value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $url
     * @return \patest\StructType\AssetResource
     */
    public function setUrl($url = null)
    {
        // validation for constraint: string
        if (!is_null($url) && !is_string($url)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($url, true), gettype($url)), __LINE__);
        }
        if (is_null($url) || (is_array($url) && empty($url))) {
            unset($this->Url);
        } else {
            $this->Url = $url;
        }
        return $this;
    }
}
