<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Any.MapToExternalSystem StructType
 * @subpackage Structs
 */
class Any_MapToExternalSystem extends PersistableEntity
{
    /**
     * The Data1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Data1;
    /**
     * The Data2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Data2;
    /**
     * The Data3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Data3;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityId;
    /**
     * The ExternalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalId;
    /**
     * The ExternalSystemName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalSystemName;
    /**
     * The LastSyncFromExternalSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastSyncFromExternalSystem;
    /**
     * The LastSyncToExternalSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastSyncToExternalSystem;
    /**
     * The NativeEntityLocalId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NativeEntityLocalId;
    /**
     * The NativeEntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NativeEntityName;
    /**
     * The ParentEntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ParentEntityId;
    /**
     * Constructor method for Any.MapToExternalSystem
     * @uses Any_MapToExternalSystem::setData1()
     * @uses Any_MapToExternalSystem::setData2()
     * @uses Any_MapToExternalSystem::setData3()
     * @uses Any_MapToExternalSystem::setEntityId()
     * @uses Any_MapToExternalSystem::setExternalId()
     * @uses Any_MapToExternalSystem::setExternalSystemName()
     * @uses Any_MapToExternalSystem::setLastSyncFromExternalSystem()
     * @uses Any_MapToExternalSystem::setLastSyncToExternalSystem()
     * @uses Any_MapToExternalSystem::setNativeEntityLocalId()
     * @uses Any_MapToExternalSystem::setNativeEntityName()
     * @uses Any_MapToExternalSystem::setParentEntityId()
     * @param int $data1
     * @param string $data2
     * @param string $data3
     * @param string $entityId
     * @param string $externalId
     * @param string $externalSystemName
     * @param string $lastSyncFromExternalSystem
     * @param string $lastSyncToExternalSystem
     * @param int $nativeEntityLocalId
     * @param string $nativeEntityName
     * @param string $parentEntityId
     */
    public function __construct($data1 = null, $data2 = null, $data3 = null, $entityId = null, $externalId = null, $externalSystemName = null, $lastSyncFromExternalSystem = null, $lastSyncToExternalSystem = null, $nativeEntityLocalId = null, $nativeEntityName = null, $parentEntityId = null)
    {
        $this
            ->setData1($data1)
            ->setData2($data2)
            ->setData3($data3)
            ->setEntityId($entityId)
            ->setExternalId($externalId)
            ->setExternalSystemName($externalSystemName)
            ->setLastSyncFromExternalSystem($lastSyncFromExternalSystem)
            ->setLastSyncToExternalSystem($lastSyncToExternalSystem)
            ->setNativeEntityLocalId($nativeEntityLocalId)
            ->setNativeEntityName($nativeEntityName)
            ->setParentEntityId($parentEntityId);
    }
    /**
     * Get Data1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getData1()
    {
        return isset($this->Data1) ? $this->Data1 : null;
    }
    /**
     * Set Data1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $data1
     * @return \patest\StructType\Any_MapToExternalSystem
     */
    public function setData1($data1 = null)
    {
        // validation for constraint: int
        if (!is_null($data1) && !(is_int($data1) || ctype_digit($data1))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($data1, true), gettype($data1)), __LINE__);
        }
        if (is_null($data1) || (is_array($data1) && empty($data1))) {
            unset($this->Data1);
        } else {
            $this->Data1 = $data1;
        }
        return $this;
    }
    /**
     * Get Data2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getData2()
    {
        return isset($this->Data2) ? $this->Data2 : null;
    }
    /**
     * Set Data2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $data2
     * @return \patest\StructType\Any_MapToExternalSystem
     */
    public function setData2($data2 = null)
    {
        // validation for constraint: string
        if (!is_null($data2) && !is_string($data2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data2, true), gettype($data2)), __LINE__);
        }
        if (is_null($data2) || (is_array($data2) && empty($data2))) {
            unset($this->Data2);
        } else {
            $this->Data2 = $data2;
        }
        return $this;
    }
    /**
     * Get Data3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getData3()
    {
        return isset($this->Data3) ? $this->Data3 : null;
    }
    /**
     * Set Data3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $data3
     * @return \patest\StructType\Any_MapToExternalSystem
     */
    public function setData3($data3 = null)
    {
        // validation for constraint: string
        if (!is_null($data3) && !is_string($data3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data3, true), gettype($data3)), __LINE__);
        }
        if (is_null($data3) || (is_array($data3) && empty($data3))) {
            unset($this->Data3);
        } else {
            $this->Data3 = $data3;
        }
        return $this;
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityId
     * @return \patest\StructType\Any_MapToExternalSystem
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get ExternalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalId()
    {
        return isset($this->ExternalId) ? $this->ExternalId : null;
    }
    /**
     * Set ExternalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalId
     * @return \patest\StructType\Any_MapToExternalSystem
     */
    public function setExternalId($externalId = null)
    {
        // validation for constraint: string
        if (!is_null($externalId) && !is_string($externalId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalId, true), gettype($externalId)), __LINE__);
        }
        if (is_null($externalId) || (is_array($externalId) && empty($externalId))) {
            unset($this->ExternalId);
        } else {
            $this->ExternalId = $externalId;
        }
        return $this;
    }
    /**
     * Get ExternalSystemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalSystemName()
    {
        return isset($this->ExternalSystemName) ? $this->ExternalSystemName : null;
    }
    /**
     * Set ExternalSystemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalSystemName
     * @return \patest\StructType\Any_MapToExternalSystem
     */
    public function setExternalSystemName($externalSystemName = null)
    {
        // validation for constraint: string
        if (!is_null($externalSystemName) && !is_string($externalSystemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalSystemName, true), gettype($externalSystemName)), __LINE__);
        }
        if (is_null($externalSystemName) || (is_array($externalSystemName) && empty($externalSystemName))) {
            unset($this->ExternalSystemName);
        } else {
            $this->ExternalSystemName = $externalSystemName;
        }
        return $this;
    }
    /**
     * Get LastSyncFromExternalSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastSyncFromExternalSystem()
    {
        return isset($this->LastSyncFromExternalSystem) ? $this->LastSyncFromExternalSystem : null;
    }
    /**
     * Set LastSyncFromExternalSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastSyncFromExternalSystem
     * @return \patest\StructType\Any_MapToExternalSystem
     */
    public function setLastSyncFromExternalSystem($lastSyncFromExternalSystem = null)
    {
        // validation for constraint: string
        if (!is_null($lastSyncFromExternalSystem) && !is_string($lastSyncFromExternalSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastSyncFromExternalSystem, true), gettype($lastSyncFromExternalSystem)), __LINE__);
        }
        if (is_null($lastSyncFromExternalSystem) || (is_array($lastSyncFromExternalSystem) && empty($lastSyncFromExternalSystem))) {
            unset($this->LastSyncFromExternalSystem);
        } else {
            $this->LastSyncFromExternalSystem = $lastSyncFromExternalSystem;
        }
        return $this;
    }
    /**
     * Get LastSyncToExternalSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastSyncToExternalSystem()
    {
        return isset($this->LastSyncToExternalSystem) ? $this->LastSyncToExternalSystem : null;
    }
    /**
     * Set LastSyncToExternalSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastSyncToExternalSystem
     * @return \patest\StructType\Any_MapToExternalSystem
     */
    public function setLastSyncToExternalSystem($lastSyncToExternalSystem = null)
    {
        // validation for constraint: string
        if (!is_null($lastSyncToExternalSystem) && !is_string($lastSyncToExternalSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastSyncToExternalSystem, true), gettype($lastSyncToExternalSystem)), __LINE__);
        }
        if (is_null($lastSyncToExternalSystem) || (is_array($lastSyncToExternalSystem) && empty($lastSyncToExternalSystem))) {
            unset($this->LastSyncToExternalSystem);
        } else {
            $this->LastSyncToExternalSystem = $lastSyncToExternalSystem;
        }
        return $this;
    }
    /**
     * Get NativeEntityLocalId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNativeEntityLocalId()
    {
        return isset($this->NativeEntityLocalId) ? $this->NativeEntityLocalId : null;
    }
    /**
     * Set NativeEntityLocalId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nativeEntityLocalId
     * @return \patest\StructType\Any_MapToExternalSystem
     */
    public function setNativeEntityLocalId($nativeEntityLocalId = null)
    {
        // validation for constraint: int
        if (!is_null($nativeEntityLocalId) && !(is_int($nativeEntityLocalId) || ctype_digit($nativeEntityLocalId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($nativeEntityLocalId, true), gettype($nativeEntityLocalId)), __LINE__);
        }
        if (is_null($nativeEntityLocalId) || (is_array($nativeEntityLocalId) && empty($nativeEntityLocalId))) {
            unset($this->NativeEntityLocalId);
        } else {
            $this->NativeEntityLocalId = $nativeEntityLocalId;
        }
        return $this;
    }
    /**
     * Get NativeEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNativeEntityName()
    {
        return isset($this->NativeEntityName) ? $this->NativeEntityName : null;
    }
    /**
     * Set NativeEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nativeEntityName
     * @return \patest\StructType\Any_MapToExternalSystem
     */
    public function setNativeEntityName($nativeEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($nativeEntityName) && !is_string($nativeEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($nativeEntityName, true), gettype($nativeEntityName)), __LINE__);
        }
        if (is_null($nativeEntityName) || (is_array($nativeEntityName) && empty($nativeEntityName))) {
            unset($this->NativeEntityName);
        } else {
            $this->NativeEntityName = $nativeEntityName;
        }
        return $this;
    }
    /**
     * Get ParentEntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getParentEntityId()
    {
        return isset($this->ParentEntityId) ? $this->ParentEntityId : null;
    }
    /**
     * Set ParentEntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $parentEntityId
     * @return \patest\StructType\Any_MapToExternalSystem
     */
    public function setParentEntityId($parentEntityId = null)
    {
        // validation for constraint: string
        if (!is_null($parentEntityId) && !is_string($parentEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($parentEntityId, true), gettype($parentEntityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($parentEntityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $parentEntityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($parentEntityId, true)), __LINE__);
        }
        if (is_null($parentEntityId) || (is_array($parentEntityId) && empty($parentEntityId))) {
            unset($this->ParentEntityId);
        } else {
            $this->ParentEntityId = $parentEntityId;
        }
        return $this;
    }
}
