<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Any.AttachmentFilter StructType
 * @subpackage Structs
 */
class Any_AttachmentFilter extends FilterEntity
{
    /**
     * The AttachmentType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AttachmentType;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * Constructor method for Any.AttachmentFilter
     * @uses Any_AttachmentFilter::setAttachmentType()
     * @uses Any_AttachmentFilter::setName()
     * @param string $attachmentType
     * @param string $name
     */
    public function __construct($attachmentType = null, $name = null)
    {
        $this
            ->setAttachmentType($attachmentType)
            ->setName($name);
    }
    /**
     * Get AttachmentType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAttachmentType()
    {
        return isset($this->AttachmentType) ? $this->AttachmentType : null;
    }
    /**
     * Set AttachmentType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AttachmentType::valueIsValid()
     * @uses \patest\EnumType\AttachmentType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attachmentType
     * @return \patest\StructType\Any_AttachmentFilter
     */
    public function setAttachmentType($attachmentType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AttachmentType::valueIsValid($attachmentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AttachmentType', is_array($attachmentType) ? implode(', ', $attachmentType) : var_export($attachmentType, true), implode(', ', \patest\EnumType\AttachmentType::getValidValues())), __LINE__);
        }
        if (is_null($attachmentType) || (is_array($attachmentType) && empty($attachmentType))) {
            unset($this->AttachmentType);
        } else {
            $this->AttachmentType = $attachmentType;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\Any_AttachmentFilter
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
