<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddressSearchRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddressSearchRequest
 * @subpackage Structs
 */
class AddressSearchRequest extends AbstractStructBase
{
    /**
     * The Address
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PostalAddress
     */
    public $Address;
    /**
     * Constructor method for AddressSearchRequest
     * @uses AddressSearchRequest::setAddress()
     * @param \patest\StructType\PostalAddress $address
     */
    public function __construct(\patest\StructType\PostalAddress $address = null)
    {
        $this
            ->setAddress($address);
    }
    /**
     * Get Address value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PostalAddress|null
     */
    public function getAddress()
    {
        return isset($this->Address) ? $this->Address : null;
    }
    /**
     * Set Address value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PostalAddress $address
     * @return \patest\StructType\AddressSearchRequest
     */
    public function setAddress(\patest\StructType\PostalAddress $address = null)
    {
        if (is_null($address) || (is_array($address) && empty($address))) {
            unset($this->Address);
        } else {
            $this->Address = $address;
        }
        return $this;
    }
}
