<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddSubscriptionProductsToBasketRequestItem StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddSubscriptionProductsToBasketRequestItem
 * @subpackage Structs
 */
class AddSubscriptionProductsToBasketRequestItem extends AbstractStructBase
{
    /**
     * The IsOptional
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsOptional;
    /**
     * The ItemDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Ticketing_AddSubscriptionToBasketRequest
     */
    public $ItemDetails;
    /**
     * The ReferenceId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenceId;
    /**
     * Constructor method for AddSubscriptionProductsToBasketRequestItem
     * @uses AddSubscriptionProductsToBasketRequestItem::setIsOptional()
     * @uses AddSubscriptionProductsToBasketRequestItem::setItemDetails()
     * @uses AddSubscriptionProductsToBasketRequestItem::setReferenceId()
     * @param bool $isOptional
     * @param \patest\StructType\Ticketing_AddSubscriptionToBasketRequest $itemDetails
     * @param string $referenceId
     */
    public function __construct($isOptional = null, \patest\StructType\Ticketing_AddSubscriptionToBasketRequest $itemDetails = null, $referenceId = null)
    {
        $this
            ->setIsOptional($isOptional)
            ->setItemDetails($itemDetails)
            ->setReferenceId($referenceId);
    }
    /**
     * Get IsOptional value
     * @return bool|null
     */
    public function getIsOptional()
    {
        return $this->IsOptional;
    }
    /**
     * Set IsOptional value
     * @param bool $isOptional
     * @return \patest\StructType\AddSubscriptionProductsToBasketRequestItem
     */
    public function setIsOptional($isOptional = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOptional) && !is_bool($isOptional)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOptional, true), gettype($isOptional)), __LINE__);
        }
        $this->IsOptional = $isOptional;
        return $this;
    }
    /**
     * Get ItemDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Ticketing_AddSubscriptionToBasketRequest|null
     */
    public function getItemDetails()
    {
        return isset($this->ItemDetails) ? $this->ItemDetails : null;
    }
    /**
     * Set ItemDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Ticketing_AddSubscriptionToBasketRequest $itemDetails
     * @return \patest\StructType\AddSubscriptionProductsToBasketRequestItem
     */
    public function setItemDetails(\patest\StructType\Ticketing_AddSubscriptionToBasketRequest $itemDetails = null)
    {
        if (is_null($itemDetails) || (is_array($itemDetails) && empty($itemDetails))) {
            unset($this->ItemDetails);
        } else {
            $this->ItemDetails = $itemDetails;
        }
        return $this;
    }
    /**
     * Get ReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenceId()
    {
        return isset($this->ReferenceId) ? $this->ReferenceId : null;
    }
    /**
     * Set ReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenceId
     * @return \patest\StructType\AddSubscriptionProductsToBasketRequestItem
     */
    public function setReferenceId($referenceId = null)
    {
        // validation for constraint: string
        if (!is_null($referenceId) && !is_string($referenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($referenceId, true), gettype($referenceId)), __LINE__);
        }
        if (is_null($referenceId) || (is_array($referenceId) && empty($referenceId))) {
            unset($this->ReferenceId);
        } else {
            $this->ReferenceId = $referenceId;
        }
        return $this;
    }
}
