<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AddEventToTicketScheme-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:AddEventToTicketScheme-Request
 * @subpackage Structs
 */
class AddEventToTicketScheme_Request extends ExtensibleDataContract
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $EventIds;
    /**
     * The IsLoadTicketsToAccessCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsLoadTicketsToAccessCard;
    /**
     * The IsReserveOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsReserveOnly;
    /**
     * The IsVerificationOnly
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsVerificationOnly;
    /**
     * The MaxTicketsToFulfill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTicketsToFulfill;
    /**
     * The TicketSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSchemeId;
    /**
     * The VerifyPayments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VerifyPayments;
    /**
     * The SpecificEnrollment
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SpecificEnrollment;
    /**
     * The BypassBuyAllSector
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $BypassBuyAllSector;
    /**
     * Constructor method for AddEventToTicketScheme-Request
     * @uses AddEventToTicketScheme_Request::setEventId()
     * @uses AddEventToTicketScheme_Request::setEventIds()
     * @uses AddEventToTicketScheme_Request::setIsLoadTicketsToAccessCard()
     * @uses AddEventToTicketScheme_Request::setIsReserveOnly()
     * @uses AddEventToTicketScheme_Request::setIsVerificationOnly()
     * @uses AddEventToTicketScheme_Request::setMaxTicketsToFulfill()
     * @uses AddEventToTicketScheme_Request::setTicketSchemeId()
     * @uses AddEventToTicketScheme_Request::setVerifyPayments()
     * @uses AddEventToTicketScheme_Request::setSpecificEnrollment()
     * @uses AddEventToTicketScheme_Request::setBypassBuyAllSector()
     * @param string $eventId
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @param bool $isLoadTicketsToAccessCard
     * @param bool $isReserveOnly
     * @param bool $isVerificationOnly
     * @param int $maxTicketsToFulfill
     * @param string $ticketSchemeId
     * @param bool $verifyPayments
     * @param string $specificEnrollment
     * @param bool $bypassBuyAllSector
     */
    public function __construct($eventId = null, \patest\ArrayType\ArrayOfguid $eventIds = null, $isLoadTicketsToAccessCard = null, $isReserveOnly = null, $isVerificationOnly = null, $maxTicketsToFulfill = null, $ticketSchemeId = null, $verifyPayments = null, $specificEnrollment = null, $bypassBuyAllSector = null)
    {
        $this
            ->setEventId($eventId)
            ->setEventIds($eventIds)
            ->setIsLoadTicketsToAccessCard($isLoadTicketsToAccessCard)
            ->setIsReserveOnly($isReserveOnly)
            ->setIsVerificationOnly($isVerificationOnly)
            ->setMaxTicketsToFulfill($maxTicketsToFulfill)
            ->setTicketSchemeId($ticketSchemeId)
            ->setVerifyPayments($verifyPayments)
            ->setSpecificEnrollment($specificEnrollment)
            ->setBypassBuyAllSector($bypassBuyAllSector);
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\AddEventToTicketScheme_Request
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $eventIds
     * @return \patest\StructType\AddEventToTicketScheme_Request
     */
    public function setEventIds(\patest\ArrayType\ArrayOfguid $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get IsLoadTicketsToAccessCard value
     * @return bool|null
     */
    public function getIsLoadTicketsToAccessCard()
    {
        return $this->IsLoadTicketsToAccessCard;
    }
    /**
     * Set IsLoadTicketsToAccessCard value
     * @param bool $isLoadTicketsToAccessCard
     * @return \patest\StructType\AddEventToTicketScheme_Request
     */
    public function setIsLoadTicketsToAccessCard($isLoadTicketsToAccessCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLoadTicketsToAccessCard) && !is_bool($isLoadTicketsToAccessCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLoadTicketsToAccessCard, true), gettype($isLoadTicketsToAccessCard)), __LINE__);
        }
        $this->IsLoadTicketsToAccessCard = $isLoadTicketsToAccessCard;
        return $this;
    }
    /**
     * Get IsReserveOnly value
     * @return bool|null
     */
    public function getIsReserveOnly()
    {
        return $this->IsReserveOnly;
    }
    /**
     * Set IsReserveOnly value
     * @param bool $isReserveOnly
     * @return \patest\StructType\AddEventToTicketScheme_Request
     */
    public function setIsReserveOnly($isReserveOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReserveOnly) && !is_bool($isReserveOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReserveOnly, true), gettype($isReserveOnly)), __LINE__);
        }
        $this->IsReserveOnly = $isReserveOnly;
        return $this;
    }
    /**
     * Get IsVerificationOnly value
     * @return bool|null
     */
    public function getIsVerificationOnly()
    {
        return $this->IsVerificationOnly;
    }
    /**
     * Set IsVerificationOnly value
     * @param bool $isVerificationOnly
     * @return \patest\StructType\AddEventToTicketScheme_Request
     */
    public function setIsVerificationOnly($isVerificationOnly = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVerificationOnly) && !is_bool($isVerificationOnly)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVerificationOnly, true), gettype($isVerificationOnly)), __LINE__);
        }
        $this->IsVerificationOnly = $isVerificationOnly;
        return $this;
    }
    /**
     * Get MaxTicketsToFulfill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTicketsToFulfill()
    {
        return isset($this->MaxTicketsToFulfill) ? $this->MaxTicketsToFulfill : null;
    }
    /**
     * Set MaxTicketsToFulfill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTicketsToFulfill
     * @return \patest\StructType\AddEventToTicketScheme_Request
     */
    public function setMaxTicketsToFulfill($maxTicketsToFulfill = null)
    {
        // validation for constraint: int
        if (!is_null($maxTicketsToFulfill) && !(is_int($maxTicketsToFulfill) || ctype_digit($maxTicketsToFulfill))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTicketsToFulfill, true), gettype($maxTicketsToFulfill)), __LINE__);
        }
        if (is_null($maxTicketsToFulfill) || (is_array($maxTicketsToFulfill) && empty($maxTicketsToFulfill))) {
            unset($this->MaxTicketsToFulfill);
        } else {
            $this->MaxTicketsToFulfill = $maxTicketsToFulfill;
        }
        return $this;
    }
    /**
     * Get TicketSchemeId value
     * @return string|null
     */
    public function getTicketSchemeId()
    {
        return $this->TicketSchemeId;
    }
    /**
     * Set TicketSchemeId value
     * @param string $ticketSchemeId
     * @return \patest\StructType\AddEventToTicketScheme_Request
     */
    public function setTicketSchemeId($ticketSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeId) && !is_string($ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeId, true), gettype($ticketSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSchemeId, true)), __LINE__);
        }
        $this->TicketSchemeId = $ticketSchemeId;
        return $this;
    }
    /**
     * Get VerifyPayments value
     * @return bool|null
     */
    public function getVerifyPayments()
    {
        return $this->VerifyPayments;
    }
    /**
     * Set VerifyPayments value
     * @param bool $verifyPayments
     * @return \patest\StructType\AddEventToTicketScheme_Request
     */
    public function setVerifyPayments($verifyPayments = null)
    {
        // validation for constraint: boolean
        if (!is_null($verifyPayments) && !is_bool($verifyPayments)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verifyPayments, true), gettype($verifyPayments)), __LINE__);
        }
        $this->VerifyPayments = $verifyPayments;
        return $this;
    }
    /**
     * Get SpecificEnrollment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSpecificEnrollment()
    {
        return isset($this->SpecificEnrollment) ? $this->SpecificEnrollment : null;
    }
    /**
     * Set SpecificEnrollment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $specificEnrollment
     * @return \patest\StructType\AddEventToTicketScheme_Request
     */
    public function setSpecificEnrollment($specificEnrollment = null)
    {
        // validation for constraint: string
        if (!is_null($specificEnrollment) && !is_string($specificEnrollment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specificEnrollment, true), gettype($specificEnrollment)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($specificEnrollment) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $specificEnrollment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($specificEnrollment, true)), __LINE__);
        }
        if (is_null($specificEnrollment) || (is_array($specificEnrollment) && empty($specificEnrollment))) {
            unset($this->SpecificEnrollment);
        } else {
            $this->SpecificEnrollment = $specificEnrollment;
        }
        return $this;
    }
    /**
     * Get BypassBuyAllSector value
     * @return bool|null
     */
    public function getBypassBuyAllSector()
    {
        return $this->BypassBuyAllSector;
    }
    /**
     * Set BypassBuyAllSector value
     * @param bool $bypassBuyAllSector
     * @return \patest\StructType\AddEventToTicketScheme_Request
     */
    public function setBypassBuyAllSector($bypassBuyAllSector = null)
    {
        // validation for constraint: boolean
        if (!is_null($bypassBuyAllSector) && !is_bool($bypassBuyAllSector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bypassBuyAllSector, true), gettype($bypassBuyAllSector)), __LINE__);
        }
        $this->BypassBuyAllSector = $bypassBuyAllSector;
        return $this;
    }
}
