<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.SoldTicketInfo StructType
 * @subpackage Structs
 */
class AccessControl_SoldTicketInfo extends AccessControl_SoldItemInfo
{
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The KeepLoadedOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepLoadedOnCard;
    /**
     * The LoadedOnCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LoadedOnCard;
    /**
     * The SubscriptionId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionId;
    /**
     * The SubstitutedTicketClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubstitutedTicketClientId;
    /**
     * The SubstitutedTicketEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubstitutedTicketEventId;
    /**
     * The SubstitutedTicketPrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubstitutedTicketPrintCount;
    /**
     * The UnloadedFromCard
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UnloadedFromCard;
    /**
     * Constructor method for AccessControl.SoldTicketInfo
     * @uses AccessControl_SoldTicketInfo::setEventId()
     * @uses AccessControl_SoldTicketInfo::setKeepLoadedOnCard()
     * @uses AccessControl_SoldTicketInfo::setLoadedOnCard()
     * @uses AccessControl_SoldTicketInfo::setSubscriptionId()
     * @uses AccessControl_SoldTicketInfo::setSubstitutedTicketClientId()
     * @uses AccessControl_SoldTicketInfo::setSubstitutedTicketEventId()
     * @uses AccessControl_SoldTicketInfo::setSubstitutedTicketPrintCount()
     * @uses AccessControl_SoldTicketInfo::setUnloadedFromCard()
     * @param string $eventId
     * @param bool $keepLoadedOnCard
     * @param bool $loadedOnCard
     * @param string $subscriptionId
     * @param string $substitutedTicketClientId
     * @param string $substitutedTicketEventId
     * @param int $substitutedTicketPrintCount
     * @param bool $unloadedFromCard
     */
    public function __construct($eventId = null, $keepLoadedOnCard = null, $loadedOnCard = null, $subscriptionId = null, $substitutedTicketClientId = null, $substitutedTicketEventId = null, $substitutedTicketPrintCount = null, $unloadedFromCard = null)
    {
        $this
            ->setEventId($eventId)
            ->setKeepLoadedOnCard($keepLoadedOnCard)
            ->setLoadedOnCard($loadedOnCard)
            ->setSubscriptionId($subscriptionId)
            ->setSubstitutedTicketClientId($substitutedTicketClientId)
            ->setSubstitutedTicketEventId($substitutedTicketEventId)
            ->setSubstitutedTicketPrintCount($substitutedTicketPrintCount)
            ->setUnloadedFromCard($unloadedFromCard);
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\AccessControl_SoldTicketInfo
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get KeepLoadedOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepLoadedOnCard()
    {
        return isset($this->KeepLoadedOnCard) ? $this->KeepLoadedOnCard : null;
    }
    /**
     * Set KeepLoadedOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepLoadedOnCard
     * @return \patest\StructType\AccessControl_SoldTicketInfo
     */
    public function setKeepLoadedOnCard($keepLoadedOnCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepLoadedOnCard) && !is_bool($keepLoadedOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepLoadedOnCard, true), gettype($keepLoadedOnCard)), __LINE__);
        }
        if (is_null($keepLoadedOnCard) || (is_array($keepLoadedOnCard) && empty($keepLoadedOnCard))) {
            unset($this->KeepLoadedOnCard);
        } else {
            $this->KeepLoadedOnCard = $keepLoadedOnCard;
        }
        return $this;
    }
    /**
     * Get LoadedOnCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLoadedOnCard()
    {
        return isset($this->LoadedOnCard) ? $this->LoadedOnCard : null;
    }
    /**
     * Set LoadedOnCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $loadedOnCard
     * @return \patest\StructType\AccessControl_SoldTicketInfo
     */
    public function setLoadedOnCard($loadedOnCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($loadedOnCard) && !is_bool($loadedOnCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($loadedOnCard, true), gettype($loadedOnCard)), __LINE__);
        }
        if (is_null($loadedOnCard) || (is_array($loadedOnCard) && empty($loadedOnCard))) {
            unset($this->LoadedOnCard);
        } else {
            $this->LoadedOnCard = $loadedOnCard;
        }
        return $this;
    }
    /**
     * Get SubscriptionId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionId()
    {
        return isset($this->SubscriptionId) ? $this->SubscriptionId : null;
    }
    /**
     * Set SubscriptionId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionId
     * @return \patest\StructType\AccessControl_SoldTicketInfo
     */
    public function setSubscriptionId($subscriptionId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionId) && !is_string($subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionId, true), gettype($subscriptionId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionId, true)), __LINE__);
        }
        if (is_null($subscriptionId) || (is_array($subscriptionId) && empty($subscriptionId))) {
            unset($this->SubscriptionId);
        } else {
            $this->SubscriptionId = $subscriptionId;
        }
        return $this;
    }
    /**
     * Get SubstitutedTicketClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubstitutedTicketClientId()
    {
        return isset($this->SubstitutedTicketClientId) ? $this->SubstitutedTicketClientId : null;
    }
    /**
     * Set SubstitutedTicketClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $substitutedTicketClientId
     * @return \patest\StructType\AccessControl_SoldTicketInfo
     */
    public function setSubstitutedTicketClientId($substitutedTicketClientId = null)
    {
        // validation for constraint: string
        if (!is_null($substitutedTicketClientId) && !is_string($substitutedTicketClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($substitutedTicketClientId, true), gettype($substitutedTicketClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($substitutedTicketClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $substitutedTicketClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($substitutedTicketClientId, true)), __LINE__);
        }
        if (is_null($substitutedTicketClientId) || (is_array($substitutedTicketClientId) && empty($substitutedTicketClientId))) {
            unset($this->SubstitutedTicketClientId);
        } else {
            $this->SubstitutedTicketClientId = $substitutedTicketClientId;
        }
        return $this;
    }
    /**
     * Get SubstitutedTicketEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubstitutedTicketEventId()
    {
        return isset($this->SubstitutedTicketEventId) ? $this->SubstitutedTicketEventId : null;
    }
    /**
     * Set SubstitutedTicketEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $substitutedTicketEventId
     * @return \patest\StructType\AccessControl_SoldTicketInfo
     */
    public function setSubstitutedTicketEventId($substitutedTicketEventId = null)
    {
        // validation for constraint: string
        if (!is_null($substitutedTicketEventId) && !is_string($substitutedTicketEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($substitutedTicketEventId, true), gettype($substitutedTicketEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($substitutedTicketEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $substitutedTicketEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($substitutedTicketEventId, true)), __LINE__);
        }
        if (is_null($substitutedTicketEventId) || (is_array($substitutedTicketEventId) && empty($substitutedTicketEventId))) {
            unset($this->SubstitutedTicketEventId);
        } else {
            $this->SubstitutedTicketEventId = $substitutedTicketEventId;
        }
        return $this;
    }
    /**
     * Get SubstitutedTicketPrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubstitutedTicketPrintCount()
    {
        return isset($this->SubstitutedTicketPrintCount) ? $this->SubstitutedTicketPrintCount : null;
    }
    /**
     * Set SubstitutedTicketPrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $substitutedTicketPrintCount
     * @return \patest\StructType\AccessControl_SoldTicketInfo
     */
    public function setSubstitutedTicketPrintCount($substitutedTicketPrintCount = null)
    {
        // validation for constraint: int
        if (!is_null($substitutedTicketPrintCount) && !(is_int($substitutedTicketPrintCount) || ctype_digit($substitutedTicketPrintCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($substitutedTicketPrintCount, true), gettype($substitutedTicketPrintCount)), __LINE__);
        }
        if (is_null($substitutedTicketPrintCount) || (is_array($substitutedTicketPrintCount) && empty($substitutedTicketPrintCount))) {
            unset($this->SubstitutedTicketPrintCount);
        } else {
            $this->SubstitutedTicketPrintCount = $substitutedTicketPrintCount;
        }
        return $this;
    }
    /**
     * Get UnloadedFromCard value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUnloadedFromCard()
    {
        return isset($this->UnloadedFromCard) ? $this->UnloadedFromCard : null;
    }
    /**
     * Set UnloadedFromCard value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $unloadedFromCard
     * @return \patest\StructType\AccessControl_SoldTicketInfo
     */
    public function setUnloadedFromCard($unloadedFromCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($unloadedFromCard) && !is_bool($unloadedFromCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unloadedFromCard, true), gettype($unloadedFromCard)), __LINE__);
        }
        if (is_null($unloadedFromCard) || (is_array($unloadedFromCard) && empty($unloadedFromCard))) {
            unset($this->UnloadedFromCard);
        } else {
            $this->UnloadedFromCard = $unloadedFromCard;
        }
        return $this;
    }
}
