<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.SoldItemInfo StructType
 * @subpackage Structs
 */
class AccessControl_SoldItemInfo extends AnyEntity
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DoNotPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoNotPrint;
    /**
     * The EntityAccessControlDataReferenceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityAccessControlDataReferenceId;
    /**
     * The IsExchangeable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsExchangeable;
    /**
     * The IsPostScanUpgrade
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPostScanUpgrade;
    /**
     * The ItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ItemId;
    /**
     * The ItemType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemType;
    /**
     * The KeepOriginalBarcode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepOriginalBarcode;
    /**
     * The PrintCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintCount;
    /**
     * The RequestedAction
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestedAction;
    /**
     * The UpdateOfItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UpdateOfItemId;
    /**
     * Constructor method for AccessControl.SoldItemInfo
     * @uses AccessControl_SoldItemInfo::setClientId()
     * @uses AccessControl_SoldItemInfo::setDoNotPrint()
     * @uses AccessControl_SoldItemInfo::setEntityAccessControlDataReferenceId()
     * @uses AccessControl_SoldItemInfo::setIsExchangeable()
     * @uses AccessControl_SoldItemInfo::setIsPostScanUpgrade()
     * @uses AccessControl_SoldItemInfo::setItemId()
     * @uses AccessControl_SoldItemInfo::setItemType()
     * @uses AccessControl_SoldItemInfo::setKeepOriginalBarcode()
     * @uses AccessControl_SoldItemInfo::setPrintCount()
     * @uses AccessControl_SoldItemInfo::setRequestedAction()
     * @uses AccessControl_SoldItemInfo::setUpdateOfItemId()
     * @param string $clientId
     * @param bool $doNotPrint
     * @param string $entityAccessControlDataReferenceId
     * @param bool $isExchangeable
     * @param bool $isPostScanUpgrade
     * @param string $itemId
     * @param int $itemType
     * @param bool $keepOriginalBarcode
     * @param int $printCount
     * @param string $requestedAction
     * @param string $updateOfItemId
     */
    public function __construct($clientId = null, $doNotPrint = null, $entityAccessControlDataReferenceId = null, $isExchangeable = null, $isPostScanUpgrade = null, $itemId = null, $itemType = null, $keepOriginalBarcode = null, $printCount = null, $requestedAction = null, $updateOfItemId = null)
    {
        $this
            ->setClientId($clientId)
            ->setDoNotPrint($doNotPrint)
            ->setEntityAccessControlDataReferenceId($entityAccessControlDataReferenceId)
            ->setIsExchangeable($isExchangeable)
            ->setIsPostScanUpgrade($isPostScanUpgrade)
            ->setItemId($itemId)
            ->setItemType($itemType)
            ->setKeepOriginalBarcode($keepOriginalBarcode)
            ->setPrintCount($printCount)
            ->setRequestedAction($requestedAction)
            ->setUpdateOfItemId($updateOfItemId);
    }
    /**
     * Get ClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientId()
    {
        return isset($this->ClientId) ? $this->ClientId : null;
    }
    /**
     * Set ClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientId
     * @return \patest\StructType\AccessControl_SoldItemInfo
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        if (is_null($clientId) || (is_array($clientId) && empty($clientId))) {
            unset($this->ClientId);
        } else {
            $this->ClientId = $clientId;
        }
        return $this;
    }
    /**
     * Get DoNotPrint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoNotPrint()
    {
        return isset($this->DoNotPrint) ? $this->DoNotPrint : null;
    }
    /**
     * Set DoNotPrint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doNotPrint
     * @return \patest\StructType\AccessControl_SoldItemInfo
     */
    public function setDoNotPrint($doNotPrint = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotPrint) && !is_bool($doNotPrint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotPrint, true), gettype($doNotPrint)), __LINE__);
        }
        if (is_null($doNotPrint) || (is_array($doNotPrint) && empty($doNotPrint))) {
            unset($this->DoNotPrint);
        } else {
            $this->DoNotPrint = $doNotPrint;
        }
        return $this;
    }
    /**
     * Get EntityAccessControlDataReferenceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityAccessControlDataReferenceId()
    {
        return isset($this->EntityAccessControlDataReferenceId) ? $this->EntityAccessControlDataReferenceId : null;
    }
    /**
     * Set EntityAccessControlDataReferenceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityAccessControlDataReferenceId
     * @return \patest\StructType\AccessControl_SoldItemInfo
     */
    public function setEntityAccessControlDataReferenceId($entityAccessControlDataReferenceId = null)
    {
        // validation for constraint: string
        if (!is_null($entityAccessControlDataReferenceId) && !is_string($entityAccessControlDataReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityAccessControlDataReferenceId, true), gettype($entityAccessControlDataReferenceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityAccessControlDataReferenceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityAccessControlDataReferenceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityAccessControlDataReferenceId, true)), __LINE__);
        }
        if (is_null($entityAccessControlDataReferenceId) || (is_array($entityAccessControlDataReferenceId) && empty($entityAccessControlDataReferenceId))) {
            unset($this->EntityAccessControlDataReferenceId);
        } else {
            $this->EntityAccessControlDataReferenceId = $entityAccessControlDataReferenceId;
        }
        return $this;
    }
    /**
     * Get IsExchangeable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsExchangeable()
    {
        return isset($this->IsExchangeable) ? $this->IsExchangeable : null;
    }
    /**
     * Set IsExchangeable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isExchangeable
     * @return \patest\StructType\AccessControl_SoldItemInfo
     */
    public function setIsExchangeable($isExchangeable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExchangeable) && !is_bool($isExchangeable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExchangeable, true), gettype($isExchangeable)), __LINE__);
        }
        if (is_null($isExchangeable) || (is_array($isExchangeable) && empty($isExchangeable))) {
            unset($this->IsExchangeable);
        } else {
            $this->IsExchangeable = $isExchangeable;
        }
        return $this;
    }
    /**
     * Get IsPostScanUpgrade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPostScanUpgrade()
    {
        return isset($this->IsPostScanUpgrade) ? $this->IsPostScanUpgrade : null;
    }
    /**
     * Set IsPostScanUpgrade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPostScanUpgrade
     * @return \patest\StructType\AccessControl_SoldItemInfo
     */
    public function setIsPostScanUpgrade($isPostScanUpgrade = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPostScanUpgrade) && !is_bool($isPostScanUpgrade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPostScanUpgrade, true), gettype($isPostScanUpgrade)), __LINE__);
        }
        if (is_null($isPostScanUpgrade) || (is_array($isPostScanUpgrade) && empty($isPostScanUpgrade))) {
            unset($this->IsPostScanUpgrade);
        } else {
            $this->IsPostScanUpgrade = $isPostScanUpgrade;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemId
     * @return \patest\StructType\AccessControl_SoldItemInfo
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: string
        if (!is_null($itemId) && !is_string($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemId, true), gettype($itemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($itemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($itemId, true)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get ItemType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemType()
    {
        return isset($this->ItemType) ? $this->ItemType : null;
    }
    /**
     * Set ItemType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemType
     * @return \patest\StructType\AccessControl_SoldItemInfo
     */
    public function setItemType($itemType = null)
    {
        // validation for constraint: int
        if (!is_null($itemType) && !(is_int($itemType) || ctype_digit($itemType))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemType, true), gettype($itemType)), __LINE__);
        }
        if (is_null($itemType) || (is_array($itemType) && empty($itemType))) {
            unset($this->ItemType);
        } else {
            $this->ItemType = $itemType;
        }
        return $this;
    }
    /**
     * Get KeepOriginalBarcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepOriginalBarcode()
    {
        return isset($this->KeepOriginalBarcode) ? $this->KeepOriginalBarcode : null;
    }
    /**
     * Set KeepOriginalBarcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepOriginalBarcode
     * @return \patest\StructType\AccessControl_SoldItemInfo
     */
    public function setKeepOriginalBarcode($keepOriginalBarcode = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepOriginalBarcode) && !is_bool($keepOriginalBarcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepOriginalBarcode, true), gettype($keepOriginalBarcode)), __LINE__);
        }
        if (is_null($keepOriginalBarcode) || (is_array($keepOriginalBarcode) && empty($keepOriginalBarcode))) {
            unset($this->KeepOriginalBarcode);
        } else {
            $this->KeepOriginalBarcode = $keepOriginalBarcode;
        }
        return $this;
    }
    /**
     * Get PrintCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintCount()
    {
        return isset($this->PrintCount) ? $this->PrintCount : null;
    }
    /**
     * Set PrintCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printCount
     * @return \patest\StructType\AccessControl_SoldItemInfo
     */
    public function setPrintCount($printCount = null)
    {
        // validation for constraint: int
        if (!is_null($printCount) && !(is_int($printCount) || ctype_digit($printCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printCount, true), gettype($printCount)), __LINE__);
        }
        if (is_null($printCount) || (is_array($printCount) && empty($printCount))) {
            unset($this->PrintCount);
        } else {
            $this->PrintCount = $printCount;
        }
        return $this;
    }
    /**
     * Get RequestedAction value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestedAction()
    {
        return isset($this->RequestedAction) ? $this->RequestedAction : null;
    }
    /**
     * Set RequestedAction value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ItemRequestedAction::valueIsValid()
     * @uses \patest\EnumType\ItemRequestedAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $requestedAction
     * @return \patest\StructType\AccessControl_SoldItemInfo
     */
    public function setRequestedAction($requestedAction = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ItemRequestedAction::valueIsValid($requestedAction)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ItemRequestedAction', is_array($requestedAction) ? implode(', ', $requestedAction) : var_export($requestedAction, true), implode(', ', \patest\EnumType\ItemRequestedAction::getValidValues())), __LINE__);
        }
        if (is_null($requestedAction) || (is_array($requestedAction) && empty($requestedAction))) {
            unset($this->RequestedAction);
        } else {
            $this->RequestedAction = $requestedAction;
        }
        return $this;
    }
    /**
     * Get UpdateOfItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUpdateOfItemId()
    {
        return isset($this->UpdateOfItemId) ? $this->UpdateOfItemId : null;
    }
    /**
     * Set UpdateOfItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $updateOfItemId
     * @return \patest\StructType\AccessControl_SoldItemInfo
     */
    public function setUpdateOfItemId($updateOfItemId = null)
    {
        // validation for constraint: string
        if (!is_null($updateOfItemId) && !is_string($updateOfItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($updateOfItemId, true), gettype($updateOfItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($updateOfItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $updateOfItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($updateOfItemId, true)), __LINE__);
        }
        if (is_null($updateOfItemId) || (is_array($updateOfItemId) && empty($updateOfItemId))) {
            unset($this->UpdateOfItemId);
        } else {
            $this->UpdateOfItemId = $updateOfItemId;
        }
        return $this;
    }
}
