<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ShowTimeTurnstileData StructType
 * @subpackage Structs
 */
class AccessControl_ShowTimeTurnstileData extends AccessControl_ShowTimeEntityData
{
    /**
     * The AreaIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\AreaIds
     */
    public $AreaIds;
    /**
     * The HallId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $HallId;
    /**
     * The IsOuterEntrance
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsOuterEntrance;
    /**
     * The PriceLevelIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceLevelIds
     */
    public $PriceLevelIds;
    /**
     * The PriceTypeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\PriceTypeIds
     */
    public $PriceTypeIds;
    /**
     * Constructor method for AccessControl.ShowTimeTurnstileData
     * @uses AccessControl_ShowTimeTurnstileData::setAreaIds()
     * @uses AccessControl_ShowTimeTurnstileData::setHallId()
     * @uses AccessControl_ShowTimeTurnstileData::setIsOuterEntrance()
     * @uses AccessControl_ShowTimeTurnstileData::setPriceLevelIds()
     * @uses AccessControl_ShowTimeTurnstileData::setPriceTypeIds()
     * @param \patest\StructType\AreaIds $areaIds
     * @param string $hallId
     * @param bool $isOuterEntrance
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     */
    public function __construct(\patest\StructType\AreaIds $areaIds = null, $hallId = null, $isOuterEntrance = null, \patest\StructType\PriceLevelIds $priceLevelIds = null, \patest\StructType\PriceTypeIds $priceTypeIds = null)
    {
        $this
            ->setAreaIds($areaIds)
            ->setHallId($hallId)
            ->setIsOuterEntrance($isOuterEntrance)
            ->setPriceLevelIds($priceLevelIds)
            ->setPriceTypeIds($priceTypeIds);
    }
    /**
     * Get AreaIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\AreaIds|null
     */
    public function getAreaIds()
    {
        return isset($this->AreaIds) ? $this->AreaIds : null;
    }
    /**
     * Set AreaIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\AreaIds $areaIds
     * @return \patest\StructType\AccessControl_ShowTimeTurnstileData
     */
    public function setAreaIds(\patest\StructType\AreaIds $areaIds = null)
    {
        if (is_null($areaIds) || (is_array($areaIds) && empty($areaIds))) {
            unset($this->AreaIds);
        } else {
            $this->AreaIds = $areaIds;
        }
        return $this;
    }
    /**
     * Get HallId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHallId()
    {
        return isset($this->HallId) ? $this->HallId : null;
    }
    /**
     * Set HallId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hallId
     * @return \patest\StructType\AccessControl_ShowTimeTurnstileData
     */
    public function setHallId($hallId = null)
    {
        // validation for constraint: string
        if (!is_null($hallId) && !is_string($hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hallId, true), gettype($hallId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($hallId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $hallId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($hallId, true)), __LINE__);
        }
        if (is_null($hallId) || (is_array($hallId) && empty($hallId))) {
            unset($this->HallId);
        } else {
            $this->HallId = $hallId;
        }
        return $this;
    }
    /**
     * Get IsOuterEntrance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsOuterEntrance()
    {
        return isset($this->IsOuterEntrance) ? $this->IsOuterEntrance : null;
    }
    /**
     * Set IsOuterEntrance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isOuterEntrance
     * @return \patest\StructType\AccessControl_ShowTimeTurnstileData
     */
    public function setIsOuterEntrance($isOuterEntrance = null)
    {
        // validation for constraint: boolean
        if (!is_null($isOuterEntrance) && !is_bool($isOuterEntrance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isOuterEntrance, true), gettype($isOuterEntrance)), __LINE__);
        }
        if (is_null($isOuterEntrance) || (is_array($isOuterEntrance) && empty($isOuterEntrance))) {
            unset($this->IsOuterEntrance);
        } else {
            $this->IsOuterEntrance = $isOuterEntrance;
        }
        return $this;
    }
    /**
     * Get PriceLevelIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceLevelIds|null
     */
    public function getPriceLevelIds()
    {
        return isset($this->PriceLevelIds) ? $this->PriceLevelIds : null;
    }
    /**
     * Set PriceLevelIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceLevelIds $priceLevelIds
     * @return \patest\StructType\AccessControl_ShowTimeTurnstileData
     */
    public function setPriceLevelIds(\patest\StructType\PriceLevelIds $priceLevelIds = null)
    {
        if (is_null($priceLevelIds) || (is_array($priceLevelIds) && empty($priceLevelIds))) {
            unset($this->PriceLevelIds);
        } else {
            $this->PriceLevelIds = $priceLevelIds;
        }
        return $this;
    }
    /**
     * Get PriceTypeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\PriceTypeIds|null
     */
    public function getPriceTypeIds()
    {
        return isset($this->PriceTypeIds) ? $this->PriceTypeIds : null;
    }
    /**
     * Set PriceTypeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\PriceTypeIds $priceTypeIds
     * @return \patest\StructType\AccessControl_ShowTimeTurnstileData
     */
    public function setPriceTypeIds(\patest\StructType\PriceTypeIds $priceTypeIds = null)
    {
        if (is_null($priceTypeIds) || (is_array($priceTypeIds) && empty($priceTypeIds))) {
            unset($this->PriceTypeIds);
        } else {
            $this->PriceTypeIds = $priceTypeIds;
        }
        return $this;
    }
}
