<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ScanIngestionApiRequest StructType
 * @subpackage Structs
 */
class AccessControl_ScanIngestionApiRequest extends AccessControl_AuthorizedHttpApiRequest
{
    /**
     * The Count
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Count;
    /**
     * The FailedCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FailedCount;
    /**
     * Constructor method for AccessControl.ScanIngestionApiRequest
     * @uses AccessControl_ScanIngestionApiRequest::setCount()
     * @uses AccessControl_ScanIngestionApiRequest::setFailedCount()
     * @param int $count
     * @param int $failedCount
     */
    public function __construct($count = null, $failedCount = null)
    {
        $this
            ->setCount($count)
            ->setFailedCount($failedCount);
    }
    /**
     * Get Count value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCount()
    {
        return isset($this->Count) ? $this->Count : null;
    }
    /**
     * Set Count value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $count
     * @return \patest\StructType\AccessControl_ScanIngestionApiRequest
     */
    public function setCount($count = null)
    {
        // validation for constraint: int
        if (!is_null($count) && !(is_int($count) || ctype_digit($count))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($count, true), gettype($count)), __LINE__);
        }
        if (is_null($count) || (is_array($count) && empty($count))) {
            unset($this->Count);
        } else {
            $this->Count = $count;
        }
        return $this;
    }
    /**
     * Get FailedCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFailedCount()
    {
        return isset($this->FailedCount) ? $this->FailedCount : null;
    }
    /**
     * Set FailedCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $failedCount
     * @return \patest\StructType\AccessControl_ScanIngestionApiRequest
     */
    public function setFailedCount($failedCount = null)
    {
        // validation for constraint: int
        if (!is_null($failedCount) && !(is_int($failedCount) || ctype_digit($failedCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($failedCount, true), gettype($failedCount)), __LINE__);
        }
        if (is_null($failedCount) || (is_array($failedCount) && empty($failedCount))) {
            unset($this->FailedCount);
        } else {
            $this->FailedCount = $failedCount;
        }
        return $this;
    }
}
