<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.SaleItemAccessCardInformation StructType
 * @subpackage Structs
 */
class AccessControl_SaleItemAccessCardInformation extends Sales_ItemInformation
{
    /**
     * The AccessCardId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AccessCardId;
    /**
     * The CollectionMethodId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CollectionMethodId;
    /**
     * The EntityId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EntityId;
    /**
     * The IsItemVaild
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - type: tns:AccessCardValidationState
     * @var string
     */
    public $IsItemVaild;
    /**
     * Constructor method for AccessControl.SaleItemAccessCardInformation
     * @uses AccessControl_SaleItemAccessCardInformation::setAccessCardId()
     * @uses AccessControl_SaleItemAccessCardInformation::setCollectionMethodId()
     * @uses AccessControl_SaleItemAccessCardInformation::setEntityId()
     * @uses AccessControl_SaleItemAccessCardInformation::setIsItemVaild()
     * @param string $accessCardId
     * @param string $collectionMethodId
     * @param string $entityId
     * @param string $isItemVaild
     */
    public function __construct($accessCardId = null, $collectionMethodId = null, $entityId = null, $isItemVaild = null)
    {
        $this
            ->setAccessCardId($accessCardId)
            ->setCollectionMethodId($collectionMethodId)
            ->setEntityId($entityId)
            ->setIsItemVaild($isItemVaild);
    }
    /**
     * Get AccessCardId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAccessCardId()
    {
        return isset($this->AccessCardId) ? $this->AccessCardId : null;
    }
    /**
     * Set AccessCardId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $accessCardId
     * @return \patest\StructType\AccessControl_SaleItemAccessCardInformation
     */
    public function setAccessCardId($accessCardId = null)
    {
        // validation for constraint: string
        if (!is_null($accessCardId) && !is_string($accessCardId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accessCardId, true), gettype($accessCardId)), __LINE__);
        }
        if (is_null($accessCardId) || (is_array($accessCardId) && empty($accessCardId))) {
            unset($this->AccessCardId);
        } else {
            $this->AccessCardId = $accessCardId;
        }
        return $this;
    }
    /**
     * Get CollectionMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCollectionMethodId()
    {
        return isset($this->CollectionMethodId) ? $this->CollectionMethodId : null;
    }
    /**
     * Set CollectionMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $collectionMethodId
     * @return \patest\StructType\AccessControl_SaleItemAccessCardInformation
     */
    public function setCollectionMethodId($collectionMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($collectionMethodId) && !is_string($collectionMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($collectionMethodId, true), gettype($collectionMethodId)), __LINE__);
        }
        if (is_null($collectionMethodId) || (is_array($collectionMethodId) && empty($collectionMethodId))) {
            unset($this->CollectionMethodId);
        } else {
            $this->CollectionMethodId = $collectionMethodId;
        }
        return $this;
    }
    /**
     * Get EntityId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityId()
    {
        return isset($this->EntityId) ? $this->EntityId : null;
    }
    /**
     * Set EntityId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityId
     * @return \patest\StructType\AccessControl_SaleItemAccessCardInformation
     */
    public function setEntityId($entityId = null)
    {
        // validation for constraint: string
        if (!is_null($entityId) && !is_string($entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityId, true), gettype($entityId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($entityId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $entityId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($entityId, true)), __LINE__);
        }
        if (is_null($entityId) || (is_array($entityId) && empty($entityId))) {
            unset($this->EntityId);
        } else {
            $this->EntityId = $entityId;
        }
        return $this;
    }
    /**
     * Get IsItemVaild value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIsItemVaild()
    {
        return isset($this->IsItemVaild) ? $this->IsItemVaild : null;
    }
    /**
     * Set IsItemVaild value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $isItemVaild
     * @return \patest\StructType\AccessControl_SaleItemAccessCardInformation
     */
    public function setIsItemVaild($isItemVaild = null)
    {
        // validation for constraint: string
        if (!is_null($isItemVaild) && !is_string($isItemVaild)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($isItemVaild, true), gettype($isItemVaild)), __LINE__);
        }
        if (is_null($isItemVaild) || (is_array($isItemVaild) && empty($isItemVaild))) {
            unset($this->IsItemVaild);
        } else {
            $this->IsItemVaild = $isItemVaild;
        }
        return $this;
    }
}
