<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.HttpApiRequest StructType
 * @subpackage Structs
 */
class AccessControl_HttpApiRequest extends PersistableEntity
{
    /**
     * The Action
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Action;
    /**
     * The CreateDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreateDate;
    /**
     * The ErrorMessage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ErrorMessage;
    /**
     * The ProcessDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ProcessDate;
    /**
     * The RequestContent
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestContent;
    /**
     * The RequestDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestDate;
    /**
     * The RequestId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RequestId;
    /**
     * The State
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $State;
    /**
     * Constructor method for AccessControl.HttpApiRequest
     * @uses AccessControl_HttpApiRequest::setAction()
     * @uses AccessControl_HttpApiRequest::setCreateDate()
     * @uses AccessControl_HttpApiRequest::setErrorMessage()
     * @uses AccessControl_HttpApiRequest::setProcessDate()
     * @uses AccessControl_HttpApiRequest::setRequestContent()
     * @uses AccessControl_HttpApiRequest::setRequestDate()
     * @uses AccessControl_HttpApiRequest::setRequestId()
     * @uses AccessControl_HttpApiRequest::setState()
     * @param string $action
     * @param string $createDate
     * @param string $errorMessage
     * @param string $processDate
     * @param string $requestContent
     * @param string $requestDate
     * @param string $requestId
     * @param string $state
     */
    public function __construct($action = null, $createDate = null, $errorMessage = null, $processDate = null, $requestContent = null, $requestDate = null, $requestId = null, $state = null)
    {
        $this
            ->setAction($action)
            ->setCreateDate($createDate)
            ->setErrorMessage($errorMessage)
            ->setProcessDate($processDate)
            ->setRequestContent($requestContent)
            ->setRequestDate($requestDate)
            ->setRequestId($requestId)
            ->setState($state);
    }
    /**
     * Get Action value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAction()
    {
        return isset($this->Action) ? $this->Action : null;
    }
    /**
     * Set Action value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HttpApiRequestAction::valueIsValid()
     * @uses \patest\EnumType\HttpApiRequestAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $action
     * @return \patest\StructType\AccessControl_HttpApiRequest
     */
    public function setAction($action = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HttpApiRequestAction::valueIsValid($action)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HttpApiRequestAction', is_array($action) ? implode(', ', $action) : var_export($action, true), implode(', ', \patest\EnumType\HttpApiRequestAction::getValidValues())), __LINE__);
        }
        if (is_null($action) || (is_array($action) && empty($action))) {
            unset($this->Action);
        } else {
            $this->Action = $action;
        }
        return $this;
    }
    /**
     * Get CreateDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreateDate()
    {
        return isset($this->CreateDate) ? $this->CreateDate : null;
    }
    /**
     * Set CreateDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $createDate
     * @return \patest\StructType\AccessControl_HttpApiRequest
     */
    public function setCreateDate($createDate = null)
    {
        // validation for constraint: string
        if (!is_null($createDate) && !is_string($createDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($createDate, true), gettype($createDate)), __LINE__);
        }
        if (is_null($createDate) || (is_array($createDate) && empty($createDate))) {
            unset($this->CreateDate);
        } else {
            $this->CreateDate = $createDate;
        }
        return $this;
    }
    /**
     * Get ErrorMessage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getErrorMessage()
    {
        return isset($this->ErrorMessage) ? $this->ErrorMessage : null;
    }
    /**
     * Set ErrorMessage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $errorMessage
     * @return \patest\StructType\AccessControl_HttpApiRequest
     */
    public function setErrorMessage($errorMessage = null)
    {
        // validation for constraint: string
        if (!is_null($errorMessage) && !is_string($errorMessage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorMessage, true), gettype($errorMessage)), __LINE__);
        }
        if (is_null($errorMessage) || (is_array($errorMessage) && empty($errorMessage))) {
            unset($this->ErrorMessage);
        } else {
            $this->ErrorMessage = $errorMessage;
        }
        return $this;
    }
    /**
     * Get ProcessDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessDate()
    {
        return isset($this->ProcessDate) ? $this->ProcessDate : null;
    }
    /**
     * Set ProcessDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processDate
     * @return \patest\StructType\AccessControl_HttpApiRequest
     */
    public function setProcessDate($processDate = null)
    {
        // validation for constraint: string
        if (!is_null($processDate) && !is_string($processDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($processDate, true), gettype($processDate)), __LINE__);
        }
        if (is_null($processDate) || (is_array($processDate) && empty($processDate))) {
            unset($this->ProcessDate);
        } else {
            $this->ProcessDate = $processDate;
        }
        return $this;
    }
    /**
     * Get RequestContent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestContent()
    {
        return isset($this->RequestContent) ? $this->RequestContent : null;
    }
    /**
     * Set RequestContent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestContent
     * @return \patest\StructType\AccessControl_HttpApiRequest
     */
    public function setRequestContent($requestContent = null)
    {
        // validation for constraint: string
        if (!is_null($requestContent) && !is_string($requestContent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestContent, true), gettype($requestContent)), __LINE__);
        }
        if (is_null($requestContent) || (is_array($requestContent) && empty($requestContent))) {
            unset($this->RequestContent);
        } else {
            $this->RequestContent = $requestContent;
        }
        return $this;
    }
    /**
     * Get RequestDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestDate()
    {
        return isset($this->RequestDate) ? $this->RequestDate : null;
    }
    /**
     * Set RequestDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestDate
     * @return \patest\StructType\AccessControl_HttpApiRequest
     */
    public function setRequestDate($requestDate = null)
    {
        // validation for constraint: string
        if (!is_null($requestDate) && !is_string($requestDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestDate, true), gettype($requestDate)), __LINE__);
        }
        if (is_null($requestDate) || (is_array($requestDate) && empty($requestDate))) {
            unset($this->RequestDate);
        } else {
            $this->RequestDate = $requestDate;
        }
        return $this;
    }
    /**
     * Get RequestId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRequestId()
    {
        return isset($this->RequestId) ? $this->RequestId : null;
    }
    /**
     * Set RequestId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $requestId
     * @return \patest\StructType\AccessControl_HttpApiRequest
     */
    public function setRequestId($requestId = null)
    {
        // validation for constraint: string
        if (!is_null($requestId) && !is_string($requestId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($requestId, true), gettype($requestId)), __LINE__);
        }
        if (is_null($requestId) || (is_array($requestId) && empty($requestId))) {
            unset($this->RequestId);
        } else {
            $this->RequestId = $requestId;
        }
        return $this;
    }
    /**
     * Get State value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getState()
    {
        return isset($this->State) ? $this->State : null;
    }
    /**
     * Set State value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\HttpApiRequestState::valueIsValid()
     * @uses \patest\EnumType\HttpApiRequestState::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $state
     * @return \patest\StructType\AccessControl_HttpApiRequest
     */
    public function setState($state = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\HttpApiRequestState::valueIsValid($state)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\HttpApiRequestState', is_array($state) ? implode(', ', $state) : var_export($state, true), implode(', ', \patest\EnumType\HttpApiRequestState::getValidValues())), __LINE__);
        }
        if (is_null($state) || (is_array($state) && empty($state))) {
            unset($this->State);
        } else {
            $this->State = $state;
        }
        return $this;
    }
}
