<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.ExternalBarcodesProvider StructType
 * @subpackage Structs
 */
class AccessControl_ExternalBarcodesProvider extends MaintainableNotDistributableGlobalizedEntity
{
    /**
     * The ConfigEntityName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConfigEntityName;
    /**
     * The CustomConfig
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomConfig;
    /**
     * The ExternalBarcodesProviderType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExternalBarcodesProviderType;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for AccessControl.ExternalBarcodesProvider
     * @uses AccessControl_ExternalBarcodesProvider::setConfigEntityName()
     * @uses AccessControl_ExternalBarcodesProvider::setCustomConfig()
     * @uses AccessControl_ExternalBarcodesProvider::setExternalBarcodesProviderType()
     * @uses AccessControl_ExternalBarcodesProvider::setIsActive()
     * @uses AccessControl_ExternalBarcodesProvider::setOrganizationUnitId()
     * @uses AccessControl_ExternalBarcodesProvider::setVisibleBySubordinates()
     * @param string $configEntityName
     * @param string $customConfig
     * @param string $externalBarcodesProviderType
     * @param bool $isActive
     * @param string $organizationUnitId
     * @param bool $visibleBySubordinates
     */
    public function __construct($configEntityName = null, $customConfig = null, $externalBarcodesProviderType = null, $isActive = null, $organizationUnitId = null, $visibleBySubordinates = null)
    {
        $this
            ->setConfigEntityName($configEntityName)
            ->setCustomConfig($customConfig)
            ->setExternalBarcodesProviderType($externalBarcodesProviderType)
            ->setIsActive($isActive)
            ->setOrganizationUnitId($organizationUnitId)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get ConfigEntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConfigEntityName()
    {
        return isset($this->ConfigEntityName) ? $this->ConfigEntityName : null;
    }
    /**
     * Set ConfigEntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $configEntityName
     * @return \patest\StructType\AccessControl_ExternalBarcodesProvider
     */
    public function setConfigEntityName($configEntityName = null)
    {
        // validation for constraint: string
        if (!is_null($configEntityName) && !is_string($configEntityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($configEntityName, true), gettype($configEntityName)), __LINE__);
        }
        if (is_null($configEntityName) || (is_array($configEntityName) && empty($configEntityName))) {
            unset($this->ConfigEntityName);
        } else {
            $this->ConfigEntityName = $configEntityName;
        }
        return $this;
    }
    /**
     * Get CustomConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomConfig()
    {
        return isset($this->CustomConfig) ? $this->CustomConfig : null;
    }
    /**
     * Set CustomConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customConfig
     * @return \patest\StructType\AccessControl_ExternalBarcodesProvider
     */
    public function setCustomConfig($customConfig = null)
    {
        // validation for constraint: string
        if (!is_null($customConfig) && !is_string($customConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customConfig, true), gettype($customConfig)), __LINE__);
        }
        if (is_null($customConfig) || (is_array($customConfig) && empty($customConfig))) {
            unset($this->CustomConfig);
        } else {
            $this->CustomConfig = $customConfig;
        }
        return $this;
    }
    /**
     * Get ExternalBarcodesProviderType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExternalBarcodesProviderType()
    {
        return isset($this->ExternalBarcodesProviderType) ? $this->ExternalBarcodesProviderType : null;
    }
    /**
     * Set ExternalBarcodesProviderType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $externalBarcodesProviderType
     * @return \patest\StructType\AccessControl_ExternalBarcodesProvider
     */
    public function setExternalBarcodesProviderType($externalBarcodesProviderType = null)
    {
        // validation for constraint: string
        if (!is_null($externalBarcodesProviderType) && !is_string($externalBarcodesProviderType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($externalBarcodesProviderType, true), gettype($externalBarcodesProviderType)), __LINE__);
        }
        if (is_null($externalBarcodesProviderType) || (is_array($externalBarcodesProviderType) && empty($externalBarcodesProviderType))) {
            unset($this->ExternalBarcodesProviderType);
        } else {
            $this->ExternalBarcodesProviderType = $externalBarcodesProviderType;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\AccessControl_ExternalBarcodesProvider
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\AccessControl_ExternalBarcodesProvider
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\AccessControl_ExternalBarcodesProvider
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
