<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.BarcodeProvider StructType
 * @subpackage Structs
 */
class AccessControl_BarcodeProvider extends MaintainableNotDistributableGlobalizedEntity
{
    /**
     * The BarcodeGeneratorConfig
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeGeneratorConfig;
    /**
     * The BarcodeGeneratorId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BarcodeGeneratorId;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The RequiresManuallyEnteredBarcodes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RequiresManuallyEnteredBarcodes;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for AccessControl.BarcodeProvider
     * @uses AccessControl_BarcodeProvider::setBarcodeGeneratorConfig()
     * @uses AccessControl_BarcodeProvider::setBarcodeGeneratorId()
     * @uses AccessControl_BarcodeProvider::setIsActive()
     * @uses AccessControl_BarcodeProvider::setOrganizationUnitId()
     * @uses AccessControl_BarcodeProvider::setRequiresManuallyEnteredBarcodes()
     * @uses AccessControl_BarcodeProvider::setVisibleBySubordinates()
     * @param string $barcodeGeneratorConfig
     * @param string $barcodeGeneratorId
     * @param bool $isActive
     * @param string $organizationUnitId
     * @param bool $requiresManuallyEnteredBarcodes
     * @param bool $visibleBySubordinates
     */
    public function __construct($barcodeGeneratorConfig = null, $barcodeGeneratorId = null, $isActive = null, $organizationUnitId = null, $requiresManuallyEnteredBarcodes = null, $visibleBySubordinates = null)
    {
        $this
            ->setBarcodeGeneratorConfig($barcodeGeneratorConfig)
            ->setBarcodeGeneratorId($barcodeGeneratorId)
            ->setIsActive($isActive)
            ->setOrganizationUnitId($organizationUnitId)
            ->setRequiresManuallyEnteredBarcodes($requiresManuallyEnteredBarcodes)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get BarcodeGeneratorConfig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeGeneratorConfig()
    {
        return isset($this->BarcodeGeneratorConfig) ? $this->BarcodeGeneratorConfig : null;
    }
    /**
     * Set BarcodeGeneratorConfig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeGeneratorConfig
     * @return \patest\StructType\AccessControl_BarcodeProvider
     */
    public function setBarcodeGeneratorConfig($barcodeGeneratorConfig = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeGeneratorConfig) && !is_string($barcodeGeneratorConfig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeGeneratorConfig, true), gettype($barcodeGeneratorConfig)), __LINE__);
        }
        if (is_null($barcodeGeneratorConfig) || (is_array($barcodeGeneratorConfig) && empty($barcodeGeneratorConfig))) {
            unset($this->BarcodeGeneratorConfig);
        } else {
            $this->BarcodeGeneratorConfig = $barcodeGeneratorConfig;
        }
        return $this;
    }
    /**
     * Get BarcodeGeneratorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcodeGeneratorId()
    {
        return isset($this->BarcodeGeneratorId) ? $this->BarcodeGeneratorId : null;
    }
    /**
     * Set BarcodeGeneratorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcodeGeneratorId
     * @return \patest\StructType\AccessControl_BarcodeProvider
     */
    public function setBarcodeGeneratorId($barcodeGeneratorId = null)
    {
        // validation for constraint: string
        if (!is_null($barcodeGeneratorId) && !is_string($barcodeGeneratorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcodeGeneratorId, true), gettype($barcodeGeneratorId)), __LINE__);
        }
        if (is_null($barcodeGeneratorId) || (is_array($barcodeGeneratorId) && empty($barcodeGeneratorId))) {
            unset($this->BarcodeGeneratorId);
        } else {
            $this->BarcodeGeneratorId = $barcodeGeneratorId;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\AccessControl_BarcodeProvider
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\AccessControl_BarcodeProvider
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get RequiresManuallyEnteredBarcodes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRequiresManuallyEnteredBarcodes()
    {
        return isset($this->RequiresManuallyEnteredBarcodes) ? $this->RequiresManuallyEnteredBarcodes : null;
    }
    /**
     * Set RequiresManuallyEnteredBarcodes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $requiresManuallyEnteredBarcodes
     * @return \patest\StructType\AccessControl_BarcodeProvider
     */
    public function setRequiresManuallyEnteredBarcodes($requiresManuallyEnteredBarcodes = null)
    {
        // validation for constraint: boolean
        if (!is_null($requiresManuallyEnteredBarcodes) && !is_bool($requiresManuallyEnteredBarcodes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($requiresManuallyEnteredBarcodes, true), gettype($requiresManuallyEnteredBarcodes)), __LINE__);
        }
        if (is_null($requiresManuallyEnteredBarcodes) || (is_array($requiresManuallyEnteredBarcodes) && empty($requiresManuallyEnteredBarcodes))) {
            unset($this->RequiresManuallyEnteredBarcodes);
        } else {
            $this->RequiresManuallyEnteredBarcodes = $requiresManuallyEnteredBarcodes;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\AccessControl_BarcodeProvider
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
