<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.BarcodeInfo.Ticket StructType
 * @subpackage Structs
 */
class AccessControl_BarcodeInfo_Ticket extends AccessControl_BarcodeInfo_TerminalEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AreaName;
    /**
     * The CustomProperty1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CustomProperty1;
    /**
     * The Gates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name
     */
    public $Gates;
    /**
     * The GatesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GatesSummary;
    /**
     * The IsResold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsResold;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The Scanners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name
     */
    public $Scanners;
    /**
     * The ScannersSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScannersSummary;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorName;
    /**
     * The StandName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $StandName;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketNumber;
    /**
     * The Turnstiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name
     */
    public $Turnstiles;
    /**
     * The TurnstilesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TurnstilesSummary;
    /**
     * Constructor method for AccessControl.BarcodeInfo.Ticket
     * @uses AccessControl_BarcodeInfo_Ticket::setAreaId()
     * @uses AccessControl_BarcodeInfo_Ticket::setAreaName()
     * @uses AccessControl_BarcodeInfo_Ticket::setCustomProperty1()
     * @uses AccessControl_BarcodeInfo_Ticket::setGates()
     * @uses AccessControl_BarcodeInfo_Ticket::setGatesSummary()
     * @uses AccessControl_BarcodeInfo_Ticket::setIsResold()
     * @uses AccessControl_BarcodeInfo_Ticket::setRowName()
     * @uses AccessControl_BarcodeInfo_Ticket::setScanners()
     * @uses AccessControl_BarcodeInfo_Ticket::setScannersSummary()
     * @uses AccessControl_BarcodeInfo_Ticket::setSeatName()
     * @uses AccessControl_BarcodeInfo_Ticket::setSectorName()
     * @uses AccessControl_BarcodeInfo_Ticket::setStandName()
     * @uses AccessControl_BarcodeInfo_Ticket::setTicketNumber()
     * @uses AccessControl_BarcodeInfo_Ticket::setTurnstiles()
     * @uses AccessControl_BarcodeInfo_Ticket::setTurnstilesSummary()
     * @param string $areaId
     * @param \patest\StructType\GlobalString $areaName
     * @param string $customProperty1
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $gates
     * @param string $gatesSummary
     * @param bool $isResold
     * @param string $rowName
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $scanners
     * @param string $scannersSummary
     * @param string $seatName
     * @param \patest\StructType\GlobalString $sectorName
     * @param \patest\StructType\GlobalString $standName
     * @param int $ticketNumber
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $turnstiles
     * @param string $turnstilesSummary
     */
    public function __construct($areaId = null, \patest\StructType\GlobalString $areaName = null, $customProperty1 = null, \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $gates = null, $gatesSummary = null, $isResold = null, $rowName = null, \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $scanners = null, $scannersSummary = null, $seatName = null, \patest\StructType\GlobalString $sectorName = null, \patest\StructType\GlobalString $standName = null, $ticketNumber = null, \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $turnstiles = null, $turnstilesSummary = null)
    {
        $this
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setCustomProperty1($customProperty1)
            ->setGates($gates)
            ->setGatesSummary($gatesSummary)
            ->setIsResold($isResold)
            ->setRowName($rowName)
            ->setScanners($scanners)
            ->setScannersSummary($scannersSummary)
            ->setSeatName($seatName)
            ->setSectorName($sectorName)
            ->setStandName($standName)
            ->setTicketNumber($ticketNumber)
            ->setTurnstiles($turnstiles)
            ->setTurnstilesSummary($turnstilesSummary);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $areaName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setAreaName(\patest\StructType\GlobalString $areaName = null)
    {
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get CustomProperty1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCustomProperty1()
    {
        return isset($this->CustomProperty1) ? $this->CustomProperty1 : null;
    }
    /**
     * Set CustomProperty1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $customProperty1
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setCustomProperty1($customProperty1 = null)
    {
        // validation for constraint: string
        if (!is_null($customProperty1) && !is_string($customProperty1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($customProperty1, true), gettype($customProperty1)), __LINE__);
        }
        if (is_null($customProperty1) || (is_array($customProperty1) && empty($customProperty1))) {
            unset($this->CustomProperty1);
        } else {
            $this->CustomProperty1 = $customProperty1;
        }
        return $this;
    }
    /**
     * Get Gates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name|null
     */
    public function getGates()
    {
        return isset($this->Gates) ? $this->Gates : null;
    }
    /**
     * Set Gates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $gates
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setGates(\patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $gates = null)
    {
        if (is_null($gates) || (is_array($gates) && empty($gates))) {
            unset($this->Gates);
        } else {
            $this->Gates = $gates;
        }
        return $this;
    }
    /**
     * Get GatesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGatesSummary()
    {
        return isset($this->GatesSummary) ? $this->GatesSummary : null;
    }
    /**
     * Set GatesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gatesSummary
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setGatesSummary($gatesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($gatesSummary) && !is_string($gatesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gatesSummary, true), gettype($gatesSummary)), __LINE__);
        }
        if (is_null($gatesSummary) || (is_array($gatesSummary) && empty($gatesSummary))) {
            unset($this->GatesSummary);
        } else {
            $this->GatesSummary = $gatesSummary;
        }
        return $this;
    }
    /**
     * Get IsResold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsResold()
    {
        return isset($this->IsResold) ? $this->IsResold : null;
    }
    /**
     * Set IsResold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isResold
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setIsResold($isResold = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResold) && !is_bool($isResold)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResold, true), gettype($isResold)), __LINE__);
        }
        if (is_null($isResold) || (is_array($isResold) && empty($isResold))) {
            unset($this->IsResold);
        } else {
            $this->IsResold = $isResold;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get Scanners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name|null
     */
    public function getScanners()
    {
        return isset($this->Scanners) ? $this->Scanners : null;
    }
    /**
     * Set Scanners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $scanners
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setScanners(\patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $scanners = null)
    {
        if (is_null($scanners) || (is_array($scanners) && empty($scanners))) {
            unset($this->Scanners);
        } else {
            $this->Scanners = $scanners;
        }
        return $this;
    }
    /**
     * Get ScannersSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScannersSummary()
    {
        return isset($this->ScannersSummary) ? $this->ScannersSummary : null;
    }
    /**
     * Set ScannersSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scannersSummary
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setScannersSummary($scannersSummary = null)
    {
        // validation for constraint: string
        if (!is_null($scannersSummary) && !is_string($scannersSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannersSummary, true), gettype($scannersSummary)), __LINE__);
        }
        if (is_null($scannersSummary) || (is_array($scannersSummary) && empty($scannersSummary))) {
            unset($this->ScannersSummary);
        } else {
            $this->ScannersSummary = $scannersSummary;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setSectorName(\patest\StructType\GlobalString $sectorName = null)
    {
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get StandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getStandName()
    {
        return isset($this->StandName) ? $this->StandName : null;
    }
    /**
     * Set StandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $standName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setStandName(\patest\StructType\GlobalString $standName = null)
    {
        if (is_null($standName) || (is_array($standName) && empty($standName))) {
            unset($this->StandName);
        } else {
            $this->StandName = $standName;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketNumber()
    {
        return isset($this->TicketNumber) ? $this->TicketNumber : null;
    }
    /**
     * Set TicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketNumber
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        if (is_null($ticketNumber) || (is_array($ticketNumber) && empty($ticketNumber))) {
            unset($this->TicketNumber);
        } else {
            $this->TicketNumber = $ticketNumber;
        }
        return $this;
    }
    /**
     * Get Turnstiles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name|null
     */
    public function getTurnstiles()
    {
        return isset($this->Turnstiles) ? $this->Turnstiles : null;
    }
    /**
     * Set Turnstiles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $turnstiles
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setTurnstiles(\patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $turnstiles = null)
    {
        if (is_null($turnstiles) || (is_array($turnstiles) && empty($turnstiles))) {
            unset($this->Turnstiles);
        } else {
            $this->Turnstiles = $turnstiles;
        }
        return $this;
    }
    /**
     * Get TurnstilesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnstilesSummary()
    {
        return isset($this->TurnstilesSummary) ? $this->TurnstilesSummary : null;
    }
    /**
     * Set TurnstilesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnstilesSummary
     * @return \patest\StructType\AccessControl_BarcodeInfo_Ticket
     */
    public function setTurnstilesSummary($turnstilesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($turnstilesSummary) && !is_string($turnstilesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnstilesSummary, true), gettype($turnstilesSummary)), __LINE__);
        }
        if (is_null($turnstilesSummary) || (is_array($turnstilesSummary) && empty($turnstilesSummary))) {
            unset($this->TurnstilesSummary);
        } else {
            $this->TurnstilesSummary = $turnstilesSummary;
        }
        return $this;
    }
}
