<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccessControl.BarcodeInfo.Subscription StructType
 * @subpackage Structs
 */
class AccessControl_BarcodeInfo_Subscription extends AccessControl_BarcodeInfo_NonTerminalEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $AreaName;
    /**
     * The Gates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name
     */
    public $Gates;
    /**
     * The GatesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GatesSummary;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The Scanners
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name
     */
    public $Scanners;
    /**
     * The ScannersSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ScannersSummary;
    /**
     * The SeasonName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SeasonName;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SectorName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorName;
    /**
     * The SeriesName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SeriesName;
    /**
     * The StandName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $StandName;
    /**
     * The SubscriptionNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SubscriptionNumber;
    /**
     * The Turnstiles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name
     */
    public $Turnstiles;
    /**
     * The TurnstilesSummary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TurnstilesSummary;
    /**
     * Constructor method for AccessControl.BarcodeInfo.Subscription
     * @uses AccessControl_BarcodeInfo_Subscription::setAreaId()
     * @uses AccessControl_BarcodeInfo_Subscription::setAreaName()
     * @uses AccessControl_BarcodeInfo_Subscription::setGates()
     * @uses AccessControl_BarcodeInfo_Subscription::setGatesSummary()
     * @uses AccessControl_BarcodeInfo_Subscription::setHallName()
     * @uses AccessControl_BarcodeInfo_Subscription::setRowName()
     * @uses AccessControl_BarcodeInfo_Subscription::setScanners()
     * @uses AccessControl_BarcodeInfo_Subscription::setScannersSummary()
     * @uses AccessControl_BarcodeInfo_Subscription::setSeasonName()
     * @uses AccessControl_BarcodeInfo_Subscription::setSeatName()
     * @uses AccessControl_BarcodeInfo_Subscription::setSectorName()
     * @uses AccessControl_BarcodeInfo_Subscription::setSeriesName()
     * @uses AccessControl_BarcodeInfo_Subscription::setStandName()
     * @uses AccessControl_BarcodeInfo_Subscription::setSubscriptionNumber()
     * @uses AccessControl_BarcodeInfo_Subscription::setTurnstiles()
     * @uses AccessControl_BarcodeInfo_Subscription::setTurnstilesSummary()
     * @param string $areaId
     * @param \patest\StructType\GlobalString $areaName
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $gates
     * @param string $gatesSummary
     * @param \patest\StructType\GlobalString $hallName
     * @param string $rowName
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $scanners
     * @param string $scannersSummary
     * @param \patest\StructType\GlobalString $seasonName
     * @param string $seatName
     * @param \patest\StructType\GlobalString $sectorName
     * @param \patest\StructType\GlobalString $seriesName
     * @param \patest\StructType\GlobalString $standName
     * @param string $subscriptionNumber
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $turnstiles
     * @param string $turnstilesSummary
     */
    public function __construct($areaId = null, \patest\StructType\GlobalString $areaName = null, \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $gates = null, $gatesSummary = null, \patest\StructType\GlobalString $hallName = null, $rowName = null, \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $scanners = null, $scannersSummary = null, \patest\StructType\GlobalString $seasonName = null, $seatName = null, \patest\StructType\GlobalString $sectorName = null, \patest\StructType\GlobalString $seriesName = null, \patest\StructType\GlobalString $standName = null, $subscriptionNumber = null, \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $turnstiles = null, $turnstilesSummary = null)
    {
        $this
            ->setAreaId($areaId)
            ->setAreaName($areaName)
            ->setGates($gates)
            ->setGatesSummary($gatesSummary)
            ->setHallName($hallName)
            ->setRowName($rowName)
            ->setScanners($scanners)
            ->setScannersSummary($scannersSummary)
            ->setSeasonName($seasonName)
            ->setSeatName($seatName)
            ->setSectorName($sectorName)
            ->setSeriesName($seriesName)
            ->setStandName($standName)
            ->setSubscriptionNumber($subscriptionNumber)
            ->setTurnstiles($turnstiles)
            ->setTurnstilesSummary($turnstilesSummary);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getAreaName()
    {
        return isset($this->AreaName) ? $this->AreaName : null;
    }
    /**
     * Set AreaName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $areaName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setAreaName(\patest\StructType\GlobalString $areaName = null)
    {
        if (is_null($areaName) || (is_array($areaName) && empty($areaName))) {
            unset($this->AreaName);
        } else {
            $this->AreaName = $areaName;
        }
        return $this;
    }
    /**
     * Get Gates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name|null
     */
    public function getGates()
    {
        return isset($this->Gates) ? $this->Gates : null;
    }
    /**
     * Set Gates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $gates
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setGates(\patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $gates = null)
    {
        if (is_null($gates) || (is_array($gates) && empty($gates))) {
            unset($this->Gates);
        } else {
            $this->Gates = $gates;
        }
        return $this;
    }
    /**
     * Get GatesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGatesSummary()
    {
        return isset($this->GatesSummary) ? $this->GatesSummary : null;
    }
    /**
     * Set GatesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gatesSummary
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setGatesSummary($gatesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($gatesSummary) && !is_string($gatesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gatesSummary, true), gettype($gatesSummary)), __LINE__);
        }
        if (is_null($gatesSummary) || (is_array($gatesSummary) && empty($gatesSummary))) {
            unset($this->GatesSummary);
        } else {
            $this->GatesSummary = $gatesSummary;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get Scanners value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name|null
     */
    public function getScanners()
    {
        return isset($this->Scanners) ? $this->Scanners : null;
    }
    /**
     * Set Scanners value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $scanners
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setScanners(\patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $scanners = null)
    {
        if (is_null($scanners) || (is_array($scanners) && empty($scanners))) {
            unset($this->Scanners);
        } else {
            $this->Scanners = $scanners;
        }
        return $this;
    }
    /**
     * Get ScannersSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getScannersSummary()
    {
        return isset($this->ScannersSummary) ? $this->ScannersSummary : null;
    }
    /**
     * Set ScannersSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $scannersSummary
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setScannersSummary($scannersSummary = null)
    {
        // validation for constraint: string
        if (!is_null($scannersSummary) && !is_string($scannersSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($scannersSummary, true), gettype($scannersSummary)), __LINE__);
        }
        if (is_null($scannersSummary) || (is_array($scannersSummary) && empty($scannersSummary))) {
            unset($this->ScannersSummary);
        } else {
            $this->ScannersSummary = $scannersSummary;
        }
        return $this;
    }
    /**
     * Get SeasonName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSeasonName()
    {
        return isset($this->SeasonName) ? $this->SeasonName : null;
    }
    /**
     * Set SeasonName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $seasonName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setSeasonName(\patest\StructType\GlobalString $seasonName = null)
    {
        if (is_null($seasonName) || (is_array($seasonName) && empty($seasonName))) {
            unset($this->SeasonName);
        } else {
            $this->SeasonName = $seasonName;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SectorName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorName()
    {
        return isset($this->SectorName) ? $this->SectorName : null;
    }
    /**
     * Set SectorName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setSectorName(\patest\StructType\GlobalString $sectorName = null)
    {
        if (is_null($sectorName) || (is_array($sectorName) && empty($sectorName))) {
            unset($this->SectorName);
        } else {
            $this->SectorName = $sectorName;
        }
        return $this;
    }
    /**
     * Get SeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSeriesName()
    {
        return isset($this->SeriesName) ? $this->SeriesName : null;
    }
    /**
     * Set SeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $seriesName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setSeriesName(\patest\StructType\GlobalString $seriesName = null)
    {
        if (is_null($seriesName) || (is_array($seriesName) && empty($seriesName))) {
            unset($this->SeriesName);
        } else {
            $this->SeriesName = $seriesName;
        }
        return $this;
    }
    /**
     * Get StandName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getStandName()
    {
        return isset($this->StandName) ? $this->StandName : null;
    }
    /**
     * Set StandName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $standName
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setStandName(\patest\StructType\GlobalString $standName = null)
    {
        if (is_null($standName) || (is_array($standName) && empty($standName))) {
            unset($this->StandName);
        } else {
            $this->StandName = $standName;
        }
        return $this;
    }
    /**
     * Get SubscriptionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionNumber()
    {
        return isset($this->SubscriptionNumber) ? $this->SubscriptionNumber : null;
    }
    /**
     * Set SubscriptionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionNumber
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setSubscriptionNumber($subscriptionNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionNumber) && !is_string($subscriptionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionNumber, true), gettype($subscriptionNumber)), __LINE__);
        }
        if (is_null($subscriptionNumber) || (is_array($subscriptionNumber) && empty($subscriptionNumber))) {
            unset($this->SubscriptionNumber);
        } else {
            $this->SubscriptionNumber = $subscriptionNumber;
        }
        return $this;
    }
    /**
     * Get Turnstiles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name|null
     */
    public function getTurnstiles()
    {
        return isset($this->Turnstiles) ? $this->Turnstiles : null;
    }
    /**
     * Set Turnstiles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $turnstiles
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setTurnstiles(\patest\StructType\RecordSetOfAccessControl_BarcodeInfo_Name $turnstiles = null)
    {
        if (is_null($turnstiles) || (is_array($turnstiles) && empty($turnstiles))) {
            unset($this->Turnstiles);
        } else {
            $this->Turnstiles = $turnstiles;
        }
        return $this;
    }
    /**
     * Get TurnstilesSummary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnstilesSummary()
    {
        return isset($this->TurnstilesSummary) ? $this->TurnstilesSummary : null;
    }
    /**
     * Set TurnstilesSummary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnstilesSummary
     * @return \patest\StructType\AccessControl_BarcodeInfo_Subscription
     */
    public function setTurnstilesSummary($turnstilesSummary = null)
    {
        // validation for constraint: string
        if (!is_null($turnstilesSummary) && !is_string($turnstilesSummary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnstilesSummary, true), gettype($turnstilesSummary)), __LINE__);
        }
        if (is_null($turnstilesSummary) || (is_array($turnstilesSummary) && empty($turnstilesSummary))) {
            unset($this->TurnstilesSummary);
        } else {
            $this->TurnstilesSummary = $turnstilesSummary;
        }
        return $this;
    }
}
