<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Verify ServiceType
 * @subpackage Services
 */
class Verify extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\ArrayType\ArrayOfKeyValueOfstringstring $context, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://toptix.com/2008', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named VerifyLogin
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\VerifyLogin_Request $iCrmFacade_VerifyLogin_RequestMsg
     * @return \patest\StructType\Verifylogin_Response|bool
     */
    public function VerifyLogin(\patest\StructType\VerifyLogin_Request $iCrmFacade_VerifyLogin_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->VerifyLogin($iCrmFacade_VerifyLogin_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VerifyAccount
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\VerifyAccount_Request $iCrmFacade_VerifyAccount_RequestMsg
     * @return \patest\StructType\VerifyAccount_Response|bool
     */
    public function VerifyAccount(\patest\StructType\VerifyAccount_Request $iCrmFacade_VerifyAccount_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->VerifyAccount($iCrmFacade_VerifyAccount_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VerifyAndSaveDeviceIds
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\VerifyAndSaveDeviceIdsRequest $iEsroFacade_VerifyAndSaveDeviceIds_RequestMsg
     * @return \patest\StructType\VerifyAndSaveDeviceIdsResponse|bool
     */
    public function VerifyAndSaveDeviceIds(\patest\StructType\VerifyAndSaveDeviceIdsRequest $iEsroFacade_VerifyAndSaveDeviceIds_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->VerifyAndSaveDeviceIds($iEsroFacade_VerifyAndSaveDeviceIds_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named VerifyTicketIsForwardableToOwner
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://toptix.com/2008, http://toptix.com/2008
     * - SOAPHeaderTypes: \patest\ArrayType\ArrayOfKeyValueOfstringstring, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\VerifyTicketIsForwardableToOwnerRequest $iEsroFacade_VerifyTicketIsForwardableToOwner_RequestMsg
     * @return \patest\StructType\VerifyTicketIsForwardableToOwnerResponse|bool
     */
    public function VerifyTicketIsForwardableToOwner(\patest\StructType\VerifyTicketIsForwardableToOwnerRequest $iEsroFacade_VerifyTicketIsForwardableToOwner_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->VerifyTicketIsForwardableToOwner($iEsroFacade_VerifyTicketIsForwardableToOwner_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\VerifyAccount_Response|\patest\StructType\VerifyAndSaveDeviceIdsResponse|\patest\StructType\Verifylogin_Response|\patest\StructType\VerifyTicketIsForwardableToOwnerResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
