<?php

namespace patest\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Sync ServiceType
 * @subpackage Services
 */
class Sync extends AbstractSoapClientBase
{
    /**
     * Sets the Context SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\Context $context
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderContext(\patest\StructType\Context $context, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'Context', $context, $mustUnderstand, $actor);
    }
    /**
     * Sets the SroBusinessFlow SoapHeader param
     * @uses AbstractSoapClientBase::setSoapHeader()
     * @param \patest\StructType\SroBusinessFlow $sroBusinessFlow
     * @param string $nameSpace
     * @param bool $mustUnderstand
     * @param string $actor
     * @return bool
     */
    public function setSoapHeaderSroBusinessFlow(\patest\StructType\SroBusinessFlow $sroBusinessFlow, $nameSpace = 'http://foundation.toptix.com/2007', $mustUnderstand = false, $actor = null)
    {
        return $this->setSoapHeader($nameSpace, 'SroBusinessFlow', $sroBusinessFlow, $mustUnderstand, $actor);
    }
    /**
     * Method to call the operation originally named SyncEntitiesFromExternalSource
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SyncEntitiesFromExternalSourceRequest $iIntegrationService_SyncEntitiesFromExternalSource_RequestMsg
     * @return \patest\StructType\SyncEntitiesFromExternalSourceResponse|bool
     */
    public function SyncEntitiesFromExternalSource(\patest\StructType\SyncEntitiesFromExternalSourceRequest $iIntegrationService_SyncEntitiesFromExternalSource_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SyncEntitiesFromExternalSource($iIntegrationService_SyncEntitiesFromExternalSource_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named SyncEntitiesFromExternalSourceEx
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SyncEntitiesFromExternalSourceRequestEx $iIntegrationService_SyncEntitiesFromExternalSourceEx_RequestMsg
     * @return \patest\StructType\SyncEntitiesFromExternalSourceResponseEx|bool
     */
    public function SyncEntitiesFromExternalSourceEx(\patest\StructType\SyncEntitiesFromExternalSourceRequestEx $iIntegrationService_SyncEntitiesFromExternalSourceEx_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SyncEntitiesFromExternalSourceEx($iIntegrationService_SyncEntitiesFromExternalSourceEx_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * SyncDeletedEntitiesFromExternalSource
     * Meta information extracted from the WSDL
     * - SOAPHeaderNames: Context, SroBusinessFlow
     * - SOAPHeaderNamespaces: http://foundation.toptix.com/2007, http://foundation.toptix.com/2007
     * - SOAPHeaderTypes: \patest\StructType\Context, \patest\StructType\SroBusinessFlow
     * - SOAPHeaders: required, required
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \patest\StructType\SyncDeletedEntitiesFromExternalSourceRequest $iIntegrationService_SyncDeletedEntitiesFromExternalSource_RequestMsg
     * @return \patest\StructType\SyncDeletedEntitiesFromExternalSourceResponse|bool
     */
    public function SyncDeletedEntitiesFromExternalSource(\patest\StructType\SyncDeletedEntitiesFromExternalSourceRequest $iIntegrationService_SyncDeletedEntitiesFromExternalSource_RequestMsg)
    {
        try {
            $this->setResult($this->getSoapClient()->SyncDeletedEntitiesFromExternalSource($iIntegrationService_SyncDeletedEntitiesFromExternalSource_RequestMsg));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \patest\StructType\SyncDeletedEntitiesFromExternalSourceResponse|\patest\StructType\SyncEntitiesFromExternalSourceResponse|\patest\StructType\SyncEntitiesFromExternalSourceResponseEx
     */
    public function getResult()
    {
        return parent::getResult();
    }
}
